/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation;

import com.sun.swup.client.common.UpdateMgrProperties;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.Application;
import com.sun.swup.client.ui.WarningDialog;
import com.sun.swup.client.ui.foundation.LinkStyleButtonFocusListener;
import com.sun.swup.client.ui.foundation.LinkStyleButtonMouseListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Utility {
    public static Dimension VGAP5 = new Dimension(1, 5);
    public static Dimension VGAP10 = new Dimension(1, 10);

    public static void centerOverFrame(JFrame subFrame, JFrame parentFrame) {
        double iX = parentFrame.getLocation().getX() + (double)((parentFrame.getSize().width - subFrame.getSize().width) / 2);
        double iY = parentFrame.getLocation().getY() + (double)((parentFrame.getSize().height - subFrame.getSize().height) / 6);
        subFrame.setLocation((int)iX, (int)iY);
    }

    public static void centerOverFrame(JDialog dialog, JFrame parentFrame) {
        double iX = parentFrame.getLocation().getX() + (double)((parentFrame.getSize().width - dialog.getSize().width) / 2);
        double iY = parentFrame.getLocation().getY() + (double)((parentFrame.getSize().height - dialog.getSize().height) / 6);
        dialog.setLocation((int)iX, (int)iY);
    }

    public static void centerOverScreen(Window window) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        double iX = (d.width - window.getSize().width) / 2;
        double iY = (d.height - window.getSize().height) / 6;
        window.setLocation((int)iX, (int)iY);
    }

    public static String checkNull(String sString) {
        if (sString == null) {
            return "";
        }
        return sString;
    }

    public static Integer checkNull(Integer integer) {
        if (integer == null) {
            return new Integer(0);
        }
        return integer;
    }

    public static Font getReducedFont(JComponent component, String sKey) {
        return component.getFont().deriveFont((float)component.getFont().getSize() - (float)Environment.getInteger((String)sKey));
    }

    public static void alert(String sTitle, String sMajor) {
        JOptionPane.showMessageDialog(null, sMajor, sTitle, 0);
    }

    public static void alert(String sTitle, String sMajor, String sMinor) {
        JOptionPane.showMessageDialog(null, sMajor, sTitle, 0);
    }

    public static void openPortalURL() {
        try {
            String url = UpdateMgrProperties.getInstance().getProperty("manageURL");
            if (url != null) {
                Utility.openURL(url);
            } else {
                MessageFormat msgFmt = new MessageFormat(Application.I18N.getString("url-properties-error-null"));
                Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties", "manageURL"};
                WarningDialog warnDialog = new WarningDialog((Frame)Application.getInstance().getUpdateFrame(), Application.I18N.getString("url-properties-error-title"), msgFmt.format(msgArgs));
                Utility.centerOverFrame(warnDialog, (JFrame)Application.getInstance().getUpdateFrame());
                warnDialog.setVisible(true);
            }
        }
        catch (IOException io) {
            MessageFormat msgFmt = new MessageFormat(Application.I18N.getString("url-properties-error-file"));
            Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties"};
            WarningDialog warnDialog = new WarningDialog((Frame)Application.getInstance().getUpdateFrame(), Application.I18N.getString("url-properties-error-title"), msgFmt.format(msgArgs));
            Utility.centerOverFrame(warnDialog, (JFrame)Application.getInstance().getUpdateFrame());
            warnDialog.setVisible(true);
        }
    }

    public static void openURL(String sURL) {
        UpdateMgrUtil umUtil = UpdateMgrUtil.getInstance();
        umUtil.launchWebClient((JFrame)Application.getInstance().getUpdateFrame(), sURL);
    }

    public static JButton createLinkStyleButton(Action action) {
        JButton linkStyleButton = new JButton(action);
        linkStyleButton.setMaximumSize(linkStyleButton.getPreferredSize());
        linkStyleButton.setContentAreaFilled(false);
        linkStyleButton.setBorder(BorderFactory.createLineBorder(Color.black));
        linkStyleButton.setBorderPainted(false);
        linkStyleButton.setFocusPainted(false);
        linkStyleButton.addFocusListener(new LinkStyleButtonFocusListener());
        linkStyleButton.addMouseListener(new LinkStyleButtonMouseListener());
        linkStyleButton.setMnemonic(Application.I18N.getString("menu-file-enable-portal.mnemonic").charAt(0));
        linkStyleButton.setToolTipText(Application.I18N.getString("menu-file-enable-portal"));
        return linkStyleButton;
    }
}

