/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation.swing;

import com.sun.swup.client.ui.foundation.swing.GenericTableColumnModel;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeaderRenderer;
import com.sun.swup.client.ui.foundation.swing.SortedTableModel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SortedTableHeader
extends JTableHeader
implements MouseListener,
MouseMotionListener {
    private int iPressedColumn = -1;
    private boolean bPressedColumnPainted = false;
    private int iSortColumn = -1;
    private int iSortDirection = 1;
    private boolean bResizing = false;

    public SortedTableHeader(TableColumnModel columnModel) {
        super(columnModel);
        this.setReorderingAllowed(false);
        this.setResizingAllowed(true);
        this.setDefaultRenderer(new SortedTableHeaderRenderer(this));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setPressedColumn(int iPressedColumn) {
        this.iPressedColumn = iPressedColumn;
    }

    public int getPressedColumn() {
        return this.iPressedColumn;
    }

    public void setPressedColumnPainted(boolean bPressedColumnPainted) {
        this.bPressedColumnPainted = bPressedColumnPainted;
    }

    public boolean isPressedColumnPainted() {
        return this.bPressedColumnPainted;
    }

    public void setSortColumn(int iSortColumn) {
        this.iSortColumn = iSortColumn;
    }

    public int getSortColumn() {
        return this.iSortColumn;
    }

    public void setSortDirection(int iSortDirection) {
        this.iSortDirection = iSortDirection;
    }

    public int getSortDirection() {
        return this.iSortDirection;
    }

    public void mousePressed(MouseEvent e) {
        this.determineResizing(e.getPoint());
        if (!this.isResizing()) {
            this.setPressedColumn(this.columnAtPoint(e.getPoint()));
            this.setPressedColumnPainted(true);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        int iReleasedColumn;
        if (!this.isResizing() && (iReleasedColumn = this.columnAtPoint(e.getPoint())) == this.getPressedColumn()) {
            if (iReleasedColumn == this.getSortColumn()) {
                this.setSortDirection(this.getSortDirection() * -1);
            } else {
                this.setSortDirection(1);
            }
            this.setSortColumn(this.getPressedColumn());
            this.repaint();
            SortedTableModel model = (SortedTableModel)this.getTable().getModel();
            if (this.getSortColumn() != 0) {
                model.sortColumn(this.getSortColumn(), this.getSortDirection());
            }
            if (this.getTable().getColumnModel() instanceof GenericTableColumnModel) {
                GenericTableColumnModel columnModel = (GenericTableColumnModel)this.getTable().getColumnModel();
                ListSelectionEvent event = new ListSelectionEvent(this, this.getSortColumn(), this.getSortColumn(), false);
                columnModel.fireColumnSelectionChange(event);
            }
        }
        this.setPressedColumn(-1);
        this.setResizing(false);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setPressedColumnPainted(true);
    }

    public void mouseExited(MouseEvent e) {
        this.setPressedColumnPainted(false);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.getResizingColumn() != null) {
            this.setResizing(true);
            this.setPressedColumnPainted(false);
        } else {
            int iDraggedColumn = this.columnAtPoint(e.getPoint());
            if (iDraggedColumn == this.getPressedColumn()) {
                this.setPressedColumnPainted(true);
            } else {
                this.setPressedColumnPainted(false);
            }
        }
        this.repaint();
    }

    private void setResizing(boolean bResizing) {
        this.bResizing = bResizing;
    }

    private boolean isResizing() {
        return this.bResizing;
    }

    private void determineResizing(Point p) {
        Point a = new Point(p);
        Point b = new Point(p);
        int iOffset = 3;
        a.x -= 3;
        b.x += 3;
        if (this.columnAtPoint(a) != this.columnAtPoint(b)) {
            this.setResizing(true);
        }
    }
}

