/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation.swing;

import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.ui.foundation.swing.GenericTableCellRenderer;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class SortedTableHeaderRenderer
extends GenericTableCellRenderer {
    private SortedTableHeader sortedTableHeader;
    private boolean bSelectedPainted = false;
    private boolean bPressedPainted = false;
    private Color selectedColor = new Color(128, 128, 128, 50);
    private Color pressedColor = new Color(128, 128, 128, 100);
    private Border border;
    private boolean bFirstPass = true;

    public SortedTableHeaderRenderer(SortedTableHeader sortedTableHeader) {
        this.sortedTableHeader = sortedTableHeader;
        this.border = UIManager.getBorder("TableHeader.cellBorder");
        this.border = this.border == null ? new TintBorder() : new CompoundBorder(this.border, new TintBorder());
    }

    public Component getTableCellRendererComponent(JTable table, Object oValue, boolean bSelected, boolean bHasFocus, int iRow, int iColumn) {
        JComponent component = (JComponent)super.getTableCellRendererComponent(table, oValue, bSelected, bHasFocus, iRow, iColumn);
        if (this.bFirstPass) {
            this.getLabel().setFont(this.getLabel().getFont().deriveFont(1));
            this.bFirstPass = false;
        }
        if (component.getBorder() != this.border) {
            component.setBorder(this.border);
        }
        if (iColumn == this.sortedTableHeader.getPressedColumn()) {
            this.setPressedPainted(true);
        } else {
            this.setPressedPainted(false);
        }
        this.setSelectedPainted(false);
        if (iColumn == this.sortedTableHeader.getSortColumn()) {
            if (this.sortedTableHeader.getSortDirection() == 1) {
                this.setSelectedPainted(true);
                this.getLabel().setIcon(Environment.getImageIcon((String)"ascending-sort.png"));
            } else if (this.sortedTableHeader.getSortDirection() == -1) {
                this.setSelectedPainted(true);
                this.getLabel().setIcon(Environment.getImageIcon((String)"descending-sort.png"));
            } else {
                this.getLabel().setIcon(null);
            }
        } else {
            this.getLabel().setIcon(null);
        }
        return component;
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setPressedColor(Color pressedColor) {
        this.pressedColor = pressedColor;
    }

    public Color getPressedColor() {
        return this.pressedColor;
    }

    protected JLabel getLabel() {
        if (this.label == null) {
            this.label = new JLabel();
            this.label.setHorizontalAlignment(2);
            this.label.setAlignmentX(0.0f);
            this.label.setIconTextGap(3);
            this.label.setHorizontalTextPosition(2);
        }
        return this.label;
    }

    private void setSelectedPainted(boolean bSelectedPainted) {
        this.bSelectedPainted = bSelectedPainted;
    }

    private boolean isSelectedPainted() {
        return this.bSelectedPainted;
    }

    private void setPressedPainted(boolean bPressedPainted) {
        this.bPressedPainted = bPressedPainted;
    }

    private boolean isPressedPainted() {
        return this.bPressedPainted && this.sortedTableHeader.isPressedColumnPainted();
    }

    class TintBorder
    extends AbstractBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (SortedTableHeaderRenderer.this.isPressedPainted()) {
                Color color = SortedTableHeaderRenderer.this.getPressedColor();
                g.setColor(color);
                g.fillRect(x, y - 1, w, h + 1);
            } else if (SortedTableHeaderRenderer.this.isSelectedPainted()) {
                Color color = SortedTableHeaderRenderer.this.getSelectedColor();
                g.setColor(color);
                g.fillRect(x, y - 1, w, h + 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

