/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.ui.foundation.swing;

import com.sun.swup.client.ui.foundation.swing.GenericApplication;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumn;
import com.sun.swup.client.ui.foundation.swing.GenericTableColumnModel;
import com.sun.swup.client.ui.foundation.swing.SortedTableHeader;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

public class StateManager
implements ComponentListener,
TableColumnModelListener,
ActionListener {
    private static final String WINDOW = "window";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String LOCATION_X = "location-x";
    private static final String LOCATION_Y = "location-y";
    private static final String TABLE = "table";
    private static final String SORT_COLUMN = "sort-column";
    private static final String SORT_DIRECTION = "sort-direction";
    private static final String COLUMN_WIDTHS = "column-widths";
    private static final int COLUMN_WIDTH_STORE_DELAY = 600;
    private Timer resizeColumnTimer = new Timer(600, this);
    private GenericTableColumnModel resizedTableColumnModel;

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (e.getSource() instanceof Window) {
            this.storeWindowSize((Window)e.getSource());
        }
    }

    public void componentMoved(ComponentEvent e) {
        if (e.getSource() instanceof Window) {
            this.storeWindowLocation((Window)e.getSource());
        }
    }

    public void columnAdded(TableColumnModelEvent e) {
    }

    public void columnRemoved(TableColumnModelEvent e) {
    }

    public void columnMoved(TableColumnModelEvent e) {
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
        if (e.getSource() instanceof SortedTableHeader) {
            this.storeSortedTableColumn((SortedTableHeader)e.getSource());
        }
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (e.getSource() instanceof GenericTableColumnModel) {
            this.resizedTableColumnModel = (GenericTableColumnModel)e.getSource();
            if (this.resizeColumnTimer.isRunning()) {
                this.resizeColumnTimer.restart();
            } else {
                this.resizeColumnTimer.start();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof Timer) {
            Timer timer = (Timer)e.getSource();
            timer.stop();
            this.storeTableColumnWidths(this.resizedTableColumnModel);
        }
    }

    public void storeWindowSize(Window window) {
        if (window.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(WINDOW).node(window.getName());
            try {
                Dimension d = window.getSize();
                preferences.putInt(WIDTH, d.width);
                preferences.putInt(HEIGHT, d.height);
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                System.err.println(ex);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.storeWindowSize: window name is null");
        }
    }

    public void restoreWindowSize(Window window, Dimension defaultSize) {
        if (window.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(WINDOW).node(window.getName());
            try {
                int iWidth = preferences.getInt(WIDTH, defaultSize.width);
                int iHeight = preferences.getInt(HEIGHT, defaultSize.height);
                window.setSize(iWidth, iHeight);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.restoreWindowSize: window name is null");
        }
    }

    public void storeWindowLocation(Window window) {
        if (window.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(WINDOW).node(window.getName());
            try {
                Point p = window.getLocation();
                preferences.putInt(LOCATION_X, p.x);
                preferences.putInt(LOCATION_Y, p.y);
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                System.err.println(ex);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.storeWindowLocation: window name is null");
        }
    }

    public void restoreWindowLocation(Window window, Point defaultLocation) {
        if (window.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(WINDOW).node(window.getName());
            try {
                int iX = preferences.getInt(LOCATION_X, defaultLocation.x);
                int iY = preferences.getInt(LOCATION_Y, defaultLocation.y);
                window.setLocation(iX, iY);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.restoreWindowLocation: window name is null");
        }
    }

    public void storeSortedTableColumn(SortedTableHeader header) {
        if (header.getTable().getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(TABLE).node(header.getTable().getName());
            try {
                preferences.putInt(SORT_COLUMN, header.getSortColumn());
                preferences.putInt(SORT_DIRECTION, header.getSortDirection());
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                System.err.println(ex);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.storeSortedTableColumn: table name is null");
        }
    }

    public void restoreSortedTableColumn(SortedTableHeader header, int iDefaultSortColumn, int iDefaultSortDirection) {
        if (header.getTable().getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(TABLE).node(header.getTable().getName());
            try {
                header.setSortColumn(preferences.getInt(SORT_COLUMN, iDefaultSortColumn));
                header.setSortDirection(preferences.getInt(SORT_DIRECTION, iDefaultSortColumn));
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.restoreSortedTableColumn: table name is null");
        }
    }

    public void storeTableColumnWidths(GenericTableColumnModel model) {
        if (model.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(TABLE).node(model.getName()).node(COLUMN_WIDTHS);
            try {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    String sIndex = new Integer(i).toString();
                    preferences.putInt(sIndex, model.getColumn(i).getWidth());
                }
                preferences.flush();
            }
            catch (BackingStoreException ex) {
                System.err.println(ex);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.storeTableColumnWidths: table name is null");
        }
    }

    public void restoreTableColumnWidths(GenericTableColumnModel model) {
        if (model.getName() != null) {
            Preferences preferences = GenericApplication.getInstance().getPreferences().node(TABLE).node(model.getName()).node(COLUMN_WIDTHS);
            try {
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    String sIndex = new Integer(i).toString();
                    GenericTableColumn column = (GenericTableColumn)model.getColumn(i);
                    if (column.getResizable()) {
                        int iWidth = preferences.getInt(sIndex, column.getDefaultWidth());
                        model.applyColumnWidth(column, iWidth);
                        continue;
                    }
                    model.applyColumnWidth(column, column.getDefaultWidth());
                }
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        } else {
            System.err.println("StateManager.restoreTableColumnWidths: table name is null");
        }
    }
}

