/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.ProviderException;

abstract class DigestBase
extends MessageDigestSpi
implements Cloneable {
    private byte[] oneByte;
    private final String algorithm;
    private final int digestLength;
    private final int blockSize;
    byte[] buffer;
    private int bufOfs;
    long bytesProcessed;
    static final byte[] padding = new byte[136];

    DigestBase(String string, int n, int n2) {
        this.algorithm = string;
        this.digestLength = n;
        this.blockSize = n2;
        this.buffer = new byte[n2];
    }

    @Override
    protected final int engineGetDigestLength() {
        return this.digestLength;
    }

    @Override
    protected final void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected final void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.bytesProcessed += (long)n2;
        if (this.bufOfs != 0) {
            n3 = Math.min(n2, this.blockSize - this.bufOfs);
            System.arraycopy(byArray, n, this.buffer, this.bufOfs, n3);
            this.bufOfs += n3;
            n += n3;
            n2 -= n3;
            if (this.bufOfs >= this.blockSize) {
                this.implCompress(this.buffer, 0);
                this.bufOfs = 0;
            }
        }
        if (n2 >= this.blockSize) {
            n3 = n + n2;
            n = this.implCompressMultiBlock(byArray, n, n3 - this.blockSize);
            n2 = n3 - n;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufOfs = n2;
        }
    }

    private int implCompressMultiBlock(byte[] byArray, int n, int n2) {
        while (n <= n2) {
            this.implCompress(byArray, n);
            n += this.blockSize;
        }
        return n;
    }

    @Override
    protected final void engineReset() {
        if (this.bytesProcessed == 0L) {
            return;
        }
        this.implReset();
        this.bufOfs = 0;
        this.bytesProcessed = 0L;
    }

    @Override
    protected final byte[] engineDigest() {
        byte[] byArray = new byte[this.digestLength];
        try {
            this.engineDigest(byArray, 0, byArray.length);
        }
        catch (DigestException digestException) {
            throw (ProviderException)new ProviderException("Internal error").initCause(digestException);
        }
        return byArray;
    }

    @Override
    protected final int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < this.digestLength) {
            throw new DigestException("Length must be at least " + this.digestLength + " for " + this.algorithm + "digests");
        }
        if (n < 0 || n2 < 0 || n > byArray.length - n2) {
            throw new DigestException("Buffer too short to store digest");
        }
        if (this.bytesProcessed < 0L) {
            this.engineReset();
        }
        this.implDigest(byArray, n);
        this.bytesProcessed = -1L;
        return this.digestLength;
    }

    abstract void implCompress(byte[] var1, int var2);

    abstract void implDigest(byte[] var1, int var2);

    abstract void implReset();

    @Override
    public Object clone() throws CloneNotSupportedException {
        DigestBase digestBase = (DigestBase)super.clone();
        digestBase.buffer = (byte[])digestBase.buffer.clone();
        return digestBase;
    }

    static {
        DigestBase.padding[0] = -128;
    }
}

