/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg;

import com.sun.cns.basicreg.adapter.CCRAdapter;
import com.sun.cns.basicreg.adapter.CSMAuthAdapter;
import com.sun.cns.basicreg.common.CmdLineGlobalObject;
import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.common.FileHdlr;
import com.sun.cns.basicreg.common.ProxyManager;
import com.sun.cns.basicreg.common.RegistrationListener;
import com.sun.cns.basicreg.common.RegistrationProvider;
import com.sun.cns.basicreg.util.GetOpt;
import com.sun.cns.basicreg.wizard.swing.GatherDialog;
import com.sun.cns.basicreg.wizard.swing.SwingWorker;
import com.sun.cns.cacaosensor.SensorAdaptor;
import com.sun.security.auth.module.UnixSystem;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jdom.Document;

public class BasicReg
implements RegistrationProvider {
    private RegistrationListener registrationListener;
    private static final Logger LOG = Logger.getLogger(BasicReg.class.getName());
    private static final Logger logger = Logger.getLogger(BasicReg.class.getName());
    private static CmdLineGlobalObject globalObject = CmdLineGlobalObject.getInstance();
    private PrintStream suppressedSystemOutPrintStream;
    private PrintStream suppressedSystemErrPrintStream;
    private PrintStream systemOutPrintStream;
    private PrintStream systemErrPrintStream;
    private int runMode;
    private static String mode;
    private static boolean isSolaris;

    public BasicReg() {
        try {
            this.suppressedSystemOutPrintStream = new PrintStream(new FileOutputStream("/dev/null"));
            this.suppressedSystemErrPrintStream = new PrintStream(new FileOutputStream("/dev/null"));
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        this.systemOutPrintStream = System.out;
        this.systemErrPrintStream = System.err;
        BasicReg.startMSC();
        this.savePasswordFrmMSC();
        BasicReg.sensorCheck();
    }

    public BasicReg(PrintStream suppressedSystemOutPrintStream, PrintStream suppressedSystemErrPrintStream, PrintStream systemOutPrintStream, PrintStream systemErrPrintStream) {
        this.suppressedSystemOutPrintStream = suppressedSystemOutPrintStream;
        this.suppressedSystemErrPrintStream = suppressedSystemErrPrintStream;
        this.systemOutPrintStream = systemOutPrintStream;
        this.systemErrPrintStream = systemErrPrintStream;
        LOG.info("in other constructor");
        BasicReg.startMSC();
        this.savePasswordFrmMSC();
        BasicReg.sensorCheck();
    }

    public void loadPropertiesFromHomeDir() {
        Object object = this.checkPropertyManager();
        if (object != null) {
            String homeDir = System.getProperty("user.home");
            CmdLineGlobalObject.prop = (Properties)object;
            globalObject.setUpLogFile();
            this.loadProperties(true);
            LOG.info("properties file loaded from " + homeDir + "/QA-BR.properties");
        } else {
            this.loadProperties(false);
            LOG.info("properties file loaded from the default config.properties");
        }
        ProxyManager proxyManager = ProxyManager.getInstance();
        proxyManager.loadProxyProperties(CmdLineGlobalObject.prop);
    }

    public Object checkPropertyManager() {
        Object result = null;
        try {
            Class<?> clazz = Class.forName("com.sun.cns.basicreg.qa.PropertyManager");
            Constructor<?> constructor = clazz.getConstructor(null);
            Object object = constructor.newInstance(null);
            Method method = clazz.getMethod("loadProperties", null);
            result = method.invoke(object, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void loadProperties(boolean loadDefaultPropertyOnly) {
        Properties prop = new Properties();
        InputStream iS = this.getClass().getClassLoader().getResourceAsStream("wizards/config.properties");
        if (iS != null) {
            try {
                prop.load(iS);
            }
            catch (IOException ie) {
                LOG.severe(ie.toString());
                LOG.severe(CommonUtil.getStackTrace(ie));
            }
        }
        if (loadDefaultPropertyOnly) {
            CmdLineGlobalObject.propDefault = prop;
        } else {
            CmdLineGlobalObject.prop = prop;
            CmdLineGlobalObject.propDefault = prop;
        }
        globalObject.setUpLogFile();
    }

    public static boolean isNeverRegisterSet() {
        if (FileHdlr.filePresent("/usr/lib/breg/data/.nvreg")) {
            LOG.info("Never register flag set");
            return true;
        }
        LOG.info("Never register flag not set");
        return false;
    }

    public static boolean isRegisterLaterSet() {
        if (FileHdlr.filePresent("/usr/lib/breg/data/.lreg")) {
            LOG.info("Register Later flag set");
            return true;
        }
        LOG.info("Register Later flag not set");
        return false;
    }

    public static Object getCSMAuthenticator() {
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        return csmAuthAdapter.getCSMAuthenticator();
    }

    private boolean isRootAccessAuthorized() {
        LOG.info("checking root access");
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        if (!csmAuthAdapter.isAuthenticated()) {
            if (!csmAuthAdapter.isUserAuthenticatedAlready()) {
                LOG.warning("you don't have the privilege to run basicreg");
                return false;
            }
            CSMAuthAdapter.setAuthenticated(true);
        }
        CCRAdapter.setCSMAuthAdapter(csmAuthAdapter);
        csmAuthAdapter.closeFrame();
        return true;
    }

    private static boolean startMSC() {
        UnixSystem u = new UnixSystem();
        long uid = u.getUid();
        if (uid != 0L) {
            LOG.info("start the SCN MSC (via CSMAuth) if it is not already running.");
            CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
            String cmd = "/usr/sbin/sconadm";
            Vector<String> args = new Vector<String>();
            args.add("cacao");
            args.add("start");
            return csmAuthAdapter.runPrivCMD(cmd, args);
        }
        LOG.info("Start the SCN MSC (as root) if it is not already running.");
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec("/usr/sbin/sconadm cacao start");
            int exitVal = proc.waitFor();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    private void savePasswordFrmMSC() {
        UnixSystem u = new UnixSystem();
        long uid = u.getUid();
        if (uid != 0L) {
            LOG.info("read MSC password via CSMauth");
            CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
            String filePath = "/etc/cacao/instances/default/security/password";
            String mscpasswd = csmAuthAdapter.readPrivFile(filePath);
            CommonUtil.setMscPassword(mscpasswd);
        } else {
            LOG.info("read MSC password as root");
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec("/usr/bin/cat /etc/cacao/instances/default/security/password");
                InputStream stdin = proc.getInputStream();
                InputStreamReader isr = new InputStreamReader(stdin);
                BufferedReader br = new BufferedReader(isr);
                String mscpasswd = null;
                while ((mscpasswd = br.readLine()) != null) {
                    CommonUtil.setMscPassword(mscpasswd);
                }
                CommonUtil.setMscPassword(mscpasswd);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    public int startInRootJVM() {
        LOG.info("starting root JVM");
        CSMAuthAdapter csmAuthAdapter = CSMAuthAdapter.getInstance();
        String cmd = "/usr/bin/java";
        Vector<String> args = new Vector<String>();
        args.add("-client ");
        args.add("-jar");
        args.add("/usr/lib/breg/basicreg.jar");
        csmAuthAdapter.runPrivCMD(cmd, args);
        return 1;
    }

    private String getProfileFileName(int runMode) {
        if (runMode == 0) {
            return "wizards/profileSWUPRegistrationSCN.xml";
        }
        if (runMode == 1) {
            if (this.isPortalEnabled()) {
                return "wizards/profileSWUPSubscriptionSCN_1.xml";
            }
            return "wizards/profileSWUPSubscriptionSCN.xml";
        }
        if (runMode == 2) {
            return "wizards/profileSWUPEnablePortalSCN.xml";
        }
        if (runMode == 3) {
            return "wizards/profileSolaris.xml";
        }
        if (runMode == 4) {
            return "wizards/profileSolarisRegistrationSCN.xml";
        }
        LOG.severe("Unknown run mode: " + runMode);
        return "wizards/profileSWUPRegistrationSCN.xml";
    }

    private boolean isPortalEnabled() {
        boolean flag = false;
        try {
            String str = CCRAdapter.getValueThroughCSMAuth(CCRAdapter.PORTAL_MGMT_STATUS);
            if (str != null && str.equals("enabled")) {
                flag = true;
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return flag;
    }

    public void setRegistrationListener(RegistrationListener registrationListener) {
        this.registrationListener = registrationListener;
    }

    public void runWizard() {
        this.runWizard(0, null, false);
    }

    public void runWizard(Frame parentFrame, boolean isModal) {
        this.runWizard(0, parentFrame, isModal);
    }

    public void runWizard(int runMode) {
        this.runWizard(runMode, null, false);
    }

    public void runWizard(final int runMode, final Frame parentFrame, final boolean isModal) {
        block4: {
            LOG.info("A mode: " + runMode);
            this.runMode = runMode;
            ProxyManager proxy = ProxyManager.getInstance();
            this.loadPropertiesFromHomeDir();
            if (!this.isRootAccessAuthorized()) {
                return;
            }
            GatherDialog gatherDialog = parentFrame == null ? new GatherDialog(null, 0, true, runMode == 0) : new GatherDialog(parentFrame, null, 0, true, runMode == 0);
            final GatherDialog finalGatherDialog = gatherDialog;
            SwingWorker worker = new SwingWorker(){
                boolean workerDone = false;

                public Object construct() {
                    LoadTask loadTask = new LoadTask(runMode, parentFrame, isModal);
                    this.workerDone = true;
                    finalGatherDialog.stop();
                    return loadTask;
                }

                public boolean isDone() {
                    return this.workerDone;
                }
            };
            worker.start();
            if (!worker.isDone()) {
                finalGatherDialog.start();
            }
            try {
                Class<?> wizardClazz = Class.forName("com.sun.cns.basicreg.wizard.swing.WizardFrame");
                Method runMethod = wizardClazz.getMethod("run", null);
                runMethod.invoke(null, null);
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                LOG.severe(CommonUtil.getStackTrace(e));
                if (!(e instanceof InvocationTargetException)) break block4;
                LOG.severe("Wrapped Target Exception:\n");
                Throwable targetThrowable = e.getCause();
                LOG.severe(targetThrowable != null ? CommonUtil.getStackTrace(targetThrowable) : "?");
            }
        }
    }

    public int getRunMode() {
        return this.runMode;
    }

    public Document runConsole() {
        this.loadPropertiesFromHomeDir();
        Document result = null;
        CommonUtil.disableSystemOut(this.suppressedSystemOutPrintStream, this.suppressedSystemErrPrintStream);
        LOG.info(">>>  Systemout disabled >>>");
        CommonUtil.enableSystemOut(this.systemOutPrintStream, this.systemErrPrintStream);
        LOG.info(">>> Systemout enabled >>>");
        try {
            Class<?> cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.CmdLineWizard");
            Object[] initArgs = new Object[]{new String("wizards/profileSWUPRegistrationSCN.xml")};
            Constructor<?> cons = cliClazz.getConstructor(String.class);
            Object cliWizard = cons.newInstance(initArgs);
            Method runMethod = cliClazz.getMethod("run", null);
            result = (Document)runMethod.invoke(cliWizard, null);
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    public static void sensorCheck() {
        String localhostname = "localhost";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localhostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            logger.severe(e.toString());
            logger.severe(CommonUtil.getStackTrace(e));
        }
        SensorAdaptor x = new SensorAdaptor(CommonUtil.getMscPassword());
        if (x.isHealthy()) {
            if (!x.isGlobalzone()) {
                logger.info("BR can only run in global zone");
                System.exit(-1);
            }
            logger.info("BR is running in global zone, according to cacao sensor");
        } else {
            logger.info("Either cacao is down or sensor module not loaded,");
            logger.info("no information on zone is available,");
            logger.info("assume global zone");
        }
    }

    public Document runAutoReg() {
        this.loadPropertiesFromHomeDir();
        Document result = null;
        try {
            Class<?> cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.AutoReg");
            Object[] initArgs = new Object[]{new String("/usr/lib/breg/data/autoRegistrationProfile.xml")};
            Constructor<?> cons = cliClazz.getConstructor(String.class);
            Object autoReg = cons.newInstance(initArgs);
            Method runMethod = cliClazz.getMethod("initialize", null);
            result = (Document)runMethod.invoke(autoReg, null);
            CommonUtil.disableSystemOut(this.suppressedSystemOutPrintStream, this.suppressedSystemErrPrintStream);
            LOG.info(">>>  Systemout disabled >>>");
            CommonUtil.enableSystemOut(this.systemOutPrintStream, this.systemErrPrintStream);
            LOG.info(">>> Systemout enabled >>>");
            try {
                cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.AutoReg");
                initArgs = new Object[]{new String("/usr/lib/breg/data/autoRegistrationProfile.xml")};
                cons = cliClazz.getConstructor(String.class);
                autoReg = cons.newInstance(initArgs);
                runMethod = cliClazz.getMethod("run", null);
                result = (Document)runMethod.invoke(autoReg, null);
            }
            catch (Exception e) {
                LOG.severe(e.toString());
                LOG.severe(CommonUtil.getStackTrace(e));
            }
        }
        catch (Exception e) {
            LOG.severe(e.toString());
            LOG.severe(CommonUtil.getStackTrace(e));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        CSMAuthAdapter csmAuthAdapter;
        Document doc = null;
        String dateTimeStamp = CommonUtil.getDateTimeStamp();
        SimpleFormatter formatter = new SimpleFormatter();
        try {
            FileHandler handler = new FileHandler("/tmp/breg_business_logic_" + dateTimeStamp + ".log");
            handler.setFormatter(formatter);
            logger.addHandler(handler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (BasicReg.processInput(args) < 0) {
            return;
        }
        if (CmdLineGlobalObject.starterApp.equalsIgnoreCase("X11")) {
            if (BasicReg.isNeverRegisterSet()) {
                return;
            }
            if (BasicReg.isRegisterLaterSet()) {
                return;
            }
        }
        UnixSystem u = new UnixSystem();
        long uid = u.getUid();
        if (CmdLineGlobalObject.mode != null) {
            if (CmdLineGlobalObject.mode.equalsIgnoreCase("autoreg")) {
                String autoregfile = "/usr/lib/breg/data/autoRegistrationProfile.xml";
                File autoregprofile = new File(autoregfile);
                if (!autoregprofile.exists()) {
                    logger.info("Cannot run basicreg in autoreg mode without an autoRegistrationProfile.xml");
                    System.out.println("Cannot run basicreg in autoreg mode without an autoRegistrationProfile.xml");
                    System.exit(0);
                }
                if (uid != 0L) {
                    logger.info("Cannot run basicreg in autoreg mode as non-root");
                    System.out.println("Cannot run basicreg in autoreg mode as non-root");
                    System.exit(1);
                }
                BasicReg br = new BasicReg();
                logger.info("running basicreg in autoreg mode");
                doc = br.runAutoReg();
                return;
            }
        }
        if (!(csmAuthAdapter = CSMAuthAdapter.getInstance()).authenticateUser()) {
            csmAuthAdapter.closeFrame();
            return;
        }
        CSMAuthAdapter.setAuthenticated(true);
        csmAuthAdapter.closeFrame();
        if (CmdLineGlobalObject.mode != null) {
            if (CmdLineGlobalObject.mode.equalsIgnoreCase("console")) {
                BasicReg br = new BasicReg();
                LOG.finest("running basicreg in console mode");
                doc = br.runConsole();
                return;
            }
        }
        if (CmdLineGlobalObject.mode != null) {
            if (CmdLineGlobalObject.mode.equalsIgnoreCase("gui")) {
                BasicReg br = new BasicReg();
                LOG.info("Running basicreg in gui, " + (isSolaris ? "Solaris" : "Solaris SCN") + " registration mode.");
                br.runWizard(isSolaris ? 3 : 4);
                return;
            }
        }
        if (CmdLineGlobalObject.mode != null) {
            if (CmdLineGlobalObject.mode.equalsIgnoreCase("xml")) {
                BasicReg br = new BasicReg();
                LOG.info("Future feature...import xml from command line.");
                return;
            }
        }
        BasicReg br = new BasicReg();
        LOG.finest("Running basicreg in gui, " + (isSolaris ? "Solaris" : "SCN") + " registration mode.");
        br.runWizard(isSolaris ? 3 : 4);
    }

    public static int processInput(String[] args) {
        CmdLineGlobalObject.mode = "gui";
        CmdLineGlobalObject.starterApp = "   ";
        GetOpt getopt = new GetOpt(args, "m:d:t:o:e:h:p:u:w:k:o:f:xz");
        try {
            int c;
            while ((c = getopt.getNextOption()) != -1) {
                switch (c) {
                    case 109: {
                        LOG.info("Option:m " + getopt.getOptionArg());
                        CmdLineGlobalObject.mode = getopt.getOptionArg();
                        break;
                    }
                    case 100: {
                        LOG.info("Option:d " + getopt.getOptionArg());
                        CmdLineGlobalObject.registrationProfile = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 111: {
                        LOG.info("Option:o " + getopt.getOptionArg());
                        CmdLineGlobalObject.offeringType = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 101: {
                        LOG.info("Option:e " + getopt.getOptionArg());
                        CmdLineGlobalObject.portalEnabled = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 116: {
                        LOG.info("Option:t " + getopt.getOptionArg());
                        CmdLineGlobalObject.companyToken = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 104: {
                        LOG.info("Option:h " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyHost = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 112: {
                        LOG.info("Option:p " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyPort = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 117: {
                        LOG.info("Option:u " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyUsername = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 119: {
                        LOG.info("Option:w " + getopt.getOptionArg());
                        CmdLineGlobalObject.proxyPassword = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 107: {
                        LOG.info("Option:k " + getopt.getOptionArg());
                        CmdLineGlobalObject.subscriptionKey = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 102: {
                        LOG.info("Option:f " + getopt.getOptionArg());
                        CmdLineGlobalObject.outputFile = getopt.getOptionArg();
                        CmdLineGlobalObject.mode = "autoreg";
                        break;
                    }
                    case 120: {
                        LOG.info("Option:x ");
                        CmdLineGlobalObject.starterApp = "X11";
                        break;
                    }
                    case 122: {
                        LOG.info("Option:z ");
                        isSolaris = true;
                    }
                }
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.severe("AutoReg is not successful");
            LOG.severe("Error:" + ex.getMessage());
            System.err.println("AutoReg is not successful");
            System.err.println("Error:" + ex.getMessage());
            return -1;
        }
        return 0;
    }

    static {
        isSolaris = false;
    }

    class LoadTask {
        LoadTask(int runMode, Frame parentFrame, boolean isModal) {
            block2: {
                LOG.info("LoadTask ENTER");
                try {
                    Class<?> cliClazz = Class.forName("com.sun.cns.basicreg.wizard.cli.CmdLineWizard");
                    Object[] initArgs = new Object[]{new String(BasicReg.this.getProfileFileName(runMode))};
                    Constructor<?> cons = cliClazz.getConstructor(String.class);
                    Object cliWizard = cons.newInstance(initArgs);
                    Class<?> wizardClazz = Class.forName("com.sun.cns.basicreg.wizard.swing.WizardFrame");
                    initArgs = new Object[]{parentFrame, new Boolean(isModal), cliWizard, BasicReg.this.registrationListener, new Integer(runMode)};
                    Method createMethod = wizardClazz.getMethod("create", Class.forName("java.awt.Frame"), Class.forName("java.lang.Boolean"), Class.forName("com.sun.cns.basicreg.wizard.Wizard"), Class.forName("com.sun.cns.basicreg.common.RegistrationListener"), Class.forName("java.lang.Integer"));
                    createMethod.invoke(null, initArgs);
                }
                catch (Exception e) {
                    LOG.severe(e.toString());
                    LOG.severe(CommonUtil.getStackTrace(e));
                    if (!(e instanceof InvocationTargetException)) break block2;
                    LOG.severe("Wrapped Target Exception:\n");
                    Throwable targetThrowable = e.getCause();
                    LOG.severe(targetThrowable != null ? CommonUtil.getStackTrace(targetThrowable) : "?");
                }
            }
            LOG.info("LoadTask LEAVE");
        }
    }
}

