/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.util;

import com.sun.cns.basicreg.common.CommonUtil;
import com.sun.cns.basicreg.util.ProxyClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends ProxyClassLoader {
    private Source[] sources;
    private Set deadJars = null;
    private static final boolean VERBOSE = false;
    private static final Logger LOG = Logger.getLogger(JarClassLoader.class.getName());
    private static Object factory = null;
    private static HashMap fileCache = null;

    public JarClassLoader(List files, ClassLoader[] parents) {
        this(files, parents, true);
    }

    public JarClassLoader(List files, ClassLoader[] parents, boolean transitive) {
        super(parents, transitive);
        this.sources = new Source[files.size()];
        try {
            int i = 0;
            for (Object act : files) {
                this.sources[i] = act instanceof File ? new DirSource((File)act) : new JarSource((JarFile)act);
                ++i;
            }
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        return Policy.getPolicy().getPermissions(cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        if (man == null) {
            return this.definePackage(name, null, null, null, null, null, null, null);
        }
        String path = name.replace('.', '/').concat("/");
        Attributes spec = man.getAttributes(path);
        Attributes main = man.getMainAttributes();
        String specTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_TITLE);
        String implTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_TITLE);
        String specVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VERSION);
        String implVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VERSION);
        String specVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VENDOR);
        String implVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = JarClassLoader.getAttr(spec, main, Attributes.Name.SEALED);
        URL sealBase = "true".equalsIgnoreCase(sealed) ? url : null;
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static String getAttr(Attributes spec, Attributes main, Attributes.Name name) {
        String val = null;
        if (spec != null) {
            val = spec.getValue(name);
        }
        if (val == null && main != null) {
            val = main.getValue(name);
        }
        return val;
    }

    protected Class simpleFindClass(String name, String path, String pkgnameSlashes) {
        for (int i = 0; i < this.sources.length; ++i) {
            Source src = this.sources[i];
            byte[] data = src.getClassData(name, path);
            if (data == null) continue;
            int j = name.lastIndexOf(46);
            String pkgName = name.substring(0, j);
            Package pkg = this.getPackageFast(pkgName, pkgnameSlashes, this.isSpecialResource(pkgnameSlashes));
            if (pkg != null) {
                if (pkg.isSealed() && !pkg.isSealed(src.getURL())) {
                    throw new SecurityException("sealing violation");
                }
            } else {
                Manifest man = src.getManifest();
                this.definePackage(pkgName, man, src.getURL());
            }
            return this.defineClass(name, data, 0, data.length, src.getProtectionDomain());
        }
        return null;
    }

    protected URL findResource(String name) {
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream inStream = null;
        try {
            inStream = this.findResource(name).openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inStream;
    }

    public URL getResource(String name) {
        URL result = null;
        try {
            result = this.findResource(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Enumeration simpleFindResources(String name) {
        Vector<URL> v = new Vector<URL>(3);
        for (int i = 0; i < this.sources.length; ++i) {
            URL item = this.sources[i].getResource(name);
            if (item == null) continue;
            v.add(item);
        }
        return v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseLocks() {
        if (this.deadJars != null) {
            throw new IllegalStateException("Already had dead JARs: " + this.deadJars);
        }
        this.deadJars = new HashSet();
        try {
            for (int i = 0; i < this.sources.length; ++i) {
                String suffix;
                String prefix;
                JarFile origJar;
                File orig;
                if (!(this.sources[i] instanceof JarSource) || !(orig = new File((origJar = ((JarSource)this.sources[i]).getJarFile()).getName())).isFile()) continue;
                String name = orig.getName();
                int idx = name.lastIndexOf(46);
                if (idx == -1) {
                    prefix = name;
                    suffix = null;
                } else {
                    prefix = name.substring(0, idx);
                    suffix = name.substring(idx);
                }
                while (prefix.length() < 3) {
                    prefix = prefix + "x";
                }
                File temp = File.createTempFile(prefix, suffix);
                temp.deleteOnExit();
                FileInputStream is = new FileInputStream(orig);
                try {
                    FileOutputStream os = new FileOutputStream(temp);
                    try {
                        int j;
                        byte[] buf = new byte[4096];
                        while ((j = ((InputStream)is).read(buf)) != -1) {
                            ((OutputStream)os).write(buf, 0, j);
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
                JarFile tempJar = new JarFile(temp);
                origJar.close();
                JarClassLoader.forceRelease(orig);
                this.deadJars.add(tempJar);
                this.sources[i] = new JarSource(tempJar);
                JarClassLoader.log("#21114: replacing " + orig + " with " + temp);
            }
        }
        catch (IOException ioe) {
            JarClassLoader.notify(0, ioe);
        }
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.sources.length; ++i) {
            if (!(this.sources[i] instanceof JarSource)) continue;
            JarFile j = ((JarSource)this.sources[i]).getJarFile();
            File f = new File(j.getName());
            JarClassLoader.forceRelease(f);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.sources.length; ++i) {
            if (!(this.sources[i] instanceof JarSource)) continue;
            JarFile j = ((JarSource)this.sources[i]).getJarFile();
            File f = new File(j.getName());
            j.close();
            JarClassLoader.forceRelease(f);
            if (this.deadJars == null || !this.deadJars.contains(j)) continue;
            JarClassLoader.log("#21114: closing and deleting temporary JAR " + f);
            if (!f.isFile() || f.delete()) continue;
            JarClassLoader.log("(but failed to delete it)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void forceRelease(File f) {
        if (fileCache == null || factory == null) {
            return;
        }
        try {
            Object object = factory;
            synchronized (object) {
                Iterator it = fileCache.values().iterator();
                while (it.hasNext()) {
                    JarFile j = (JarFile)it.next();
                    if (!f.equals(new File(j.getName()))) continue;
                    j.close();
                    it.remove();
                    JarClassLoader.log("Removing jar: cache for " + f + " as workaround for JDK #4646668");
                }
            }
        }
        catch (Exception e) {
            JarClassLoader.annotate(e, 0, "Could not remove jar: cache for " + f, null, null, null);
            JarClassLoader.notify(0, e);
        }
    }

    static void log(String msg) {
        if ("0".equals(System.getProperty("org.netbeans.core.modules"))) {
            System.err.println(msg);
        }
    }

    static Throwable annotate(Throwable t, int x, String s, Object o1, Object o2, Object o3) {
        System.err.println("annotated: " + t.getMessage() + " - " + s);
        return t;
    }

    static void notify(int x, Throwable t) {
        LOG.severe(CommonUtil.getStackTrace(t));
    }

    static {
        try {
            Class<?> juc = Class.forName("sun.net.www.protocol.jar.JarURLConnection");
            Field factoryF = juc.getDeclaredField("factory");
            factoryF.setAccessible(true);
            factory = factoryF.get(null);
            Class<?> jff = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            if (!jff.isInstance(factory)) {
                throw new ClassCastException(factory.getClass().getName());
            }
            Field fileCacheF = jff.getDeclaredField("fileCache");
            fileCacheF.setAccessible(true);
            fileCache = (HashMap)fileCacheF.get(null);
            JarClassLoader.log("Workaround for JDK #4646668 active as part of IZ #21114");
        }
        catch (Exception e) {
            JarClassLoader.annotate(e, 0, "Workaround for JDK #4646668 as part of IZ #21114 failed", null, null, null);
            JarClassLoader.notify(0, e);
        }
    }

    class DirSource
    extends Source {
        File dir;

        public DirSource(File file) throws MalformedURLException {
            super(file.toURI().toURL());
            this.dir = file;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            File resFile = new File(this.dir, name);
            return resFile.exists() ? resFile.toURI().toURL() : null;
        }

        protected byte[] readClass(String name, String path) throws IOException {
            File clsFile = new File(this.dir, path.replace('/', File.separatorChar));
            if (!clsFile.exists()) {
                return null;
            }
            int len = (int)clsFile.length();
            byte[] data = new byte[len];
            FileInputStream is = new FileInputStream(clsFile);
            for (int count = 0; count < len; count += ((InputStream)is).read(data, count, len - count)) {
            }
            return data;
        }
    }

    class JarSource
    extends Source {
        JarFile src;
        private String resPrefix;

        public JarSource(JarFile file) throws MalformedURLException {
            super(new File(file.getName()).toURI().toURL());
            this.src = file;
            this.resPrefix = "jar:" + new File(this.src.getName()).toURI() + "!/";
        }

        public Manifest getManifest() {
            try {
                return this.src.getManifest();
            }
            catch (IOException e) {
                return null;
            }
        }

        JarFile getJarFile() {
            return this.src;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            ZipEntry ze;
            try {
                ze = this.src.getEntry(name);
            }
            catch (IllegalStateException ex) {
                return null;
            }
            return ze == null ? null : new URL(this.resPrefix + ze.getName());
        }

        protected byte[] readClass(String name, String path) throws IOException {
            ZipEntry ze;
            try {
                ze = this.src.getEntry(path);
            }
            catch (IllegalStateException ex) {
                return null;
            }
            if (ze == null) {
                return null;
            }
            int len = (int)ze.getSize();
            byte[] data = new byte[len];
            InputStream is = this.src.getInputStream(ze);
            for (int count = 0; count < len; count += is.read(data, count, len - count)) {
            }
            return data;
        }
    }

    abstract class Source {
        private URL url;
        private ProtectionDomain pd;

        public Source(URL url) {
            this.url = url;
        }

        public final URL getURL() {
            return this.url;
        }

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource cs = new CodeSource(this.url, new Certificate[0]);
                this.pd = new ProtectionDomain(cs, JarClassLoader.this.getPermissions(cs));
            }
            return this.pd;
        }

        public final URL getResource(String name) {
            try {
                return this.doGetResource(name);
            }
            catch (Exception e) {
                JarClassLoader.log(e.toString());
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws MalformedURLException;

        public final byte[] getClassData(String name, String path) {
            try {
                return this.readClass(name, path);
            }
            catch (IOException e) {
                JarClassLoader.log(e.toString());
                return null;
            }
        }

        protected abstract byte[] readClass(String var1, String var2) throws IOException;

        public Manifest getManifest() {
            return null;
        }
    }
}

