/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cns.basicreg.util;

import com.sun.cns.basicreg.util.XMLError;
import java.util.ArrayList;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class ResponseBuilder {
    public static Document buildResponseDocument(String data, String type) {
        Document result = new Document();
        Element basicRegElm = new Element("BasicReg");
        basicRegElm.addContent((Content)ResponseBuilder.buildResponseElement(data, type));
        result.setRootElement(basicRegElm);
        return result;
    }

    private static Element buildResponseElement(String data, String type) {
        Element result = new Element("Response");
        result.setAttribute("type", type);
        CDATA text = new CDATA(data);
        result.setContent((Content)text);
        return result;
    }

    public static Document buildResponseDocument(ArrayList errorList, String type) {
        Document result = new Document();
        Element basicRegElm = new Element("BasicReg");
        basicRegElm.addContent((Content)ResponseBuilder.buildResponseElement(errorList, type));
        result.setContent((Content)basicRegElm);
        return result;
    }

    private static Element buildResponseElement(ArrayList errorList, String type) {
        Element result = new Element("Response");
        result.setAttribute("type", type);
        result.addContent((Content)ResponseBuilder.buildErrorListElement(errorList));
        return result;
    }

    private static Element buildErrorListElement(ArrayList errorList) {
        Element result = new Element("MessageList");
        for (XMLError error : errorList) {
            result.addContent((Content)ResponseBuilder.buildErrorElement(error));
        }
        return result;
    }

    private static Element buildErrorElement(XMLError error) {
        Element result = new Element("Error");
        result.setAttribute("severity", error.getSeverity());
        result.setAttribute("code", error.getCode());
        result.setAttribute("type", error.getType());
        CDATA text = new CDATA(error.getText());
        result.setContent((Content)text);
        return result;
    }
}

