/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.prom;

import com.sun.scn.jmx.SCNType;
import com.sun.scn.jmx.impl.AbstractOfferingFactory;
import com.sun.scn.offering.prom.ProductRegOfferingFactoryMBean;
import com.sun.scn.offering.prom.ProductRegOfferingInstance;
import com.sun.scn.offering.prom.ProductRegOfferingInstanceMBean;
import com.sun.scn.util.Utils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jdom.Document;

public class ProductRegOfferingFactory
extends AbstractOfferingFactory
implements ProductRegOfferingFactoryMBean {
    public static final String host = Utils.getLocalHostNames()[0];
    public static final SCNType INSTANCETYPE = SCNType.OFFERING_INSTANCE;
    private static final String uiProfileFile = "/usr/lib/scn/lib/profileSolaris.xml";
    private static Document uiProfile;
    private static Map cache;
    private static Properties privateProps;

    public ProductRegOfferingFactory(String name, Properties props, String module, MBeanServer mbs, Logger logger) {
        super(null, null, name, ProductRegOfferingFactory.buildProperties(props), module, mbs, logger);
        cache = new HashMap();
    }

    private static final Properties buildProperties(Properties props) {
        Properties retProps = new Properties();
        privateProps = (Properties)props.clone();
        retProps.setProperty("host", host);
        String val = props.getProperty("profScnType");
        if (null != val) {
            retProps.setProperty("scnType", val);
        } else {
            retProps.setProperty("scnType", "OfferingFactory");
        }
        val = props.getProperty("profName");
        if (null != val) {
            retProps.setProperty("name", val);
        } else {
            retProps.setProperty("name", "ProductRegOfferingFactory");
        }
        val = props.getProperty("profAssetProfile");
        if (null != val) {
            retProps.setProperty("assetProfile", val);
        } else {
            retProps.setProperty("assetProfile", "OperationSystem");
        }
        val = props.getProperty("profSubAssetProfile");
        if (null != val) {
            retProps.setProperty("assetSubProfile", val);
        } else {
            retProps.setProperty("assetSubProfile", "TODO");
        }
        val = props.getProperty("Vendor");
        if (null == val) {
            retProps.setProperty("Vendor", "Sun Microsystems Inc");
        }
        return retProps;
    }

    public String getOfferingVendor() {
        return "Sun Microsystems Inc";
    }

    public String[] getOfferingModelId() {
        return new String[]{"TODO"};
    }

    public String[] getConsumedProfile() {
        return new String[]{"TODO getConsumedProfile"};
    }

    public String[] getConsumedSubprofile() {
        return new String[]{"TODO getConsumedSubProfile"};
    }

    public ObjectName getOfferingInstance(ObjectName obName) {
        return null;
    }

    public final String getOfferingType() {
        return "TODO: The offering type will be prom?";
    }

    protected void _pre_init() {
    }

    protected void _post_init() {
    }

    protected void _pause() {
    }

    protected void _start() {
        this.addInstance("ProductRegOfferingInstance", ProductRegOfferingInstanceMBean.class);
        this.getLogger().log(Level.INFO, "Get instance names: ");
        String[] inames = this.getInstanceNames();
        for (int i = 0; i < inames.length; ++i) {
            this.getLogger().log(Level.INFO, "names [" + i + "] = " + inames[i]);
        }
        this.getLogger().log(Level.INFO, "Get instanceObjectName: ");
        ObjectName[] names = this.getInstanceObjectNames();
        for (int i = 0; i < names.length; ++i) {
            this.getLogger().log(Level.INFO, "object names [" + i + "] = " + names[i]);
        }
        this.getLogger().log(Level.INFO, "getOfferingInstanceName:");
        ObjectName on = this.getOfferingInstanceName("ProductRegOfferingInstance");
        this.getLogger().log(Level.INFO, "ObjectName for ProductRegOfferingInstance.NAME is " + on);
    }

    protected void _stop() {
        try {
            Collection mbeans = cache.values();
            for (ProductRegOfferingInstanceMBean mbean : mbeans) {
                this.getMBeanServer().unregisterMBean(mbean.getObjectName());
            }
            cache.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ProductRegOfferingInstanceMBean getInstance(String name) {
        ProductRegOfferingInstance offMBean = (ProductRegOfferingInstance)cache.get(name);
        if (null == offMBean) {
            try {
                offMBean = new ProductRegOfferingInstance(this, null, name, ProductRegOfferingFactory.buildPROIProps(), this.getMBeanServer(), this.getModuleName());
                cache.put(name, offMBean);
                offMBean.init_collect();
            }
            catch (Exception x) {
                this.getLogger().log(Level.WARNING, "Failed to build MBean" + name);
                this.getLogger().log(Level.WARNING, "caught exception", x);
            }
        }
        return offMBean;
    }

    protected ProductRegOfferingInstanceMBean createInstance(String name) {
        return this.getInstance(name);
    }

    public final SCNType[] getInstanceTypes() {
        return new SCNType[]{INSTANCETYPE};
    }

    protected final String getInstanceKey() {
        return "";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public final String getResourceType() {
        return "OperationSystem";
    }

    private static Properties buildPROIProps() {
        Properties oiProp = new Properties();
        oiProp.setProperty("name", "ProductRegOfferingInstance");
        oiProp.setProperty("host", host);
        oiProp.setProperty("assetProfile", "compute-host");
        oiProp.setProperty("assetSubProfile", "base-compute-host");
        oiProp.setProperty("Vendor", "Sun Microsystems Inc");
        oiProp.setProperty("scnType", "OfferingInstance");
        oiProp.setProperty("OfferingFactory", "ProductRegOfferingFactory");
        oiProp.setProperty("assetModel", "NULL");
        return oiProp;
    }

    public String getConfigProperty(String key) {
        return (String)privateProps.get(key);
    }

    public ObjectName getOfferingInstanceName(String name) {
        ObjectName retName = null;
        if (!cache.containsKey(name)) {
            retName = null;
        } else {
            ProductRegOfferingInstanceMBean member = (ProductRegOfferingInstanceMBean)cache.get(name);
            retName = member.getObjectName();
        }
        return retName;
    }
}

