/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.prom;

import com.sun.scn.client.comm.RegSender;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.registry.RegistryNotLoadedException;
import com.sun.scn.client.registry.ServiceTagRegistry;
import com.sun.scn.client.registry.ServiceTagRegistryException;
import com.sun.scn.client.util.SCRKClientHelper;
import com.sun.scn.dao.Domain;
import com.sun.scn.jmx.OfferingFactoryMBean;
import com.sun.scn.jmx.SCNBaseServiceFactoryMBean;
import com.sun.scn.jmx.SCNClientLoginMBean;
import com.sun.scn.jmx.SCNClientRegistrationMBean;
import com.sun.scn.jmx.SCNNetworkProxyConfigMBean;
import com.sun.scn.jmx.impl.AbstractComponent;
import com.sun.scn.offering.prom.AssetManagementServiceProvider;
import com.sun.scn.offering.prom.AssetRegistrationException;
import com.sun.scn.offering.prom.ProductRegOfferingFactoryMBean;
import com.sun.scn.offering.prom.ProductRegOfferingInstanceMBean;
import com.sun.scn.offering.prom.SystemInfoHelper;
import com.sun.scn.offering.service.ams.bind.RegisterResponse;
import com.sun.scn.sam.SolarisAssetFactoryMBean;
import com.sun.scn.sam.SolarisAssetInstanceMBean;
import com.sun.scn.sam.datacollector.util.CollectionType;
import com.sun.scn.servicetags.Agent;
import com.sun.scn.servicetags.SvcTag;
import com.sun.scn.util.CCRAdapter;
import com.sun.scn.util.CCRAdapterException;
import com.sun.scn.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductRegOfferingInstance
extends AbstractComponent
implements ProductRegOfferingInstanceMBean {
    private String AgentUuidAttributeVal = "4c111d85-7968-11d9-b344-080020a9ed93";
    public static final String AMS_WEBSERVICE_ENDPOINT = "ams.webservice.url";
    public static String assetId;
    public String hostname;
    private static final Logger LOG;
    protected final ProductRegOfferingFactoryMBean myFact;
    protected static MBeanServer myMbs;
    public static final String host;
    protected ClassLoader myClassloader;
    private static SCNClientLoginMBean scnClientLoginMBean;
    private static SCNClientRegistrationMBean scnClientRegistrationMBean;
    private static SCNBaseServiceFactoryMBean scnBaseServiceFactoryMBean;
    public static SystemInfoHelper systemInfoHelper;
    public static SystemInfoHelper systemInfoHelperReg;
    private static final String SWUP_PORTAL_ENABLE = "true";
    private static final String SWUP_PORTAL_DISABLE = "false";
    private boolean swupPortalEnable;
    public Document systemInformation = null;
    public Document systemInformationReg = null;
    private static final String OBJECT_NAME_KEY = "name";
    private static final String OBJECT_HOST_KEY = "host";
    private static final String OBJECT_VENDOR_KEY = "Vendor";
    private static final String OBJECT_SCN_TYPE_KEY = "scnType";
    private static final String OBJECT_ASSET_PROFILE_KEY = "assetProfile";
    private static final String OBJECT_ASSET_SUB_PROFILE_KEY = "assetSubProfile";
    private static final String OBJECT_SUN_VALUE = "Sun Microsystems Inc";
    private static final String OBJECT_SERVICE_FACTORY_VALUE = "ServiceFactory";
    private static final String OBJECT_FACTORY_VALUE = "Factory";
    public static final String HTTPPROXY_IPADDR_KEY = "cns.httpproxy.ipaddr";
    public static final String HTTPPROXY_PORT_KEY = "cns.httpproxy.port";
    public static final String HTTPPROXY_AUTH_KEY = "cns.httpproxy.auth";
    private String _patchProProxyHost;
    private String _patchProProxyPort;
    private String _patchProProxyUser;
    private String _patchProProxyPasswd;
    private static final String SWUP_PROXY_HOST = "patchpro.proxy.host";
    private static final String SWUP_PROXY_PORT = "patchpro.proxy.port";
    private static final String SWUP_PROXY_USER = "patchpro.proxy.user";
    private static final String SWUP_PROXY_PASSWD = "patchpro.proxy.passwd";
    private static final String PKGINFO_CMD = "/usr/bin/pkginfo";
    private static final String SOLTAGS_PKG = "SUNWstosreg";
    private static final String AGENT_URN = "urn:st:br_1.1.2:";
    private static SCNNetworkProxyConfigMBean scnNetworkProxyConfigMBean;
    private Domain currentDomain;
    private List<Domain> domains;

    protected static SCNNetworkProxyConfigMBean getSCNNetworkProxyConfigMBean() throws AssetRegistrationException {
        LOG.log(Level.INFO, "in getSCNNetwork_ProxyConfigMBean");
        if (scnNetworkProxyConfigMBean == null) {
            ObjectName objectName = ProductRegOfferingInstance.getSCNBaseServiceFactoryMBean().getInstanceName("SCNNetworkProxyConfig");
            scnNetworkProxyConfigMBean = MBeanServerInvocationHandler.newProxyInstance(myMbs, objectName, SCNNetworkProxyConfigMBean.class, false);
        }
        return scnNetworkProxyConfigMBean;
    }

    public ProductRegOfferingInstance(ProductRegOfferingFactoryMBean factory, Object entity, String theName, Properties props, MBeanServer theMbs, String module) {
        super(factory.getObjectName(), entity, theName, props, module);
        this.myFact = factory;
        myMbs = theMbs;
        this.myClassloader = this.getClass().getClassLoader();
    }

    public void init_collect() {
        this.getSystemInformation("solaris");
        if (this.systemInformation != null) {
            systemInfoHelper = new SystemInfoHelper(this.systemInformation);
            systemInfoHelper.setSysInfoValueByName("asset.id", assetId);
            systemInfoHelper.setSysInfoAttributeValueByName("computer.system", "agentUuid", this.AgentUuidAttributeVal);
            this.hostname = systemInfoHelper.getSysInfoValueByName("host.name");
        }
    }

    public final String getResourceType() {
        return "TODO Product Registration Offering";
    }

    public boolean getSWUPPortalEnableKey() {
        return this.swupPortalEnable;
    }

    public void setSWUPPortalEnableKey(boolean isEnabled) {
        this.swupPortalEnable = isEnabled;
    }

    protected void setSwupEnableFlagAssetIdInCCR(boolean isSwupPortalEnable) {
        try {
            CCRAdapter ccr = new CCRAdapter(LOG);
            String oldAssetId = ccr.getValue("cns.assetid");
            if (!assetId.equals(oldAssetId) || isSwupPortalEnable) {
                ccr.setValue("cns.br.SunUCenabled", Boolean.toString(isSwupPortalEnable));
            }
            ccr.setValue("cns.assetid", assetId);
            LOG.log(Level.INFO, "Wrote cns.br.SunUCenabled: " + Boolean.toString(isSwupPortalEnable) + " and cns.assetid:" + assetId);
        }
        catch (CCRAdapterException caex) {
            LOG.log(Level.SEVERE, "Unable to write swup portal enable status via SCN to CCR.");
            this.log(Level.SEVERE, caex.getMessage());
        }
    }

    private void setAssetId(String theId) {
        assetId = theId;
    }

    @Override
    public String getAssetId() {
        return assetId;
    }

    protected String getPublicKey() {
        String publicKey = null;
        LOG.log(Level.INFO, "in getPublicKey()");
        try {
            CCRAdapter ccr = new CCRAdapter(LOG);
            publicKey = ccr.getValue("cns.security.publickey");
            systemInfoHelperReg.setSysInfoValueByName("public.key", publicKey);
        }
        catch (CCRAdapterException caex) {
            LOG.log(Level.SEVERE, "Did not get Public Key from SCN CCR.");
            this.log(Level.SEVERE, caex.getMessage());
        }
        return publicKey;
    }

    @Override
    public String getHostname() {
        if (this.systemInformation == null) {
            this.getSystemInformation("solaris");
        }
        return this.hostname;
    }

    @Override
    public Document getSystemInformation(String dataName) {
        LOG.log(Level.INFO, "CALLING getSystemInformation  ");
        this.systemInformation = null;
        if (this.systemInformation == null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put(OBJECT_NAME_KEY, "SolarisAssetFactory");
            map.put(OBJECT_HOST_KEY, host);
            map.put(OBJECT_ASSET_PROFILE_KEY, "compute-host");
            map.put(OBJECT_ASSET_SUB_PROFILE_KEY, "base-compute-host");
            map.put(OBJECT_VENDOR_KEY, OBJECT_SUN_VALUE);
            map.put(OBJECT_SCN_TYPE_KEY, "AssetFactory");
            try {
                ObjectName factON = new ObjectName(this.getDomain(), map);
                SolarisAssetFactoryMBean exfact = MBeanServerInvocationHandler.newProxyInstance(myMbs, factON, SolarisAssetFactoryMBean.class, false);
                ObjectName[] names = exfact.getInstanceObjectNames();
                if (names.length > 0) {
                    LOG.log(Level.INFO, "Find the following asset instances:");
                    for (int i = 0; i < names.length; ++i) {
                        LOG.log(Level.INFO, "asset instances:" + i + names[i]);
                    }
                    SolarisAssetInstanceMBean sam = MBeanServerInvocationHandler.newProxyInstance(myMbs, names[0], SolarisAssetInstanceMBean.class, false);
                    if (dataName.equals("full")) {
                        LOG.log(Level.INFO, "getSystemInformation(CollectionType.SWUP_FULL)");
                        this.systemInformation = sam.getSystemInformation(CollectionType.SWUP_FULL);
                    } else if (dataName.equals("limited")) {
                        LOG.log(Level.INFO, "getSystemInformation(CollectionType.SWUP_PARTIAL)");
                        this.systemInformation = sam.getSystemInformation(CollectionType.SWUP_PARTIAL);
                    } else if (dataName.equals("solaris")) {
                        LOG.log(Level.INFO, "getSystemInformation(CollectionType.SOLARIS_ONLY)");
                        this.systemInformation = sam.getSystemInformation(CollectionType.SOLARIS_ONLY);
                    }
                    String myId = (String)myMbs.getAttribute(names[0], "AssetId");
                    this.setAssetId(myId);
                } else {
                    LOG.log(Level.INFO, "There is no SolarisAssetInstance found");
                    this.systemInformation = null;
                }
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "caught exception", x);
            }
            return this.systemInformation;
        }
        return this.systemInformation;
    }

    protected void setPatchProProxy() {
        try {
            this.setPatchProProxyHost(ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getHost());
            this.setPatchProProxyPort(ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getPort());
            this.setPatchProProxyUser(ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getUser());
            this.setPatchProProxyPassword(ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getPassword());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "error reading proxy parameters from SCNBase");
        }
    }

    public void setPatchProProxyHost(String host) {
        this._patchProProxyHost = host == null ? "" : host;
        this.setPatchProParam(SWUP_PROXY_HOST, this._patchProProxyHost);
    }

    public void setPatchProProxyPort(String port) {
        this._patchProProxyPort = port == null ? "" : port;
        this.setPatchProParam(SWUP_PROXY_PORT, this._patchProProxyPort);
    }

    public void setPatchProProxyUser(String user) {
        this._patchProProxyUser = user == null ? "" : user;
        this.setPatchProParam(SWUP_PROXY_USER, this._patchProProxyUser);
    }

    public void setPatchProProxyPassword(String passwd) {
        this._patchProProxyPasswd = passwd == null ? "" : passwd;
        this.setPatchProParam(SWUP_PROXY_PASSWD, this._patchProProxyPasswd);
    }

    public boolean setPatchProParam(String param, String value) {
        if (param == null || value == null) {
            return false;
        }
        String[] cmd = new String[3];
        cmd[0] = "/usr/sbin/smpatch";
        if (value == "" || value.length() == 0) {
            cmd[1] = "unset";
            cmd[2] = param;
        } else {
            cmd[1] = "set";
            cmd[2] = param + "=" + value;
        }
        try {
            LOG.info("running cmd " + cmd[0] + " to " + cmd[1] + " " + param);
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            return proc.exitValue() == 0;
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + cmd);
            LOG.severe(e.toString());
            return false;
        }
    }

    public String getPatchProParam(String param) {
        if (param == null) {
            return null;
        }
        String[] cmd = new String[3];
        String result = null;
        cmd[0] = "/usr/sbin/smpatch";
        cmd[1] = "get";
        cmd[2] = param;
        try {
            LOG.info("In SWUPOM, running cmd " + cmd[0] + " to " + cmd[1] + " " + cmd[2]);
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            result = reader.readLine().trim();
            reader.close();
            if (proc.exitValue() == 0) {
                return result;
            }
            return null;
        }
        catch (Exception e) {
            LOG.severe("Cannot exec " + cmd);
            LOG.severe(e.toString());
            return null;
        }
    }

    protected static void setValueIntoCCR(String key, String value) throws CCRAdapterException {
        CCRAdapter ccr = new CCRAdapter(LOG);
        if (value == null || "".equals(value)) {
            LOG.log(Level.INFO, "value for " + key + " is null/\"\", do nothing");
        } else {
            ccr.setValue(key, value);
            LOG.log(Level.INFO, key + " in CCR set to := \"" + value + "\"");
        }
    }

    protected void setProxyIntoCCR() {
        try {
            ProductRegOfferingInstance.setValueIntoCCR(HTTPPROXY_IPADDR_KEY, ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getHost());
            ProductRegOfferingInstance.setValueIntoCCR(HTTPPROXY_PORT_KEY, ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getPort());
            String value = ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getUser() + ":" + ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getPassword();
            ProductRegOfferingInstance.setValueIntoCCR(HTTPPROXY_AUTH_KEY, "null:null".equals(value) ? "" : value);
            LOG.log(Level.INFO, "Done! set HTTP proxy info into CCR");
        }
        catch (CCRAdapterException caex) {
            LOG.log(Level.SEVERE, "cannot set Proxy values in CCR");
            this.log(Level.SEVERE, caex.getMessage());
        }
        catch (AssetRegistrationException ae) {
            LOG.log(Level.SEVERE, "cannot set Proxy values in CCR");
            this.log(Level.SEVERE, ae.getMessage());
        }
    }

    @Override
    public boolean register() throws AssetRegistrationException {
        boolean bReturn = false;
        ClassLoader save = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.myClassloader);
        String authToken = null;
        String regToken = null;
        Object publicKey = null;
        this.systemInformationReg = (Document)this.systemInformation.clone();
        systemInfoHelperReg = new SystemInfoHelper(this.systemInformationReg);
        this.insertOptionToXML(this.systemInformationReg);
        String package_element = systemInfoHelperReg.removeSysInfoValueByName("package.inventory");
        String patch_element = systemInfoHelperReg.removeSysInfoValueByName("patch.inventory");
        try {
            String ePoint = this.getAMSWebserviceEndpoint();
            LOG.log(Level.INFO, "AMS endpoint is-->" + ePoint);
            AssetManagementServiceProvider aTest = new AssetManagementServiceProvider(ePoint);
            authToken = this.getAuthToken();
            regToken = this.getRegToken();
            RegisterResponse rr = aTest.registerAsset(this.getMscId(), authToken, regToken, this.systemInformationReg);
            if (authToken != null) {
                this.setRegToken(rr.getRegToken());
            }
            LOG.log(Level.INFO, "Done! This asset has been registered with AMS.");
            this.setSwupEnableFlagAssetIdInCCR(false);
            LOG.log(Level.INFO, "swup enable status has been written to CCR.");
            Format f = Format.getPrettyFormat();
            f.setLineSeparator("\n");
            XMLOutputter xout = new XMLOutputter(f);
            this.registerOSServiceTag();
            bReturn = true;
        }
        catch (Exception e) {
            this.clearPassWord();
            e.printStackTrace();
            throw new AssetRegistrationException("Failed to register asset with AMS. Error message is :" + e);
        }
        if (bReturn) {
            this.setProxyIntoCCR();
        }
        return bReturn;
    }

    public final MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "javax.management.AttributeChangeNotification", "Property Change for Offering Logic ")};
    }

    public ObjectName getFactoryName() {
        return this.myFact.getObjectName();
    }

    public OfferingFactoryMBean getFactory() {
        return this.myFact;
    }

    public String getOfferingType() {
        return this.myFact.getOfferingType();
    }

    public ObjectName[] getAssociatedAsset() {
        return null;
    }

    protected String getMscId() {
        String mscId = "test";
        try {
            mscId = ProductRegOfferingInstance.getSCNClientRegistrationMBean().getMSCIdentifier();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Did not get MSC identifier from SCNClientRegistrationMBean.");
        }
        return mscId;
    }

    protected String getAuthToken() {
        String authToken = null;
        try {
            authToken = ProductRegOfferingInstance.getSCNClientLoginMBean().getAuthToken();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Did not get authToken from SCNClientLoginMBean.");
        }
        return authToken;
    }

    protected void registerOSServiceTag() {
        String agentUrn;
        SvcTag osTag;
        ServiceTagRegistry svcTagReg;
        String clientId;
        KeyPair keyPair;
        int proxyPort;
        String proxyHost;
        String[] cmd = new String[3];
        try {
            cmd[0] = PKGINFO_CMD;
            cmd[1] = "-q";
            cmd[2] = SOLTAGS_PKG;
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            if (proc.exitValue() != 0) {
                return;
            }
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "IO error detected while checking whether the Service Tags Solaris OS Registration package is installed. " + ioe.getMessage());
            this.clearPassWord();
            return;
        }
        catch (SecurityException se) {
            LOG.log(Level.INFO, "Security problem detected while checking whether the Service Tags Solaris OS Registration package is installed. " + se.getMessage());
            this.clearPassWord();
            return;
        }
        catch (NullPointerException npe) {
            LOG.log(Level.INFO, "Program error. Null pointer exception detected while checking whether the Service Tags Solaris OS Registration package is installed. " + npe.getMessage());
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(npe));
            this.clearPassWord();
            return;
        }
        catch (IndexOutOfBoundsException ioobe) {
            LOG.log(Level.INFO, "Program error. Index out of bounds exeception detected while checking whether the Service Tags Solaris OS Registration package is installed. " + ioobe.getMessage());
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(ioobe));
            this.clearPassWord();
            return;
        }
        catch (InterruptedException ie) {
            LOG.log(Level.INFO, "Interruption exception detected while checking whether the Service Tags Solaris OS Registration package is installed. " + ie.getMessage());
            this.clearPassWord();
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            this.clearPassWord();
            return;
        }
        String user = this.getUserName();
        String pass = this.getPassWord();
        try {
            String sProxyPort;
            proxyHost = ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getHost();
            if (proxyHost == null) {
                proxyHost = "";
            }
            proxyPort = (sProxyPort = ProductRegOfferingInstance.getSCNNetworkProxyConfigMBean().getPort()) == null ? -1 : new Integer(sProxyPort);
        }
        catch (AssetRegistrationException asre) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Failed to create an instance of the object used to configure the network proxy settings.", asre);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
        try {
            SCRKClientHelper clientHelper = new SCRKClientHelper();
            keyPair = clientHelper.getKeyPair();
            clientId = clientHelper.getClientRegId(keyPair, user, pass, proxyHost, proxyPort);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Failed to generate a keypair for communication with SCRK or acquire the client registration ID.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
        try {
            this.domains = null;
            this.domains = proxyHost.equals("") || proxyPort == -1 ? RegSender.getUserDomains((String)user, (KeyPair)keyPair, (String)clientId) : RegSender.getUserDomains((String)user, (String)proxyHost, (int)proxyPort, (KeyPair)keyPair, (String)clientId);
            this.setCurrentDomain(this.domains, user);
            svcTagReg = ServiceTagRegistry.loadLocalRegistry();
        }
        catch (SvcTagException ste) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Problem detected while trying to get a list of user domains for account \"user\".", ste);
            return;
        }
        catch (ServiceTagRegistryException stre) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Unable to access the local Service Tag registry.", stre);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
        try {
            osTag = svcTagReg.getSolarisServiceTag();
            if (osTag == null) {
                LOG.log(Level.INFO, "Storage tag registery interface getSolarisServiceTag() returned a value of null for the Solaris OS service tag.");
                return;
            }
        }
        catch (RegistryNotLoadedException rnle) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. The Solaris OS service tag cannot be found in the local  Service Tag registry.", rnle);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
        try {
            agentUrn = svcTagReg.getRegistryURN();
            if (agentUrn == null) {
                agentUrn = AGENT_URN + UUID.randomUUID().toString();
            }
            Agent agent = new Agent(agentUrn);
            agent.ipAddress = systemInfoHelper.getSysInfoValueByName("ip");
            agent.host = systemInfoHelper.getSysInfoValueByName("host.name");
            agent.system = systemInfoHelper.getSysInfoValueByName(OBJECT_NAME_KEY);
            agent.release = systemInfoHelper.getSysInfoValueByName("version");
            agent.architecture = systemInfoHelper.getSysInfoValueByName("cpu.architecture");
            agent.platform = systemInfoHelper.getSysInfoValueByName("model");
            agent.manufacturer = "";
            agent.cpuManufacturer = "";
            if (proxyHost.equals("") || proxyPort == -1) {
                RegSender.sendPut((Element)agent.toXMLElement(false), (String)("agent/" + agent.getAgentURN()), (KeyPair)keyPair, (String)clientId);
            } else {
                RegSender.sendPut((Element)agent.toXMLElement(false), (String)("agent/" + agent.getAgentURN()), (String)proxyHost, (int)proxyPort, (KeyPair)keyPair, (String)clientId);
            }
        }
        catch (RegistryNotLoadedException rnle) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Unable to get the URN for the local Service Tag registry.", rnle);
            return;
        }
        catch (SvcTagException ste) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Problem detected while registering Agent.", ste);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
        try {
            osTag.setProductDefinedInstID(this.getAssetId());
            osTag.setRegistrationClientURN(AGENT_URN + this.getAssetId());
            osTag.setUserID(ProductRegOfferingInstance.getSCNClientLoginMBean().getUserName());
            osTag.setStatus("REGISTERED");
            osTag.setAgentURN(agentUrn);
            if (this.currentDomain != null) {
                osTag.setDomainId(this.currentDomain.getDomainId());
                osTag.setDomainName(this.currentDomain.getDomainName());
            }
            if (proxyHost.equals("") || proxyPort == -1) {
                RegSender.sendPut((Element)osTag.toXMLElement(), (String)("svctag/" + osTag.getInstanceURN()), (KeyPair)keyPair, (String)clientId);
            } else {
                RegSender.sendPut((Element)osTag.toXMLElement(), (String)("svctag/" + osTag.getInstanceURN()), (String)proxyHost, (int)proxyPort, (KeyPair)keyPair, (String)clientId);
            }
        }
        catch (SvcTagException ste) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful. Problem detected while registering Solaris OS service tag.", ste);
            return;
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Attempt to register Solaris OS service tag was unsuccessful.", e);
            LOG.log(Level.INFO, ProductRegOfferingInstance.getStackTrace(e));
            return;
        }
    }

    protected String getUserName() {
        String username = null;
        try {
            username = ProductRegOfferingInstance.getSCNClientLoginMBean().getUserName();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Did not get username from SCNClientLoginMBean.");
        }
        return username;
    }

    protected String getPassWord() {
        String password = null;
        try {
            password = ProductRegOfferingInstance.getSCNClientLoginMBean().getPassWord();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Did not get password from SCNClientLoginMBean.");
            return password;
        }
        this.clearPassWord();
        return password;
    }

    protected void setCurrentDomain(List<Domain> domains, String user) {
        if (domains != null && user != null) {
            for (Domain d : domains) {
                if (!d.getDomainName().toLowerCase().contains(user.toLowerCase())) continue;
                this.currentDomain = d;
                return;
            }
            this.currentDomain = domains.get(0);
        }
    }

    protected String getRegToken() {
        String regToken = null;
        try {
            regToken = ProductRegOfferingInstance.getSCNClientLoginMBean().getRegistrationToken();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Did not get regToken from SCNClientLoginMBean.");
        }
        return regToken;
    }

    protected void setRegToken(String aRegToken) throws AssetRegistrationException {
        try {
            ProductRegOfferingInstance.getSCNClientLoginMBean().setRegistrationToken(aRegToken);
            LOG.log(Level.INFO, "Finishing setRegistrationToken to SCNClientLoginMBean");
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Can not set registrationToken to SCNClientLoginMBean");
            throw new AssetRegistrationException("Can not set registrationToken to SCNClientLoginMBean " + e);
        }
    }

    private static SCNClientLoginMBean getSCNClientLoginMBean() throws AssetRegistrationException {
        if (scnClientLoginMBean == null) {
            ObjectName objectName = ProductRegOfferingInstance.getSCNBaseServiceFactoryMBean().getInstanceName("SCNClientLogin");
            scnClientLoginMBean = MBeanServerInvocationHandler.newProxyInstance(myMbs, objectName, SCNClientLoginMBean.class, false);
        }
        return scnClientLoginMBean;
    }

    private static SCNClientRegistrationMBean getSCNClientRegistrationMBean() throws AssetRegistrationException {
        if (scnClientRegistrationMBean == null) {
            ObjectName objectName = ProductRegOfferingInstance.getSCNBaseServiceFactoryMBean().getInstanceName("SCNClientRegistration");
            scnClientRegistrationMBean = MBeanServerInvocationHandler.newProxyInstance(myMbs, objectName, SCNClientRegistrationMBean.class, false);
        }
        return scnClientRegistrationMBean;
    }

    protected static SCNBaseServiceFactoryMBean getSCNBaseServiceFactoryMBean() throws AssetRegistrationException {
        if (scnBaseServiceFactoryMBean == null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put(OBJECT_NAME_KEY, "SCNBaseServiceFactory");
            map.put(OBJECT_HOST_KEY, Utils.getLocalHostNames()[0]);
            map.put(OBJECT_VENDOR_KEY, OBJECT_SUN_VALUE);
            map.put(OBJECT_SCN_TYPE_KEY, OBJECT_SERVICE_FACTORY_VALUE);
            map.put(OBJECT_ASSET_PROFILE_KEY, OBJECT_FACTORY_VALUE);
            map.put(OBJECT_ASSET_SUB_PROFILE_KEY, OBJECT_FACTORY_VALUE);
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("com.sun.scn", map);
            }
            catch (MalformedObjectNameException monEx) {
                LOG.severe("Error: unable to obtain SCNBaseServiceFactoryMBean");
                LOG.severe(monEx.getMessage());
                throw new AssetRegistrationException("Error: unable to obtain SCNBaseServiceFactoryMBean", monEx);
            }
            scnBaseServiceFactoryMBean = MBeanServerInvocationHandler.newProxyInstance(myMbs, objectName, SCNBaseServiceFactoryMBean.class, false);
        }
        return scnBaseServiceFactoryMBean;
    }

    protected String getAMSWebserviceEndpoint() {
        LOG.log(Level.INFO, "be called from getAMSWebservice");
        String urn = this.myFact.getConfigProperty(AMS_WEBSERVICE_ENDPOINT);
        LOG.log(Level.INFO, "urn is -->" + urn);
        if (urn != null) {
            String foo;
            urn = foo = urn.replace('\"', ' ').trim();
        }
        return urn;
    }

    private void insertOptionToXML(Document sysInfo) {
        if (sysInfo != null) {
            systemInfoHelperReg.setSysInfoValueByName("swup.portal.enabled", SWUP_PORTAL_DISABLE);
            LOG.log(Level.INFO, "in disable branch - get SWUP_PORTAL_ENABLED_KEY--> " + systemInfoHelperReg.getSysInfoValueByName("swup.portal.enabled"));
        }
    }

    protected static String getStackTrace(Throwable throwable) {
        StringBuffer sb = new StringBuffer("\n");
        StackTraceElement[] stackTraceElements = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            sb.append(stackTraceElements[i].toString()).append("\n");
        }
        return sb.toString();
    }

    protected void clearPassWord() {
        try {
            ProductRegOfferingInstance.getSCNClientLoginMBean().setPassWord(null);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to reset authentication data.");
        }
    }

    static {
        LOG = Logger.getLogger(ProductRegOfferingInstance.class.getName());
        host = Utils.getLocalHostNames()[0];
        scnClientLoginMBean = null;
        scnClientRegistrationMBean = null;
        scnBaseServiceFactoryMBean = null;
        systemInfoHelper = null;
        systemInfoHelperReg = null;
        scnNetworkProxyConfigMBean = null;
    }
}

