/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.offering.prom;

import java.util.Iterator;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class SystemInfoHelper {
    private static final Logger LOG = Logger.getLogger(SystemInfoHelper.class.getName());
    public static final String COMPUTER_SYSTEM_KEY = "computer.system";
    public static final String AGENT_UUID_ATTR = "agentUuid";
    public static final String BOOT_TIME_KEY = "boot.time";
    public static final String CPU_SPEED_KEY = "cpu.speed";
    public static final String CPU_TYPE_KEY = "cpu.type";
    public static final String DNS_DOMAIN_KEY = "dns.domain";
    public static final String HOST_ADDRESSES_KEY = "host.addresses";
    public static final String HOST_ALIASES_KEY = "host.aliases";
    public static final String HOST_ID_KEY = "host.id";
    public static final String HOSTNAME_KEY = "host.name";
    public static final String HW_ARCH_KEY = "hw.arch";
    public static final String HW_VENDOR_KEY = "hw.vendor";
    public static final String IP_KEY = "ip";
    public static final String MAC_ADDRESS_KEY = "mac.address";
    public static final String NIS_DOMAIN_KEY = "nis.domain";
    public static final String NUMBER_CDROMS_KEY = "number.cdroms";
    public static final String NUMBER_CPUS_KEY = "number.cpus";
    public static final String NUMBER_DISKS_KEY = "number.disks";
    public static final String OS_ARCH_KEY = "os.arch";
    public static final String OS_KEY_KEY = "os.name";
    public static final String OS_VERSION_KEY = "os.version";
    public static final String ROM_VERSION_KEY = "rom.version";
    public static final String SERIAL_NUMBER_KEY = "serial.number";
    public static final String SYSTEM_LOCALE_KEY = "system.locale";
    public static final String SYSTEM_MODEL_KEY = "system.model";
    public static final String TIME_ZONE_KEY = "time.zone";
    public static final String TOTAL_DISK_SPACE_KEY = "total.disk.space";
    public static final String TOTAL_MAIN_MEMORY_KEY = "total.main.memory";
    public static final String INSTALLED_SOFTWARE_KEY = "installed.software";
    public static final String FIRMWARE_VERSION_KEY = "firmware.version";
    public static final String OPERATING_SYSTEM_KEY = "operating.system";
    public static final String LOCALE_KEY = "locale";
    public static final String MEMORY_SIZE_KEY = "memory.size";
    public static final String MODEL_KEY = "model";
    public static final String CPU_LIST_KEY = "cpu.list";
    public static final String NETWORK_INTERFACE_CONFIGURATION_KEY = "network.interface.config";
    public static final String STORAGE_INVENTORY_KEY = "storage.inventory";
    public static final String PACKAGE_INVENTORY_KEY = "package.inventory";
    public static final String PATCH_INVENTORY_KEY = "patch.inventory";
    public static final String ASSET_ID_KEY = "asset.id";
    public static final String COMMON_NAME_KEY = "common.name";
    public static final String SUBSCRIPTION_KEY = "subscription.key";
    public static final String SWUP_PORTAL_ENABLED_KEY = "swup.portal.enabled";
    public static final String PUBLICKEY_KEY = "public.key";
    public static final String SLA_VERSION_KEY = "sla.version";
    public static final String DEVICE_ID_KEY = "device.id";
    public static final String DRIVE_SIZE_KEY = "drive.size";
    public static final String BOOTPROM_ID_KEY = "bootprom.id";
    public static final String ARCHITECTURE_KEY = "architecture";
    public static final String SPEED_KEY = "speed";
    public static final String MEMORY_KEY = "memory";
    public static final String STATUS_KEY = "status";
    public static final String VENDOR_KEY = "vendor";
    public static final String PRODUCT_KEY = "product";
    public static final String CPU_KEY = "cpu";
    public static final String SOLARIS_OS_NAME_KEY = "name";
    public static final String SOLARIS_OS_VERSION_KEY = "version";
    public static final String SOLARIS_CPU_ARCHITECTURE_KEY = "cpu.architecture";
    public Document systemInformation = null;

    public SystemInfoHelper(Document sysInfo) {
        this.systemInformation = sysInfo;
    }

    public String getSysInfoValueByName(String name) {
        return this.findEntry(name);
    }

    public String setSysInfoValueByName(String name, String value) {
        return this.updateEntry(name, value);
    }

    public String getSysInfoAttributeValueByName(String key, String attributeName) {
        return this.findAttribute(key, attributeName);
    }

    public String setSysInfoAttributeValueByName(String key, String attributeName, String attributeValue) {
        return this.updateAttribute(key, attributeName, attributeValue);
    }

    public String findEntry(String key) {
        LOG.info("findEntry looking for " + key);
        String result = "";
        String WIDGET = key;
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = this.systemInformation.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (!element.getName().equals(key)) continue;
                result = element.getText();
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    public synchronized String updateEntry(String key, String value) {
        LOG.info("updateEntry looking for " + key);
        String result = "";
        String WIDGET = key;
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = this.systemInformation.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (!element.getName().equals(key)) continue;
                result = element.getText();
                element.removeContent();
                element.addContent(value);
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    public String findAttribute(String key, String attributeName) {
        LOG.info("findAttribute looking for " + key);
        String result = "";
        String WIDGET = key;
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = this.systemInformation.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (!element.getName().equals(key)) continue;
                result = element.getAttributeValue(attributeName);
                LOG.info("key '" + key + "'\n\tattribute name '" + attributeName + "'\n\tattribute value '" + result + "'");
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    public synchronized String updateAttribute(String key, String attributeName, String attributeValue) {
        LOG.info("updateAttribute looking for " + key);
        String result = "";
        String WIDGET = key;
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = this.systemInformation.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (!element.getName().equals(key)) continue;
                result = element.getAttributeValue(attributeName);
                element.setAttribute(attributeName, attributeValue);
                LOG.info("key '" + key + "'\n\tattribute name '" + attributeName + "'\n\tattribute old value '" + result + "'\n\tattribute new value '" + element.getAttributeValue(attributeName) + "'");
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }

    public synchronized String removeSysInfoValueByName(String key) {
        LOG.info("removeSysInfoValueByName looking for " + key);
        String result = null;
        String WIDGET = key;
        ElementFilter filter = new ElementFilter(WIDGET);
        Iterator theIter = this.systemInformation.getDescendants((Filter)filter);
        while (theIter.hasNext()) {
            try {
                Element element = (Element)theIter.next();
                if (!element.getName().equals(key)) continue;
                result = element.getName();
                LOG.info("Detaching element for'" + key + "' next");
                element.detach();
                LOG.info("Detached element '" + key + "'");
                break;
            }
            catch (NullPointerException npe) {
            }
        }
        return result;
    }
}

