/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ocs.cfg;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ias.repository.SchemaManager;
import oracle.ias.repository.schema.SchemaException;

public class OcasAssocData {
    private static String getInitialCalDnEntry() {
        return "cn=Calendar,cn=Products,cn=OracleContext";
    }

    private static String getBaseCalDnEntry() {
        return "cn=VirtualServices,cn=Calendar,cn=Services,cn=OracleContext";
    }

    private static String getOracleHome(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getAssocParamsStr(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getAttributeValue(Attributes attributes, String string) throws NamingException {
        if (attributes == null || string == null || attributes.get(string) == null) {
            return null;
        }
        return (String)attributes.get(string).get();
    }

    private static ArrayList getAssocAttrList(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        ArrayList<String> arrayList = new ArrayList<String>();
        stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static HashMap getCompAssocData(InitialDirContext initialDirContext, String string, String string2) throws NamingException, Exception {
        ArrayList arrayList = OcasAssocData.getAssocAttrList(string2);
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        } else {
            arrayList = new ArrayList();
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(arrayList.get(i), null);
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string3 = "cn=OCAL*";
        NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string, string3, searchControls);
        if (namingEnumeration != null) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            String string4 = "";
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                String string6 = (String)hashMap.get(string5);
                string4 = OcasAssocData.getAttributeValue(attributes, string5);
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "";
                }
                if (string6 != null && string6.trim().length() != 0) continue;
                hashMap.put(string5, string4);
            }
        }
        return hashMap;
    }

    private static void printCompAssocData(HashMap hashMap, String string) {
        ArrayList arrayList = OcasAssocData.getAssocAttrList(string);
        if (hashMap == null || arrayList == null) {
            System.out.println("em_error=Error retrieving assocaite data");
            return;
        }
        OcasAssocData.processNullValues(hashMap);
        int n = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("assoc_result=");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)hashMap.get(arrayList.get(i)));
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        System.out.println(stringBuffer.toString());
    }

    private static void processNullValues(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 != null && string2.trim().length() != 0) continue;
            hashMap.put(string, "");
        }
    }

    private static boolean sslOnly(String string) throws IOException {
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + "config" + string2 + "ias.properties";
        FileInputStream fileInputStream = new FileInputStream(string3);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string4 = properties.getProperty("SSLOnly");
        return string4.compareToIgnoreCase("true") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        InitialContext initialContext = null;
        String string3 = "";
        try {
            String string4 = OcasAssocData.getOracleHome(stringArray);
            string3 = OcasAssocData.getAssocParamsStr(stringArray);
            SchemaManager schemaManager = new SchemaManager(string4);
            string = OcasAssocData.getInitialCalDnEntry();
            boolean bl = OcasAssocData.sslOnly(string4);
            initialContext = schemaManager.connectAs(string, bl);
            string2 = OcasAssocData.getBaseCalDnEntry();
            HashMap hashMap = OcasAssocData.getCompAssocData((InitialDirContext)initialContext, string2, string3);
            OcasAssocData.printCompAssocData(hashMap, string3);
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            System.out.println("em_error=Schema exception occurred while getting the Calendar Application component associate data.  " + schemaException.getMessage());
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            System.out.println("em_error=Naming exception occurred while getting associate data for the Calendar component associate data.  " + namingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("em_error=Exception occured while opening ias.property.\n " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("em_error=Exception occurred while getting the calendar component associate data.  " + exception.getMessage());
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {}
        }
    }
}

