/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.base;

import com.peoplesoft.pt.ccr.qry.pub.base.Archive;
import com.peoplesoft.pt.ccr.qry.pub.base.Configuration;
import com.peoplesoft.pt.ccr.qry.pub.base.DefNamespaceContext;
import com.peoplesoft.pt.ccr.qry.pub.base.Log;
import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import com.peoplesoft.pt.ccr.qry.pub.base.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileMgr {
    private static FileMgr mgr = null;
    public static final String CCR = "ccr";
    private static String psHome = null;
    private static String ccrHome = null;
    private static final String QUERY_PUB = "publish/product[@name=\"{0}\"]/query";
    private static Archive archive = null;

    private FileMgr(String home) {
        ccrHome = home;
    }

    public static FileMgr createInstance() {
        if (mgr == null) {
            mgr = new FileMgr(Configuration.getCCRHome());
        }
        return mgr;
    }

    public static String getPSHOME() {
        if (psHome == null) {
            FileMgr.goBackXDirs(FileMgr.getCCRHome(), 1);
        }
        return psHome;
    }

    public static String getCCRHome() {
        return ccrHome;
    }

    public static Archive getCCRRepository() {
        if (null == archive) {
            try {
                archive = new Archive();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return archive;
    }

    public static String getWSReqTemplate(String name) {
        Log.getLogger().fine("Reading template:" + name);
        return FileMgr.getCCRRepository().readFileFromArchive("query/webrequests/" + name);
    }

    public Document getCCRPub() {
        Log.getLogger().fine("Reading pub:query/config/ccrpub.xml");
        return this.readDocFromRep("query/config/ccrpub.xml");
    }

    public static String getCCRQuery(String name) {
        Log.getLogger().fine("Reading query:query/def/" + name);
        return FileMgr.getCCRRepository().readFileFromArchive("query/def/" + name);
    }

    private static String goBackXDirs(String directoryPath, int goBack) {
        String dirPath = null;
        File file = new File(directoryPath);
        for (int i = 0; i < goBack; ++i) {
            dirPath = file.getParent();
            if (dirPath == null) {
                return null;
            }
            file = new File(dirPath);
        }
        return dirPath;
    }

    public Query[] GetQueriesforApplication(String appName, Float version) {
        QueryFinder finder = new QueryFinder(appName, version);
        NodeList list = XMLUtils.queryDocument(this.getCCRPub(), this.buildQuery(appName), new DefNamespaceContext());
        String[] queries = new String[list.getLength()];
        Log.getLogger().fine("Queries to be exectuted");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            NamedNodeMap map = child.getAttributes();
            String qryName = map.getNamedItem("name").getNodeValue();
            String qryFile = map.getNamedItem("file").getNodeValue();
            String qryVer = map.getNamedItem("version") != null ? map.getNamedItem("version").getNodeValue() : null;
            finder.addQuery(qryName, qryFile, qryVer);
            Log.getLogger().fine(queries[i] + "\n");
        }
        return finder.getQuerues();
    }

    public String[] GetRecordsForQuery(String query) {
        NodeList list = XMLUtils.queryDocument(this.readDocFromRep("query/def/" + query), "//RCDNAME", new DefNamespaceContext());
        String[] records = new String[list.getLength()];
        for (int i = 0; i < list.getLength(); ++i) {
            records[i] = list.item(i).getTextContent();
        }
        return records;
    }

    private String buildQuery(String app) {
        return this.makeMessage(QUERY_PUB, app);
    }

    private String makeMessage(String message, String ... arguments) {
        String test = MessageFormat.format(message, arguments);
        return test;
    }

    public String readFromRep(String file) {
        if (null != FileMgr.getCCRRepository()) {
            return FileMgr.getCCRRepository().readFileFromArchive(file);
        }
        return null;
    }

    public Document readDocFromRep(String file) {
        if (null != FileMgr.getCCRRepository()) {
            try {
                return FileMgr.getCCRRepository().getDocumentFromArchive(file);
            }
            catch (Exception e) {
                new ServiceException(e.getMessage(), e);
            }
        }
        return null;
    }

    public class Query {
        private String query;
        private String file;
        private Float version = new Float(0.0f);

        public Query(String qry, String fle, Float ver) {
            this.query = qry;
            this.file = fle;
            this.version = ver;
        }

        public String getQuery() {
            return this.query;
        }

        public String getQueryFile() {
            return this.file;
        }

        public Float getVersion() {
            return null == this.version ? new Float(0.0f) : this.version;
        }
    }

    class QueryFinder {
        private String appName;
        private Float appVersion;
        private HashMap<String, String> queryFile = new HashMap();
        private HashMap<String, Float> queryVer = new HashMap();

        QueryFinder(String name, Float version) {
            this.appName = name;
            this.appVersion = version;
        }

        public void addQuery(String query, String file, String version) {
            if (this.queryVer.get(query) == null || null == version) {
                this.queryVer.put(query, new Float(0.0f));
                this.queryFile.put(query, file);
            } else if (version != null && this.appVersion != null) {
                Float curVer;
                Float ver = new Float(0.0f);
                try {
                    ver = new Float(version);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Float f = curVer = this.queryVer.get(query) != null ? this.queryVer.get(query) : new Float(0.0f);
                if (ver.compareTo(this.appVersion) < 0 && ver.compareTo(curVer) > 0) {
                    this.queryFile.put(query, file);
                    this.queryVer.put(query, curVer);
                }
            }
        }

        public Query[] getQuerues() {
            ArrayList<Query> queries = new ArrayList<Query>();
            for (String qry : this.queryFile.keySet()) {
                queries.add(new Query(qry, this.queryFile.get(qry), this.queryVer.get(qry)));
            }
            return queries.toArray(new Query[0]);
        }
    }
}

