/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.base;

import com.peoplesoft.pt.ccr.qry.pub.base.RequestMessage;
import com.peoplesoft.pt.ccr.qry.pub.base.ResponseMessage;
import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import com.peoplesoft.pt.ccr.qry.pub.base.WSConfiguration;
import com.peoplesoft.pt.ccr.qry.pub.base.XMLUtils;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;

public abstract class PSService {
    private Service service = null;
    protected Dispatch<Source> sourceDispatch = null;

    public PSService() {
    }

    public PSService(WSConfiguration config, String serviceURL) throws ServiceException {
        try {
            this.service = Service.create((QName)config.getPort());
            this.service.addPort(config.getService(), "http://schemas.xmlsoap.org/wsdl/soap/http", serviceURL);
            this.sourceDispatch = this.service.createDispatch(config.getService(), Source.class, Service.Mode.MESSAGE);
            Dispatch<Source> bp = this.sourceDispatch;
            Map rc = bp.getRequestContext();
            rc.put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
            rc.put("javax.xml.ws.soap.http.soapaction.uri", config.getSoapAction());
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public ResponseMessage invoke(RequestMessage request) throws ServiceException {
        try {
            Source src = (Source)this.sourceDispatch.invoke((Object)request.getMessage());
            return new ResponseMessage(XMLUtils.convertSaxSourcetoDom(src));
        }
        catch (SOAPFaultException e) {
            String message = "";
            message = message + "\n-------------------------------------------------------\n";
            Iterator ports = this.service.getPorts();
            while (ports.hasNext()) {
                message = message + "Service:" + ((QName)ports.next()).getLocalPart() + "\n";
            }
            message = message + "Operation:" + this.service.getServiceName().getLocalPart() + "\n";
            message = message + "Soap fault: " + (e.getFault().getDetail() != null && e.getFault().getDetail().getFirstChild() != null ? e.getFault().getDetail().getFirstChild().getTextContent() : e.getMessage()) + "\n";
            message = message + "Please verify whether the service operations are published ";
            message = message + "and you have CCR publisher privileges to invoke them.\n";
            message = message + "-------------------------------------------------------\n";
            throw new ServiceException(message, e);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e instanceof UnknownHostException) {
                message = "Unknown Host: " + e.getMessage() + "\n";
            }
            throw new ServiceException(message, e);
        }
    }
}

