/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.base;

import com.peoplesoft.pt.ccr.qry.pub.atns.PSPortBinding;
import com.peoplesoft.pt.ccr.qry.pub.atns.PSWebService;
import com.peoplesoft.pt.ccr.qry.pub.base.InvalidConfigurationException;
import com.peoplesoft.pt.ccr.qry.pub.base.PSService;
import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;

public class WSConfiguration {
    private URL serviceURI = null;
    private QName service = null;
    private QName port = null;
    private String soapAction;

    private WSConfiguration() {
    }

    private WSConfiguration(URL serviceEndpoint, QName addnumbersimplservice, QName addnumbersimplport, String soapAction) {
        this.service = addnumbersimplservice;
        this.port = addnumbersimplport;
        this.soapAction = soapAction;
        this.serviceURI = serviceEndpoint;
    }

    public static WSConfiguration configure(Class<? extends PSService> service, String soapURL) throws InvalidConfigurationException, ServiceException {
        PSWebService svcConf = service.getAnnotation(PSWebService.class);
        PSPortBinding bindConf = service.getAnnotation(PSPortBinding.class);
        try {
            return new WSConfiguration(new URL(soapURL), new QName(svcConf.serviceNamespace(), svcConf.serviceName()), new QName(bindConf.portNamespace(), bindConf.portName()), bindConf.soapBinding());
        }
        catch (MalformedURLException e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    public URL getServiceURI() {
        return this.serviceURI;
    }

    public QName getService() {
        return this.service;
    }

    public QName getPort() {
        return this.port;
    }

    public String getSoapAction() {
        return this.soapAction;
    }
}

