/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.base;

import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static Element readXMLFile(String filename) {
        Document doc = XMLUtils.readFileCreateDocument(filename);
        return doc.getDocumentElement();
    }

    public static Document readFileCreateDocument(String filename) {
        Document xml = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            xml = parser.parse(new File(filename));
        }
        catch (Exception e) {
            System.out.println("Couldnt read file " + filename + " " + e);
        }
        return xml;
    }

    public static NodeList queryDocument(Object doc, String xpathExp, NamespaceContext context) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            xpath.setNamespaceContext(context);
            XPathExpression expr = xpath.compile(xpathExp);
            return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            new ServiceException(e.getMessage(), e);
            return null;
        }
    }

    public static Document stringToDom(String xmlSource) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            return parser.parse(new InputSource(new StringReader(xmlSource)));
        }
        catch (ParserConfigurationException e) {
            new ServiceException(e.getMessage(), e);
        }
        catch (SAXException e) {
            new ServiceException(e.getMessage(), e);
        }
        catch (IOException e) {
            new ServiceException(e.getMessage(), e);
        }
        return null;
    }

    public static String xmlToString(Document doc) {
        try {
            DOMSource source = new DOMSource(doc.getDocumentElement());
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            new ServiceException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            new ServiceException(e.getMessage(), e);
        }
        return null;
    }

    public static String readXMLAsString(String file) {
        try {
            FileInputStream is = new FileInputStream(file);
            int x = ((InputStream)is).available();
            byte[] b = new byte[x];
            ((InputStream)is).read(b);
            String content = new String(b);
            ((InputStream)is).close();
            return content;
        }
        catch (IOException e) {
            new ServiceException(e.getMessage(), e);
            return null;
        }
    }

    public static void printSourceToConsole(Source s) {
        try {
            System.out.println("\n=============================XML Received from Server =========================================");
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMResult test = new DOMResult();
            transformer.transform(s, test);
            XMLUtils.printNodeToConsole(test.getNode());
            System.out.println("\n======================================================================");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void printNodeToConsole(Node n) {
        try {
            System.out.println("\n=============================XML Received from Server =========================================");
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(n), new StreamResult(System.out));
            System.out.println("\n======================================================================");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static DOMSource convertSaxSourcetoDom(Source s) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMResult test = new DOMResult();
            transformer.transform(s, test);
            return new DOMSource(test.getNode());
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }
}

