/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.client;

import com.peoplesoft.pt.ccr.qry.pub.base.Configuration;
import com.peoplesoft.pt.ccr.qry.pub.base.FileMgr;
import com.peoplesoft.pt.ccr.qry.pub.base.Log;
import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import com.peoplesoft.pt.ccr.qry.pub.client.ProgressBar;
import com.peoplesoft.pt.ccr.qry.pub.client.Publisher;
import com.peoplesoft.pt.ccr.qry.pub.client.PublisherFactory;
import java.io.Console;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class ConsolePublisher
implements Observer {
    ExecutorService executor = Executors.newFixedThreadPool(1);
    transient boolean interrupted = false;
    String message = "";
    Publisher pub = null;
    FileMgr.Query[] queries = null;

    void publishProcess(Configuration cfg) throws InterruptedException, ServiceException {
        this.pub = PublisherFactory.createPublisher(cfg);
        this.queries = this.pub.getQueries();
        ProgressBar prog = new ProgressBar(this.queries.length);
        this.pub.addObserver(prog);
        FutureTask<Publisher> future = new FutureTask<Publisher>(new Callable<Publisher>(){

            @Override
            public Publisher call() {
                try {
                    return ConsolePublisher.this.pub.publishQueries(ConsolePublisher.this.queries);
                }
                catch (ServiceException e) {
                    Log.getLogger().severe("Could not publish queries");
                    return ConsolePublisher.this.pub;
                }
            }
        });
        this.executor.execute(future);
        while (!future.isDone() && !this.interrupted) {
            try {
                prog.progress(this.pub.getCurrentQuery());
                Thread.sleep(250L);
            }
            catch (Exception ex) {}
        }
        this.executor.shutdown();
        if (this.interrupted) {
            System.err.println("Publishing aborted: " + this.message);
        }
    }

    public static void printUsage() {
        System.err.println("\n<!--");
        System.err.println("usage: com.ps.ccr.qry.publisher.client.Publisher -CCRHOME <CCRHOME> -SOAPURL <SOAPURL> -u <USERID> -p <PASSWORD>");
        System.err.println("--!>");
        System.exit(-1);
    }

    public static void main(String[] args) {
        String ccrHome = null;
        String soapURl = null;
        String userID = null;
        String pwd = null;
        if (args.length == 8) {
            for (int i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
                if (args[i].toUpperCase().equals("-CCRHOME")) {
                    ccrHome = args[++i];
                    continue;
                }
                if (args[i].toUpperCase().equals("-SOAPURL")) {
                    soapURl = args[++i];
                    continue;
                }
                if (args[i].toUpperCase().equals("-U")) {
                    userID = args[++i];
                    continue;
                }
                if (args[i].toUpperCase().equals("-P")) {
                    pwd = args[++i];
                    continue;
                }
                ConsolePublisher.printUsage();
            }
        } else {
            Console cons = System.console();
            if (cons != null) {
                ccrHome = args.length > 1 && args[0].equals("-CCRHOME") ? args[1] : "";
                while (ConsolePublisher.isEmpty(soapURl) || !ConsolePublisher.IsUrl(soapURl)) {
                    System.out.println("Provide SOAP url. (Format: https://<hostname>:<port>/PSIGW/PeopleSoftServiceListeningConnector):");
                    soapURl = cons.readLine();
                }
                while (ConsolePublisher.isEmpty(userID)) {
                    System.out.println("Provide User ID:");
                    userID = cons.readLine();
                }
                while (ConsolePublisher.isEmpty(pwd)) {
                    System.out.println("Provide Password:");
                    char[] passwd = cons.readPassword();
                    pwd = new String(passwd);
                }
            }
        }
        Log.getLogger();
        Configuration cfg = new Configuration().addProperty("soapurl", soapURl).addProperty("ccrhome", ccrHome).addProperty("username", userID).addProperty("password", pwd);
        ConsolePublisher pub = new ConsolePublisher();
        try {
            pub.publishProcess(cfg);
        }
        catch (InterruptedException e) {
            Log.getLogger().severe(e.getMessage());
        }
        catch (ServiceException e) {
            Log.getLogger().severe(e.getMessage());
        }
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg != null && arg.toString().startsWith("ERROR")) {
            this.interrupted = true;
        }
    }

    private static boolean isEmpty(String s) {
        return null == s || s.equals("");
    }

    private static boolean IsUrl(String url) {
        return url != null && url.matches("^http[s]?://[-a-zA-Z0-9_.:]+[-a-zA-Z0-9_:@&?=+,.!/~*'%$]*$");
    }
}

