/*
 * Decompiled with CFR 0.152.
 */
package com.peoplesoft.pt.ccr.qry.pub.client;

import com.peoplesoft.pt.ccr.qry.pub.base.Configuration;
import com.peoplesoft.pt.ccr.qry.pub.base.FileMgr;
import com.peoplesoft.pt.ccr.qry.pub.base.Log;
import com.peoplesoft.pt.ccr.qry.pub.base.ServiceException;
import com.peoplesoft.pt.ccr.qry.pub.base.Session;
import com.peoplesoft.pt.ccr.qry.pub.base.SessionFactoy;
import com.peoplesoft.pt.ccr.qry.pub.client.Publisher;
import com.peoplesoft.pt.ccr.qry.pub.client.ws.AddRecordsToTree;
import com.peoplesoft.pt.ccr.qry.pub.client.ws.DeleteQuery;
import com.peoplesoft.pt.ccr.qry.pub.client.ws.SaveQuery;
import com.peoplesoft.pt.ccr.qry.pub.client.ws.SearchQuery;
import com.peoplesoft.pt.ccr.qry.pub.client.ws.WSGetReleaseLabel;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;

public class QryPublisher
extends Observable
implements Publisher {
    SessionFactoy sf = null;
    private transient int count = 0;

    public QryPublisher(Configuration cfg) {
        this.sf = cfg.buildSessionFactory();
    }

    public static void main(String[] args) {
        block2: {
            try {
                FileMgr.createInstance();
                Configuration cfg = new Configuration().addProperty("soapurl", "https://rtdc78454vmc/PSIGW/PeopleSoftServiceListeningConnector").addProperty("ccrhome", "C:/psft/PT850-903R1/PT850-903R1/ccr").addProperty("username", "PSADMIN").addProperty("password", "PSADMIN");
                QryPublisher pub = new QryPublisher(cfg);
                pub.publishQueries(pub.getQueries());
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof UnknownHostException)) break block2;
                Log.getLogger().severe("Could not connect to host: " + Configuration.getSoapURL());
            }
        }
    }

    @Override
    public FileMgr.Query[] getQueries() throws ServiceException {
        Log.log("\n");
        Log.log("Initializing Query publisher\n");
        Log.log("Log is created in " + System.getProperty("user.home") + File.separator + "publisher.log\n");
        FileMgr.Query[] queries = new FileMgr.Query[]{};
        ArrayList<FileMgr.Query> list = new ArrayList<FileMgr.Query>();
        Session rel = this.sf.openSession();
        WSGetReleaseLabel.Release app = rel.createService(WSGetReleaseLabel.class).getReleaseLabel();
        Log.log("Determing the queries to be published for " + app.getAppName() + "\n");
        Log.getLogger().fine("Configuring queries for " + app.getAppName() + "\n");
        queries = FileMgr.createInstance().GetQueriesforApplication(app.getAppName(), app.appVersion());
        list.addAll(Arrays.asList(queries));
        if (!app.getAppName().toLowerCase().equals("peopletools")) {
            queries = FileMgr.createInstance().GetQueriesforApplication("PeopleTools", app.getToolsVer());
            list.addAll(Arrays.asList(queries));
        }
        Log.log("Publishing " + queries.length + " queries for " + app.getAppName() + "\n");
        Log.log("\n");
        return list.toArray(new FileMgr.Query[0]);
    }

    @Override
    public QryPublisher publishQueries(FileMgr.Query[] queries) throws ServiceException {
        String[] rec = null;
        Session srchQry = this.sf.openSession();
        Session delQry = this.sf.openSession();
        Session addRec = this.sf.openSession();
        Session saveQry = this.sf.openSession();
        for (FileMgr.Query query : queries) {
            Log.getLogger().fine("Publishing query : " + query + " [" + ++this.count + "] of " + queries.length);
            rec = FileMgr.createInstance().GetRecordsForQuery(query.getQueryFile());
            addRec.createService(AddRecordsToTree.class).addRecordsToTree(rec);
            for (String recds : rec) {
                Log.getLogger().fine("Adding record :" + recds + " to tree QUERY_TREE_CCR");
            }
            if (srchQry.createService(SearchQuery.class).isQueryExists(query.getQuery())) {
                Log.getLogger().fine("Query :" + query + " exists");
                delQry.createService(DeleteQuery.class).deleteQuery(query.getQuery());
                Log.getLogger().fine("Replacing :" + query);
            }
            saveQry.createService(SaveQuery.class).saveQuery(query.getQueryFile());
            Log.getLogger().fine("Published query :" + query);
        }
        return this;
    }

    @Override
    public int getCurrentQuery() {
        return this.count;
    }
}

