/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Constructed;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ASN1GenericConstructed
implements ASN1TaggedObject,
ASN1Constructed {
    private Vector a = new Vector();
    private int b = 0;
    private ASN1Header c = null;
    private int d;
    private int e;
    private int f = 0;
    private ASN1Object[] g = null;

    public ASN1GenericConstructed(int n) {
        this(n, 128);
    }

    public ASN1GenericConstructed(int n, int n2) {
        this.d = n;
        this.e = n2;
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n) {
        this(aSN1Object, n, 128);
    }

    public ASN1GenericConstructed(ASN1Object aSN1Object, int n, int n2) {
        this(n, n2);
        this.addElement(aSN1Object);
    }

    public ASN1GenericConstructed(Vector vector, int n) {
        this(vector, n, 128);
    }

    public ASN1GenericConstructed(Vector vector, int n, int n2) {
        this(n, n2);
        this.a = vector;
        this.b = 0;
        int n3 = this.a.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.b += ((ASN1Object)this.a.elementAt(i2)).length();
        }
    }

    public ASN1GenericConstructed(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericConstructed(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public ASN1Header getHeader() {
        if (this.c == null) {
            this.c = new ASN1Header(this.d, this.e, 1, this.b);
        }
        return this.c;
    }

    private ASN1Object[] a() {
        if (this.g == null) {
            this.g = ASN1Set.a(this.a, this.f);
        }
        return this.g;
    }

    public int getTag() {
        return this.d;
    }

    public int getTagClass() {
        return this.e;
    }

    public Vector elements() {
        return this.a;
    }

    public int size() {
        return this.a.size();
    }

    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.a.elementAt(n);
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.a.firstElement();
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.a.lastElement();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.a.addElement(aSN1Object);
        this.b += aSN1Object.length();
        this.c = null;
        this.g = null;
    }

    public void setEncodingType(int n) {
        this.f = n;
    }

    public int getEncodingType() {
        return this.f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GENERIC CONSTRUCTED [");
        switch (this.e) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT SPECIFIC");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.e);
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.d);
        stringBuffer.append("] ");
        stringBuffer.append(Utils.toString(this.a));
        return stringBuffer.toString();
    }

    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        if (aSN1Header.getEncodingMethod() == 0) {
            throw new ASN1FormatException("Constructed encoding expected.");
        }
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        this.d = aSN1Header.getTag();
        this.e = aSN1Header.getTagClass();
        this.a = new Vector();
        this.b = 0;
        while (aSN1ConstructedInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1ConstructedInputStream);
            this.a.addElement(aSN1Object);
            this.b += aSN1Object.length();
        }
        aSN1ConstructedInputStream.terminate();
        this.c = null;
        this.g = null;
    }

    public int length() {
        return this.getHeader().totalLength();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.f == 0) {
            int n = this.a.size();
            for (int i2 = 0; i2 < n; ++i2) {
                ((ASN1Object)this.a.elementAt(i2)).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.a();
            for (int i3 = 0; i3 < aSN1ObjectArray.length; ++i3) {
                aSN1ObjectArray[i3].output(outputStream);
            }
        }
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n) throws IOException {
        ASN1GenericConstructed.outputValue(outputStream, vector, n, 128);
    }

    public static void outputValue(OutputStream outputStream, Vector vector, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = vector.size();
        for (n3 = 0; n3 < n5; ++n3) {
            n4 += ((ASN1Object)vector.elementAt(n3)).length();
        }
        outputStream.write(32 + n2 + n);
        ASN1Utils.outputLengthBytes(outputStream, n4);
        n5 = vector.size();
        for (n3 = 0; n3 < n5; ++n3) {
            ((ASN1Object)vector.elementAt(n3)).output(outputStream);
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

