/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.KeyAgreement;
import oracle.security.crypto.core.KeyAgreementException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.d;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public class DHKeyAgreement
extends KeyAgreement {
    private static final ASN1ObjectID a = AlgID.dh.getOID();
    private DHPublicKey b;
    private DHPrivateKey c;

    public DHKeyAgreement() {
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
    }

    public DHKeyAgreement(DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPublicKey(dHPublicKey);
    }

    public DHKeyAgreement(DHPrivateKey dHPrivateKey, DHPublicKey dHPublicKey) throws InvalidKeyException {
        this.setPrivateKey(dHPrivateKey);
        this.setPublicKey(dHPublicKey);
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!algorithmIdentifier.getOID().equals(a)) {
            throw new AlgorithmIdentifierException("Not a Diffie-Hellman key agreement algorithm identifier.");
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(a, false);
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof DHPrivateKey)) {
            throw new InvalidKeyException("The key is not a DHPrivateKey.");
        }
        d.a(privateKey, 4096);
        DHParams dHParams = ((DHPrivateKey)privateKey).getParams();
        if (dHParams == null || dHParams.a() == null || dHParams.b() == null || dHParams.c() == null) {
            throw new InvalidKeyException("Missing parameters in the private key");
        }
        this.c = (DHPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof DHPublicKey)) {
            throw new InvalidKeyException("The key is not a DHPublicKey.");
        }
        d.a(publicKey, 4096);
        DHParams dHParams = ((DHPublicKey)publicKey).getParams();
        if (dHParams == null || dHParams.a() == null || dHParams.b() == null || dHParams.c() == null) {
            throw new InvalidKeyException("Missing parameters in the public key");
        }
        this.b = (DHPublicKey)publicKey;
    }

    public PublicKey getPublicKey() {
        FIPS_140_2.assertReadyState();
        return this.b;
    }

    public String algName() {
        return "Diffie-Hellman";
    }

    public byte[] generateSecret() throws KeyAgreementException {
        FIPS_140_2.assertReadyState();
        if (this.c == null) {
            throw new IllegalStateException("Local party private key is not set yet.");
        }
        if (this.b == null) {
            throw new IllegalStateException("Other party public key is not set yet.");
        }
        d.a(this.c, 4096);
        d.a(this.b, 4096);
        DHParams dHParams = this.c.getParams();
        DHParams dHParams2 = this.b.getParams();
        BigInt bigInt = dHParams.a();
        BigInt bigInt2 = dHParams.c();
        BigInt bigInt3 = dHParams.b();
        if (bigInt.compareTo(dHParams2.a()) != 0 || bigInt2.compareTo(dHParams2.c()) != 0 || bigInt3.compareTo(dHParams2.b()) != 0) {
            throw new KeyAgreementException("Mismatched parameters for local party private key and other party public key");
        }
        BigInt bigInt4 = this.b.a().modPow(this.c.c(), bigInt);
        if (bigInt4.compareTo(BigInt.ONE) == 0) {
            throw new KeyAgreementException("A trivial secret value was generated");
        }
        return Utils.toByteArray(bigInt4);
    }
}

