/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHKey;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;

public class DHPublicKey
extends DHKey
implements PublicKey {
    private static final ASN1ObjectID b = AlgID.dh.getOID();
    private BigInt c;
    private byte[] d;

    public DHPublicKey() {
    }

    public DHPublicKey(BigInteger bigInteger, DHParams dHParams) {
        this(BigInt.getInstance(bigInteger), dHParams);
    }

    DHPublicKey(BigInt bigInt, DHParams dHParams) {
        super(dHParams);
        this.c = bigInt;
    }

    public DHPublicKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.d == null) {
            ASN1Sequence aSN1Sequence = CryptoUtils.subjectPublicKeyInfo(this);
            this.d = Utils.toBytes(aSN1Sequence);
        }
        return this.d;
    }

    public boolean getAllowExport() {
        return true;
    }

    public String getFormat() {
        return "X.509";
    }

    public void erase() {
        this.a = null;
        this.c = null;
        this.d = null;
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DHPublicKey dHPublicKey = new DHPublicKey();
        try {
            if (this.a != null) {
                dHPublicKey.a = new DHParams(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DH parameters to stream");
        }
        if (this.c != null) {
            dHPublicKey.c = BigInt.getInstance(this.c);
        }
        return dHPublicKey;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        if (!b.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key.");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.a = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        try {
            this.c = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.d = null;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(b, this.a);
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.c);
    }

    public void setParams(DHParams dHParams) {
        FIPS_140_2.assertReadyState();
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P or Q or G in the params");
        }
        this.a = dHParams;
        this.d = null;
    }

    public BigInteger getY() {
        return new BigInteger(this.a().toByteArray());
    }

    BigInt a() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{params = " + this.a + ", y = " + this.c + "}";
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public int length() {
        return this.getEncoded().length;
    }
}

