/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core.math;

import java.math.BigInteger;
import java.util.Random;

public class BigInt
extends Number
implements Comparable {
    private BigInteger a;
    public static final BigInt ZERO = BigInt.valueOf(0L);
    public static final BigInt ONE = BigInt.valueOf(1L);
    public static final BigInt TWO = BigInt.valueOf(2L);

    public static BigInt getInstance(BigInteger bigInteger) {
        return new BigInt(bigInteger);
    }

    public static BigInt getInstance(BigInt bigInt) {
        return new BigInt(bigInt.a());
    }

    private BigInt() {
    }

    private BigInt(BigInteger bigInteger) {
        this.a = bigInteger;
    }

    public BigInt(String string, int n) {
        this.a = new BigInteger(string, n);
    }

    public BigInt(String string) {
        this.a = new BigInteger(string);
    }

    public BigInt(byte[] byArray) {
        this.a = new BigInteger(byArray);
    }

    public BigInt(int n, byte[] byArray) {
        this.a = new BigInteger(n, byArray);
    }

    public BigInt(int n, Random random) {
        this.a = new BigInteger(n, random);
    }

    private BigInteger a() {
        return this.a;
    }

    public void erase() {
    }

    public BigInt(int n, int n2, Random random) {
        this.a = new BigInteger(n, n2, random);
    }

    public static BigInt valueOf(long l) {
        return new BigInt(BigInteger.valueOf(l));
    }

    public int signum() {
        return this.a.signum();
    }

    public int compareTo(Object object) {
        if (!(object instanceof BigInt)) {
            throw new ClassCastException("The Object is not a BigInt");
        }
        return this.compareTo((BigInt)object);
    }

    public int compareTo(BigInt bigInt) {
        return this.a.compareTo(bigInt.a());
    }

    public BigInt min(BigInt bigInt) {
        return new BigInt(this.a.min(bigInt.a()));
    }

    public BigInt max(BigInt bigInt) {
        return new BigInt(this.a.max(bigInt.a()));
    }

    public BigInt add(BigInt bigInt) {
        return new BigInt(this.a.add(bigInt.a()));
    }

    public BigInt subtract(BigInt bigInt) {
        return new BigInt(this.a.subtract(bigInt.a()));
    }

    public BigInt multiply(BigInt bigInt) {
        return new BigInt(this.a.multiply(bigInt.a()));
    }

    public BigInt divide(BigInt bigInt) {
        return new BigInt(this.a.divide(bigInt.a()));
    }

    public BigInt remainder(BigInt bigInt) {
        return new BigInt(this.a.remainder(bigInt.a()));
    }

    public BigInt[] divideAndRemainder(BigInt bigInt) {
        BigInteger[] bigIntegerArray = this.a.divideAndRemainder(bigInt.a());
        BigInt[] bigIntArray = new BigInt[]{new BigInt(bigIntegerArray[0]), new BigInt(bigIntegerArray[1])};
        return bigIntArray;
    }

    public BigInt mod(BigInt bigInt) {
        return new BigInt(this.a.mod(bigInt.a()));
    }

    public BigInt pow(int n) {
        return new BigInt(this.a.pow(n));
    }

    public BigInt modInverse(BigInt bigInt) {
        return new BigInt(this.a.modInverse(bigInt.a()));
    }

    public BigInt modPow(BigInt bigInt, BigInt bigInt2) {
        return new BigInt(this.a.modPow(bigInt.a(), bigInt2.a()));
    }

    public BigInt gcd(BigInt bigInt) {
        return new BigInt(this.a.gcd(bigInt.a()));
    }

    public boolean isProbablePrime(int n) {
        return this.a.isProbablePrime(n);
    }

    public BigInt shiftLeft(int n) {
        return new BigInt(this.a.shiftLeft(n));
    }

    public BigInt shiftRight(int n) {
        return new BigInt(this.a.shiftRight(n));
    }

    public String toString() {
        return this.a.toString();
    }

    public String toString(int n) {
        return this.a.toString(n);
    }

    public int intValue() {
        return this.a.intValue();
    }

    public long longValue() {
        return this.a.longValue();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInt)) {
            return false;
        }
        return this.a.equals(((BigInt)object).a());
    }

    public double doubleValue() {
        return this.a.doubleValue();
    }

    public float floatValue() {
        return this.a.floatValue();
    }

    public BigInt abs() {
        return new BigInt(this.a.abs());
    }

    public BigInt negate() {
        return new BigInt(this.a.negate());
    }

    public int bitLength() {
        return this.a.bitLength();
    }

    public byte[] toByteArray() {
        return this.a.toByteArray();
    }

    public BigInt and(BigInt bigInt) {
        return new BigInt(this.a.and(bigInt.a()));
    }

    public BigInt or(BigInt bigInt) {
        return new BigInt(this.a.or(bigInt.a()));
    }

    public BigInt xor(BigInt bigInt) {
        return new BigInt(this.a.xor(bigInt.a()));
    }

    public BigInt not() {
        return new BigInt(this.a.not());
    }

    public BigInt andNot(BigInt bigInt) {
        return new BigInt(this.a.andNot(bigInt.a()));
    }

    public BigInt clearBit(int n) {
        return new BigInt(this.a.clearBit(n));
    }

    public BigInt setBit(int n) {
        return new BigInt(this.a.setBit(n));
    }

    public boolean testBit(int n) {
        return this.a.testBit(n);
    }

    public BigInt flipBit(int n) {
        return new BigInt(this.a.flipBit(n));
    }

    public int getLowestSetBit() {
        return this.a.getLowestSetBit();
    }

    public int bitCount() {
        return this.a.bitCount();
    }
}

