/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DemoImages
extends Component {
    private static final String[] names = new String[]{"java-logo.gif", "bld.jpg", "boat.png", "box.png", "boxwave.png", "clouds.jpg", "duke.gif", "duke.running.gif", "dukeplug.png", "fight.png", "globe.png", "java_logo.png", "jumptojavastrip.png", "magnify.png", "painting.png", "remove.gif", "snooze.png", "star7.gif", "surfing.png", "thumbsup.png", "tip.png", "duke.png", "print.gif", "loop.gif", "looping.gif", "start.gif", "start2.gif", "stop.gif", "stop2.gif", "clone.gif"};
    private static final Map<String, Image> cache = new ConcurrentHashMap<String, Image>(names.length);

    private DemoImages() {
    }

    public static void newDemoImages() {
        DemoImages demoImages = new DemoImages();
        for (String string : names) {
            cache.put(string, DemoImages.getImage(string, demoImages));
        }
    }

    public static Image getImage(String string, Component component) {
        Image image = null;
        if (cache != null && (image = cache.get(string)) != null) {
            return image;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)component.getClass().getClassLoader();
        URL uRL = uRLClassLoader.findResource("images/" + string);
        image = component.getToolkit().getImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
            if (mediaTracker.isErrorAny()) {
                System.out.println("Error loading image " + string);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DemoImages.class.getName()).log(Level.SEVERE, null, exception);
        }
        return image;
    }
}

