/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java2d.CloningFeature;
import java2d.CustomControlsContext;
import java2d.DemoFonts;
import java2d.DemoGroup;
import java2d.DemoImages;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import java2d.GlobalControls;
import java2d.GlobalPanel;
import java2d.Intro;
import java2d.MemoryMonitor;
import java2d.PerformanceMonitor;
import java2d.RunWindow;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;

public class Java2Demo
extends JPanel
implements ItemListener,
ActionListener,
DemoInstVarsAccessor {
    private final GlobalControls controls;
    private final MemoryMonitor memorymonitor;
    private final PerformanceMonitor performancemonitor;
    private final JTabbedPane tabbedPane;
    private final DemoGroup[] group;
    private JCheckBoxMenuItem verboseCB;
    private JCheckBoxMenuItem ccthreadCB;
    private JCheckBoxMenuItem printCB = new JCheckBoxMenuItem("Default Printer");
    private Color backgroundColor;
    private JCheckBoxMenuItem memoryCB;
    private JCheckBoxMenuItem perfCB;
    private final Intro intro;
    public static final String[][] demos = new String[][]{{"Arcs_Curves", "Arcs", "BezierAnim", "Curves", "Ellipses"}, {"Clipping", "Areas", "ClipAnim", "Intersection", "Text"}, {"Colors", "BullsEye", "ColorConvert", "Rotator3D"}, {"Composite", "ACimages", "ACrules", "FadeAnim"}, {"Fonts", "AttributedStr", "Highlighting", "Outline", "Tree"}, {"Images", "DukeAnim", "ImageOps", "JPEGFlip", "WarpImage"}, {"Lines", "Caps", "Dash", "Joins", "LineAnim"}, {"Mix", "Balls", "BezierScroller", "Stars3D"}, {"Paint", "GradAnim", "Gradient", "Texture", "TextureAnim"}, {"Paths", "Append", "CurveQuadTo", "FillStroke", "WindingRule"}, {"Transforms", "Rotate", "SelectTx", "TransformAnim"}};
    private final boolean demoIsInApplet;
    private JCheckBoxMenuItem controlsCB;
    private JMenuItem runMI;
    private JMenuItem cloneMI;
    private JMenuItem fileMI;
    private JMenuItem backgMI;
    private RunWindow runwindow;
    private RunWindow.RunWindowSettings runWndSetts;
    private CloningFeature cloningfeature;
    private JFrame rf;
    private JFrame cf;

    public Java2Demo(boolean bl, DemoProgress demoProgress, RunWindow.RunWindowSettings runWindowSettings) {
        this.demoIsInApplet = bl;
        this.runWndSetts = runWindowSettings;
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.add((Component)this.createMenuBar(), "North");
        demoProgress.setMaximum(13);
        demoProgress.setText("Loading images");
        DemoImages.newDemoImages();
        demoProgress.setValue(demoProgress.getValue() + 1);
        demoProgress.setText("Loading fonts");
        DemoFonts.newDemoFonts();
        demoProgress.setValue(demoProgress.getValue() + 1);
        demoProgress.setText("Loading Intro");
        this.intro = new Intro();
        demoProgress.setValue(demoProgress.getValue() + 1);
        UIManager.put("Button.margin", new Insets(0, 0, 0, 0));
        this.controls = new GlobalControls(this);
        this.memorymonitor = new MemoryMonitor();
        this.performancemonitor = new PerformanceMonitor();
        GlobalPanel globalPanel = new GlobalPanel(this);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(new Font("serif", 0, 12));
        this.tabbedPane.addTab("", new J2DIcon(this), globalPanel);
        this.tabbedPane.addChangeListener(globalPanel);
        this.group = new DemoGroup[demos.length];
        for (int i = 0; i < demos.length; ++i) {
            demoProgress.setText("Loading demos." + demos[i][0]);
            this.group[i] = new DemoGroup(demos[i][0], this);
            this.tabbedPane.addTab(demos[i][0], null);
            demoProgress.setValue(demoProgress.getValue() + 1);
        }
        this.add((Component)this.tabbedPane, "Center");
    }

    private JMenuBar createMenuBar() {
        JMenu jMenu;
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar jMenuBar = new JMenuBar();
        if (!this.demoIsInApplet) {
            jMenu = jMenuBar.add(new JMenu("File"));
            this.fileMI = jMenu.add(new JMenuItem("Exit"));
            this.fileMI.addActionListener(this);
        }
        jMenu = jMenuBar.add(new JMenu("Options"));
        this.controlsCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Global Controls", true));
        this.controlsCB.addItemListener(this);
        this.memoryCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Memory Monitor", true));
        this.memoryCB.addItemListener(this);
        this.perfCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Performance Monitor", true));
        this.perfCB.addItemListener(this);
        jMenu.add(new JSeparator());
        this.ccthreadCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Custom Controls Thread"));
        this.ccthreadCB.addItemListener(this);
        this.printCB = (JCheckBoxMenuItem)jMenu.add(this.printCB);
        this.verboseCB = (JCheckBoxMenuItem)jMenu.add(new JCheckBoxMenuItem("Verbose"));
        jMenu.add(new JSeparator());
        this.backgMI = jMenu.add(new JMenuItem("Background Color"));
        this.backgMI.addActionListener(this);
        this.runMI = jMenu.add(new JMenuItem("Run Window"));
        this.runMI.addActionListener(this);
        this.cloneMI = jMenu.add(new JMenuItem("Cloning Feature"));
        this.cloneMI.addActionListener(this);
        return jMenuBar;
    }

    public void createRunWindow() {
        if (this.rf != null) {
            this.rf.toFront();
            return;
        }
        this.runwindow = new RunWindow(this, this.runWndSetts);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Java2Demo.this.runwindow.stop();
                Java2Demo.this.rf.dispose();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Java2Demo.this.rf = null;
            }
        };
        this.rf = new JFrame("Run");
        this.rf.addWindowListener(windowAdapter);
        this.rf.getContentPane().add("Center", this.runwindow);
        this.rf.pack();
        if (!this.demoIsInApplet) {
            this.rf.setSize(new Dimension(200, 125));
        } else {
            this.rf.setSize(new Dimension(200, 150));
        }
        this.rf.setVisible(true);
    }

    public void startRunWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Java2Demo.this.runwindow.doRunAction();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.fileMI)) {
            System.exit(0);
        } else if (actionEvent.getSource().equals(this.runMI)) {
            this.createRunWindow();
        } else if (actionEvent.getSource().equals(this.cloneMI)) {
            if (this.cloningfeature == null) {
                this.cloningfeature = new CloningFeature(this);
                WindowAdapter windowAdapter = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        Java2Demo.this.cloningfeature.stop();
                        Java2Demo.this.cf.dispose();
                    }

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        Java2Demo.this.cloningfeature = null;
                    }
                };
                this.cf = new JFrame("Cloning Demo");
                this.cf.addWindowListener(windowAdapter);
                this.cf.getContentPane().add("Center", this.cloningfeature);
                this.cf.pack();
                this.cf.setSize(new Dimension(320, 330));
                this.cf.setVisible(true);
            } else {
                this.cf.toFront();
            }
        } else if (actionEvent.getSource().equals(this.backgMI)) {
            this.backgroundColor = JColorChooser.showDialog(this, "Background Color", Color.white);
            for (int i = 1; i < this.tabbedPane.getTabCount(); ++i) {
                JPanel jPanel = this.group[i - 1].getPanel();
                for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                    DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(j);
                    if (demoPanel.surface == null) continue;
                    demoPanel.surface.setBackground(this.backgroundColor);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.controlsCB)) {
            boolean bl = !this.controls.isVisible();
            this.controls.setVisible(bl);
            for (Component component : this.controls.texturechooser.getComponents()) {
                component.setVisible(bl);
            }
        } else if (itemEvent.getSource().equals(this.memoryCB)) {
            if (this.memorymonitor.isVisible()) {
                this.memorymonitor.setVisible(false);
                this.memorymonitor.surf.setVisible(false);
                this.memorymonitor.surf.stop();
            } else {
                this.memorymonitor.setVisible(true);
                this.memorymonitor.surf.setVisible(true);
                this.memorymonitor.surf.start();
            }
        } else if (itemEvent.getSource().equals(this.perfCB)) {
            if (this.performancemonitor.isVisible()) {
                this.performancemonitor.setVisible(false);
                this.performancemonitor.surf.setVisible(false);
                this.performancemonitor.surf.stop();
            } else {
                this.performancemonitor.setVisible(true);
                this.performancemonitor.surf.setVisible(true);
                this.performancemonitor.surf.start();
            }
        } else if (itemEvent.getSource().equals(this.ccthreadCB)) {
            CustomControlsContext.State state;
            CustomControlsContext.State state2 = state = this.ccthreadCB.isSelected() ? CustomControlsContext.State.START : CustomControlsContext.State.STOP;
            if (this.tabbedPane.getSelectedIndex() != 0) {
                JPanel jPanel = this.group[this.tabbedPane.getSelectedIndex() - 1].getPanel();
                for (int i = 0; i < jPanel.getComponentCount(); ++i) {
                    DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(i);
                    if (demoPanel.ccc == null) continue;
                    demoPanel.ccc.handleThread(state);
                }
            }
        }
        this.revalidate();
    }

    public void start() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.intro.start();
        } else {
            this.group[this.tabbedPane.getSelectedIndex() - 1].setup(false);
            if (this.memorymonitor.surf.thread == null && this.memoryCB.getState()) {
                this.memorymonitor.surf.start();
            }
            if (this.performancemonitor.surf.thread == null && this.perfCB.getState()) {
                this.performancemonitor.surf.start();
            }
        }
    }

    public void stop() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            this.intro.stop();
        } else {
            this.memorymonitor.surf.stop();
            this.performancemonitor.surf.stop();
            int n = this.tabbedPane.getSelectedIndex() - 1;
            this.group[n].shutDown(this.group[n].getPanel());
        }
    }

    @Override
    public GlobalControls getControls() {
        return this.controls;
    }

    @Override
    public MemoryMonitor getMemoryMonitor() {
        return this.memorymonitor;
    }

    @Override
    public PerformanceMonitor getPerformanceMonitor() {
        return this.performancemonitor;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    @Override
    public DemoGroup[] getGroup() {
        return this.group;
    }

    @Override
    public void setGroupColumns(int n) {
        for (DemoGroup demoGroup : this.group) {
            if (demoGroup == null) continue;
            demoGroup.columns = n;
        }
    }

    @Override
    public JCheckBoxMenuItem getVerboseCB() {
        return this.verboseCB;
    }

    @Override
    public JCheckBoxMenuItem getCcthreadCB() {
        return this.ccthreadCB;
    }

    @Override
    public JCheckBoxMenuItem getPrintCB() {
        return this.printCB;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public JCheckBoxMenuItem getMemoryCB() {
        return this.memoryCB;
    }

    @Override
    public JCheckBoxMenuItem getPerfCB() {
        return this.perfCB;
    }

    @Override
    public Intro getIntro() {
        return this.intro;
    }

    static void addToGridBag(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        jPanel.add(component);
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private static void initFrame(String[] stringArray, RunWindow.RunWindowSettings runWindowSettings) {
        Java2Demo java2Demo;
        final Java2Demo[] java2DemoArray = new Java2Demo[1];
        JFrame jFrame = new JFrame("Java 2D(TM) Demo");
        jFrame.getAccessibleContext().setAccessibleDescription("A sample application to demonstrate Java2D features");
        int n = 400;
        int n2 = 200;
        jFrame.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                Java2Demo java2Demo = java2DemoArray[0];
                if (java2Demo != null) {
                    java2Demo.start();
                }
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                Java2Demo java2Demo = java2DemoArray[0];
                if (java2Demo != null) {
                    java2Demo.stop();
                }
            }
        });
        JOptionPane.setRootFrame(jFrame);
        JPanel jPanel = new JPanel(){

            @Override
            public Insets getInsets() {
                return new Insets(40, 30, 20, 30);
            }
        };
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jFrame.getContentPane().add((Component)jPanel, "Center");
        Dimension dimension2 = new Dimension(400, 20);
        JLabel jLabel = new JLabel("Loading, please wait...");
        jLabel.setAlignmentX(0.5f);
        jLabel.setMaximumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(1, 20)));
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        jLabel.setLabelFor(jProgressBar);
        jProgressBar.setAlignmentX(0.5f);
        jProgressBar.setMinimum(0);
        jProgressBar.setValue(0);
        jProgressBar.getAccessibleContext().setAccessibleName("Java2D loading progress");
        jPanel.add(jProgressBar);
        DemoProgress demoProgress = new DemoProgress(jLabel, jProgressBar);
        jFrame.setVisible(true);
        java2DemoArray[0] = java2Demo = new Java2Demo(false, demoProgress, runWindowSettings);
        jFrame.getContentPane().removeAll();
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)java2Demo, "Center");
        n = 730;
        n2 = 570;
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setSize(n, n2);
        jFrame.setCursor(Cursor.getPredefinedCursor(0));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = string.substring(string.indexOf(61) + 1);
            if (string.startsWith("-runs=")) {
                runWindowSettings.setNumRuns(Integer.parseInt(string2));
                runWindowSettings.setExit(true);
                java2Demo.createRunWindow();
                continue;
            }
            if (string.startsWith("-screen=")) {
                java2Demo.getControls().screenCombo.setSelectedIndex(Integer.parseInt(string2));
                continue;
            }
            if (string.startsWith("-antialias=")) {
                java2Demo.controls.aliasCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-rendering=")) {
                java2Demo.controls.renderCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-texture=")) {
                java2Demo.controls.textureCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-composite=")) {
                java2Demo.controls.compositeCB.setSelected(string2.endsWith("true"));
                continue;
            }
            if (string.startsWith("-verbose")) {
                java2Demo.verboseCB.setSelected(true);
                continue;
            }
            if (string.startsWith("-print")) {
                java2Demo.printCB.setSelected(true);
                runWindowSettings.setPrintCBIsSelected(true);
                continue;
            }
            if (string.startsWith("-columns=")) {
                java2Demo.setGroupColumns(Integer.parseInt(string2));
                continue;
            }
            if (string.startsWith("-buffers=")) {
                runWindowSettings.setBuffersFlag(true);
                int n3 = string.indexOf(61) + 1;
                int n4 = string.indexOf(44);
                String string3 = string.substring(n3, n4);
                runWindowSettings.setBufBeg(Integer.parseInt(string3));
                string3 = string.substring(n4 + 1, string.length());
                runWindowSettings.setBufEnd(Integer.parseInt(string3));
                continue;
            }
            if (string.startsWith("-ccthread")) {
                java2Demo.ccthreadCB.setSelected(true);
                continue;
            }
            if (string.startsWith("-zoom")) {
                runWindowSettings.setZoomCBSelected(true);
                continue;
            }
            if (!string.startsWith("-maxscreen")) continue;
            jFrame.setLocation(0, 0);
            jFrame.setSize(dimension.width, dimension.height);
        }
        jFrame.validate();
        jFrame.repaint();
        jFrame.getFocusTraversalPolicy().getDefaultComponent(jFrame).requestFocus();
        java2Demo.start();
        if (runWindowSettings.getExit()) {
            java2Demo.startRunWindow();
        }
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunWindow.RunWindowSettings runWindowSettings = new RunWindow.RunWindowSettings();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string;
                    if (stringArray[i].startsWith("-h") || stringArray[i].startsWith("-help")) {
                        string = "\njava -jar Java2Demo.jar -runs=5 -delay=5 -screen=5 -antialias=true -rendering=true -texture=true -composite=true -verbose -print -columns=3 -buffers=5,10 -ccthread -zoom -maxscreen \n";
                        System.out.println(string);
                        string = "    -runs=5       Number of runs to execute\n    -delay=5      Sleep amount between tabs\n    -antialias=   true or false for antialiasing\n    -rendering=   true or false for quality or speed\n    -texture=     true or false for texturing\n    -composite=   true or false for compositing\n    -verbose      output Surface graphic states \n    -print        during run print the Surface, use the Default Printer\n    -columns=3    # of columns to use in clone layout \n    -screen=3     demos all use this screen type \n    -buffers=5,10 during run - clone to see screens five through ten\n    -ccthread     Invoke the Custom Controls Thread \n    -zoom         mouseClick on surface for zoom in  \n    -maxscreen    take up the entire monitor screen \n";
                        System.out.println(string);
                        string = "Examples : \n    Print all of the demos : \n        java -jar Java2Demo.jar -runs=1 -delay=60 -print \n    Run zoomed in with custom control thread \n        java -jar Java2Demo.jar -runs=10 -zoom -ccthread\n";
                        System.out.println(string);
                        System.exit(0);
                        continue;
                    }
                    if (!stringArray[i].startsWith("-delay=")) continue;
                    string = stringArray[i].substring(stringArray[i].indexOf(61) + 1);
                    runWindowSettings.setDelay(Integer.parseInt(string));
                }
                Java2Demo.initFrame(stringArray, runWindowSettings);
            }
        });
    }

    public static class DemoProgress {
        private final JLabel progressLabel;
        private final JProgressBar progressBar;

        public DemoProgress(JLabel jLabel, JProgressBar jProgressBar) {
            if (jLabel == null) {
                throw new IllegalArgumentException("null was transferred as 'progressLabel' argument");
            }
            if (jProgressBar == null) {
                throw new IllegalArgumentException("null was transferred as 'progressBar' argument");
            }
            this.progressLabel = jLabel;
            this.progressBar = jProgressBar;
        }

        public void setText(String string) {
            this.progressLabel.setText(string);
        }

        public void setMaximum(int n) {
            this.progressBar.setMaximum(n);
        }

        public int getValue() {
            return this.progressBar.getValue();
        }

        public void setValue(int n) {
            this.progressBar.setValue(n);
        }
    }

    static class J2DIcon
    implements Icon {
        private final DemoInstVarsAccessor demoInstVars;
        private static final Color myBlue = new Color(94, 105, 176);
        private static final Color myBlack = new Color(20, 20, 20);
        private static final Font font = new Font("serif", 1, 12);
        private FontRenderContext frc = new FontRenderContext(null, true, true);
        private TextLayout tl = new TextLayout("Java2D", font, this.frc);

        public J2DIcon(DemoInstVarsAccessor demoInstVarsAccessor) {
            this.demoInstVars = demoInstVarsAccessor;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(font);
            if (this.demoInstVars.getTabbedPane().getSelectedIndex() == 0) {
                graphics2D.setColor(myBlue);
            } else {
                graphics2D.setColor(myBlack);
            }
            this.tl.draw(graphics2D, n, n2 + 15);
        }

        @Override
        public int getIconWidth() {
            return 40;
        }

        @Override
        public int getIconHeight() {
            return 22;
        }
    }
}

