/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java2d.DemoPanel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PerformanceMonitor
extends JPanel {
    Surface surf;

    public PerformanceMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Performance"));
        this.surf = new Surface();
        this.add(this.surf);
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        private BufferedImage bimg;
        private Font font = new Font("Times New Roman", 0, 12);
        private JPanel panel;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n = this.getFontMetrics(this.font).getHeight();
            return new Dimension(135, 2 + n * 4);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.bimg != null) {
                graphics.drawImage(this.bimg, 0, 0, this);
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("PerformanceMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.setSurfaceState();
            this.notify();
        }

        public void setSurfaceState() {
            if (this.panel != null) {
                for (Component component : this.panel.getComponents()) {
                    if (((DemoPanel)component).surface == null) continue;
                    ((DemoPanel)component).surface.setMonitor(this.thread != null);
                }
            }
        }

        public void setPanel(JPanel jPanel) {
            this.panel = jPanel;
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            Dimension dimension = new Dimension(0, 0);
            Graphics2D graphics2D = null;
            FontMetrics fontMetrics = null;
            int n = 0;
            int n2 = 0;
            while (this.thread == thread && this.isShowing()) {
                if (this.getWidth() != dimension.width || this.getHeight() != dimension.height) {
                    dimension = this.getSize();
                    this.bimg = (BufferedImage)this.createImage(dimension.width, dimension.height);
                    graphics2D = this.bimg.createGraphics();
                    graphics2D.setFont(this.font);
                    fontMetrics = graphics2D.getFontMetrics();
                    n = fontMetrics.getAscent();
                    n2 = fontMetrics.getDescent();
                    this.setSurfaceState();
                }
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, dimension.width, dimension.height);
                if (this.panel == null) continue;
                graphics2D.setColor(Color.green);
                int n3 = 1;
                for (Component component : this.panel.getComponents()) {
                    String string;
                    if (((DemoPanel)component).surface == null || (string = ((DemoPanel)component).surface.perfStr) == null) continue;
                    graphics2D.drawString(string, 4, (n3 += n) + 1);
                    n3 += n2;
                }
                this.repaint();
                try {
                    Thread.sleep(999L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.thread = null;
        }
    }
}

