/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Fonts;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.ImageGraphicAttribute;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.ShapeGraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java2d.Surface;

public class AttributedStr
extends Surface {
    static final Color black = new Color(20, 20, 20);
    static final Color blue = new Color(94, 105, 176);
    static final Color yellow = new Color(255, 255, 140);
    static final Color red = new Color(149, 43, 42);
    static final Color white = new Color(240, 240, 255);
    static final String text = "  A quick brown  fox  jumped  over the lazy duke  ";
    static final AttributedString as = new AttributedString("  A quick brown  fox  jumped  over the lazy duke  ");
    static AttributedCharacterIterator aci;

    public AttributedStr() {
        this.setBackground(Color.white);
        Font font = this.getFont("A.ttf");
        font = font != null ? font.deriveFont(0, 70.0f) : new Font("serif", 0, 50);
        int n = text.indexOf("A") + 1;
        as.addAttribute(TextAttribute.FONT, font, 0, n);
        as.addAttribute(TextAttribute.FOREGROUND, white, 0, n);
        font = new Font("dialog", 0, 40);
        int n2 = this.getFontMetrics(font).getHeight();
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.getImage("snooze.png"), 0, 0, n2, n2, null);
        ImageGraphicAttribute imageGraphicAttribute = new ImageGraphicAttribute(bufferedImage, -1);
        as.addAttribute(TextAttribute.CHAR_REPLACEMENT, imageGraphicAttribute, text.length() - 1, text.length());
        aci = as.getIterator();
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        float f = 5.0f;
        float f2 = 0.0f;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(aci, fontRenderContext);
        graphics2D.setPaint(new GradientPaint(0.0f, n2, blue, n, 0.0f, black));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(white);
        String string = "AttributedString LineBreakMeasurer";
        Font font = new Font("serif", 0, 12);
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        textLayout.draw(graphics2D, 5.0f, f2 += (float)textLayout.getBounds().getHeight());
        graphics2D.setColor(yellow);
        while (f2 < (float)n2 - textLayout.getAscent()) {
            lineBreakMeasurer.setPosition(0);
            while (lineBreakMeasurer.getPosition() < text.length()) {
                textLayout = lineBreakMeasurer.nextLayout((float)n - f);
                if (!textLayout.isLeftToRight()) {
                    f = (float)n - textLayout.getAdvance();
                }
                textLayout.draw(graphics2D, f, f2 += textLayout.getAscent());
                f2 += textLayout.getDescent() + textLayout.getLeading();
            }
        }
    }

    public static void main(String[] stringArray) {
        AttributedStr.createDemoFrame(new AttributedStr());
    }

    static {
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 25.0, 12.0, 12.0);
        ShapeGraphicAttribute shapeGraphicAttribute = new ShapeGraphicAttribute(double_, -1, false);
        as.addAttribute(TextAttribute.CHAR_REPLACEMENT, shapeGraphicAttribute, 0, 1);
        Font font = new Font("sanserif", 3, 20);
        int n = text.indexOf("quick");
        as.addAttribute(TextAttribute.FONT, font, n, n + 5);
        n = text.indexOf("brown");
        font = new Font("serif", 1, 20);
        as.addAttribute(TextAttribute.FONT, font, n, n + 5);
        as.addAttribute(TextAttribute.FOREGROUND, red, n, n + 5);
        n = text.indexOf("fox");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(10.0));
        Font font2 = new Font("serif", 1, 30).deriveFont(affineTransform);
        as.addAttribute(TextAttribute.FONT, font2, n, n + 1);
        as.addAttribute(TextAttribute.FONT, font2, n + 1, n + 2);
        as.addAttribute(TextAttribute.FONT, font2, n + 2, n + 3);
        affineTransform.setToRotation(Math.toRadians(-4.0));
        font2 = font.deriveFont(affineTransform);
        n = text.indexOf("jumped");
        as.addAttribute(TextAttribute.FONT, font2, n, n + 6);
        font = new Font("serif", 3, 30);
        n = text.indexOf("over");
        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, n, n + 4);
        as.addAttribute(TextAttribute.FOREGROUND, white, n, n + 4);
        as.addAttribute(TextAttribute.FONT, font, n, text.length());
        font = new Font("dialog", 0, 20);
        int n2 = text.indexOf("duke");
        as.addAttribute(TextAttribute.FONT, font, n, n2 - 1);
        BufferedImage bufferedImage = new BufferedImage(4, 4, 2);
        bufferedImage.setRGB(0, 0, -1);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, 4, 4));
        as.addAttribute(TextAttribute.BACKGROUND, texturePaint, n2, n2 + 4);
        font = new Font("serif", 1, 40);
        as.addAttribute(TextAttribute.FONT, font, n2, n2 + 4);
    }
}

