/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.JComboBox;

public class GradAnim
extends AnimatingControlsSurface {
    private static final int BASIC_GRADIENT = 0;
    private static final int LINEAR_GRADIENT = 1;
    private static final int RADIAL_GRADIENT = 2;
    private static final int FOCUS_GRADIENT = 3;
    private static final int MAX_HUE = 1536;
    private animval x1;
    private animval y1;
    private animval x2;
    private animval y2;
    private int hue = (int)(Math.random() * 1536.0);
    private int gradientType;

    public GradAnim() {
        this.setBackground(Color.white);
        this.setControls(new Component[]{new DemoControls(this)});
        this.x1 = new animval(0, 300, 2, 10);
        this.y1 = new animval(0, 300, 2, 10);
        this.x2 = new animval(0, 300, 2, 10);
        this.y2 = new animval(0, 300, 2, 10);
        this.gradientType = 0;
    }

    @Override
    public void reset(int n, int n2) {
        this.x1.newlimits(0, n);
        this.y1.newlimits(0, n2);
        this.x2.newlimits(0, n);
        this.y2.newlimits(0, n2);
    }

    @Override
    public void step(int n, int n2) {
        this.x1.anim();
        this.y1.anim();
        this.x2.anim();
        this.y2.anim();
        this.hue = (this.hue + (int)(Math.random() * 10.0)) % 1536;
    }

    public static Color getColor(int n) {
        int n2 = n / 256 % 6;
        int n3 = n % 256 * 2;
        int n4 = n3 < 256 ? 255 : 511 - n3;
        int n5 = n3 < 256 ? n3 : 255;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        switch (n2) {
            case 0: {
                n8 = 255;
                break;
            }
            case 1: {
                n8 = n4;
                n7 = n5;
                break;
            }
            case 2: {
                n7 = 255;
                break;
            }
            case 3: {
                n7 = n4;
                n6 = n5;
                break;
            }
            case 4: {
                n6 = 255;
                break;
            }
            case 5: {
                n6 = n4;
                n8 = n5;
            }
        }
        return new Color(n8, n7, n6);
    }

    @Override
    public void render(int n, int n2, Graphics2D graphics2D) {
        Paint paint;
        float f = this.x1.getFlt();
        float f2 = this.y1.getFlt();
        float f3 = this.x2.getFlt();
        float f4 = this.y2.getFlt();
        if (f == f3 && f2 == f4) {
            f3 += 1.0f;
            f4 += 1.0f;
        }
        Color color = GradAnim.getColor(this.hue);
        Color color2 = GradAnim.getColor(this.hue + 768);
        switch (this.gradientType) {
            default: {
                paint = new GradientPaint(f, f2, color, f3, f4, color2, true);
                break;
            }
            case 1: {
                float[] fArray = new float[]{0.0f, 0.2f, 1.0f};
                Color color3 = GradAnim.getColor(this.hue + 512);
                Color[] colorArray = new Color[]{color, color2, color3};
                paint = new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray, MultipleGradientPaint.CycleMethod.REFLECT);
                break;
            }
            case 2: {
                float[] fArray = new float[]{0.0f, 0.2f, 0.8f, 1.0f};
                Color color4 = GradAnim.getColor(this.hue + 512);
                Color color5 = GradAnim.getColor(this.hue + 1024);
                Color[] colorArray = new Color[]{color, color2, color4, color5};
                float f5 = (float)Point2D.distance(f, f2, f3, f4);
                paint = new RadialGradientPaint(f, f2, f5, fArray, colorArray, MultipleGradientPaint.CycleMethod.REFLECT);
                break;
            }
            case 3: {
                float[] fArray = new float[]{0.0f, 0.2f, 0.8f, 1.0f};
                Color color6 = GradAnim.getColor(this.hue + 1024);
                Color color7 = GradAnim.getColor(this.hue + 512);
                Color[] colorArray = new Color[]{color, color2, color6, color7};
                float f6 = (float)Point2D.distance(f, f2, f3, f4);
                float f7 = Math.max(n, n2);
                f6 = f7 * (f6 / f7 * 0.9f + 0.1f);
                paint = new RadialGradientPaint(f3, f4, f6, f, f2, fArray, colorArray, MultipleGradientPaint.CycleMethod.REPEAT);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(Color.yellow);
        graphics2D.drawLine(this.x1.getInt(), this.y1.getInt(), this.x2.getInt(), this.y2.getInt());
    }

    public static void main(String[] stringArray) {
        GradAnim.createDemoFrame(new GradAnim());
    }

    class DemoControls
    extends CustomControls
    implements ActionListener {
        GradAnim demo;
        JComboBox combo;

        public DemoControls(GradAnim gradAnim2) {
            super(gradAnim2.name);
            this.demo = gradAnim2;
            this.combo = new JComboBox();
            this.combo.addActionListener(this);
            this.combo.addItem("2-color GradientPaint");
            this.combo.addItem("3-color LinearGradientPaint");
            this.combo.addItem("4-color RadialGradientPaint");
            this.combo.addItem("4-color RadialGradientPaint with focus");
            this.combo.setSelectedIndex(0);
            this.add(this.combo);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.combo.getSelectedIndex();
            if (n >= 0) {
                this.demo.gradientType = n;
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 41);
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (this.thread == thread) {
                for (int i = 0; i < this.combo.getItemCount(); ++i) {
                    this.combo.setSelectedIndex(i);
                    try {
                        Thread.sleep(4444L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }

    public final class animval {
        float curval;
        float lowval;
        float highval;
        float currate;
        float lowrate;
        float highrate;

        public animval(int n, int n2, int n3, int n4) {
            this.lowval = n;
            this.highval = n2;
            this.lowrate = n3;
            this.highrate = n4;
            this.curval = this.randval(n, n2);
            this.currate = this.randval(n3, n4);
        }

        public float randval(float f, float f2) {
            return (float)((double)f + Math.random() * (double)(f2 - f));
        }

        public float getFlt() {
            return this.curval;
        }

        public int getInt() {
            return (int)this.curval;
        }

        public void anim() {
            this.curval += this.currate;
            this.clip();
        }

        public void clip() {
            if (this.curval > this.highval) {
                this.curval = this.highval - (this.curval - this.highval);
                if (this.curval < this.lowval) {
                    this.curval = this.highval;
                }
                this.currate = -this.randval(this.lowrate, this.highrate);
            } else if (this.curval < this.lowval) {
                this.curval = this.lowval + (this.lowval - this.curval);
                if (this.curval > this.highval) {
                    this.curval = this.lowval;
                }
                this.currate = this.randval(this.lowrate, this.highrate);
            }
        }

        public void newlimits(int n, int n2) {
            this.lowval = n;
            this.highval = n2;
            this.clip();
        }
    }
}

