/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.patch.info;

import com.oracle.cie.patch.info.SUPatchSystemException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Properties;
import oracle.sysman.core.agent.PatchInfoProvider;
import oracle.sysman.core.agent.PatchInfoProviderFactory;
import oracle.sysman.core.agent.exceptions.PatchSystemException;

public class SUPatchInfoProviderFactory
implements PatchInfoProviderFactory {
    private static final String PATCH_SYSTEM_USER_DIR = "com.bea.plateng.patch.PatchSystem.user.dir";
    private static final String PROVIDER_IMPL_CLASS = "com.oracle.cie.patch.info.SUPatchInfoProviderImpl";
    private static final String PATCH_RECOMMENDATIONS_JAR = "com.oracle.cie.patch.recommendations.jar";
    private static final String BSU_PATCH_CLIENT_JAR = "utils/bsu/patch-client.jar";
    private static final String PRODUCT_PROPERTIES = ".product.properties";
    private static final String BEAHOME = "BEAHOME";

    public PatchInfoProvider createPatchInfoProvider(String installationDir) throws PatchSystemException {
        if (installationDir == null || installationDir.trim().length() == 0) {
            throw new SUPatchSystemException("WLS directory is not provided.");
        }
        File _wlsHome = new File(installationDir);
        if (_wlsHome.isDirectory()) {
            try {
                File jarFile = this.getLocationOfJar();
                String beaHome = this.getBEAHome(_wlsHome);
                System.setProperty(PATCH_SYSTEM_USER_DIR, new File(beaHome, "utils/bsu").toString());
                File _patchClientJar = new File(beaHome, BSU_PATCH_CLIENT_JAR);
                File _patchRecommJar = new File(jarFile.getParent(), PATCH_RECOMMENDATIONS_JAR);
                if (!_patchRecommJar.isFile()) {
                    throw new Exception("Unable to locate com.oracle.cie.patch.recommendations.jar");
                }
                if (!_patchClientJar.isFile()) {
                    throw new Exception("Unable to locate patch-client.jar");
                }
                URL[] urls = new URL[]{};
                InternalClassLoader internalClassLoader = new InternalClassLoader(urls);
                internalClassLoader.addFileToClasspath(_patchRecommJar.toString());
                internalClassLoader.addFileToClasspath(_patchClientJar.toString());
                Class<?> clazz = internalClassLoader.loadClass(PROVIDER_IMPL_CLASS);
                Constructor<?> constructor = clazz.getConstructor(File.class, String.class);
                PatchInfoProvider patchInfoProvider = (PatchInfoProvider)constructor.newInstance(_wlsHome, beaHome);
                return patchInfoProvider;
            }
            catch (Throwable e) {
                throw new SUPatchSystemException(e.getMessage(), e);
            }
        }
        throw new SUPatchSystemException("provided Installation directory is not found");
    }

    private String getBEAHome(File _wlsHome) throws IOException, SUPatchSystemException {
        String beaHome;
        try {
            File prodProps = new File(_wlsHome, PRODUCT_PROPERTIES);
            if (!prodProps.exists()) {
                prodProps = new File(_wlsHome, "common" + File.separatorChar + "lib" + File.separatorChar + "platform.properties");
            }
            beaHome = this.getProperties(new FileInputStream(prodProps)).getProperty(BEAHOME);
        }
        catch (FileNotFoundException e) {
            throw new SUPatchSystemException("The directory [" + _wlsHome + "] is not a product directory supported by SmartUpdate", e);
        }
        return beaHome;
    }

    private File getLocationOfJar() throws MalformedURLException, UnsupportedEncodingException {
        String className = SUPatchInfoProviderFactory.class.getName().replace('.', '/') + ".class";
        URL classResource = SUPatchInfoProviderFactory.class.getClassLoader().getResource(className);
        String fileComponent = classResource.getFile();
        if (classResource.getProtocol().equals("jar")) {
            int classSeparatorIndex = fileComponent.lastIndexOf("!");
            if (classSeparatorIndex != -1) {
                fileComponent = fileComponent.substring(0, classSeparatorIndex);
            }
            URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
            File jarFile = new File(u.getFile());
            return jarFile;
        }
        return null;
    }

    public Properties getProperties(InputStream is) throws IOException {
        if (is != null) {
            Properties props = new Properties();
            props.load(is);
            return props;
        }
        throw new IOException("Properties InputStream was null.");
    }

    class InternalClassLoader
    extends URLClassLoader {
        public InternalClassLoader(URL[] urls) {
            super(urls);
        }

        public void addFileToClasspath(String jarName) throws MalformedURLException, ClassNotFoundException {
            File filePath = new File(jarName);
            URI uriPath = filePath.toURI();
            URL urlPath = uriPath.toURL();
            this.addURL(urlPath);
        }
    }
}

