/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.jce.cert.X500Name;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class X509Impl
extends X509Certificate
implements ASN1Object {
    private static final String keyUsageOID = "2.5.29.15";
    private static final String basicConstraintsOID = "2.5.29.19";
    private ASN1Sequence tbsCert;
    private ASN1Sequence contents;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private int version;
    private BigInteger serialNo;
    private X500Name subject;
    private boolean[] subjectID;
    private PublicKey pubKey;
    private X500Name issuer;
    private boolean[] issuerID;
    private Date notBeforeDate;
    private Date notAfterDate;
    private Hashtable extensions;
    private Set criticalOIDs;
    private Set nonCriticalOIDs;
    private boolean unsupportedCriticalExtension;
    private int basicConstraints = -1;
    private boolean[] keyUsage;

    public X509Impl() {
    }

    public X509Impl(InputStream is) throws IOException {
        this.input(is);
    }

    public void input(InputStream is) throws IOException {
        int i;
        int size;
        ASN1BitString bs;
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.tbsCert = new ASN1Sequence((InputStream)sis);
        this.sigAlgID = new AlgorithmIdentifier((InputStream)sis);
        this.sigBytes = ASN1BitString.inputValue((InputStream)sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.tbsCert));
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ver = new ASN1ConstructedInputStream((InputStream)tbs);
            BigInteger v = ASN1Integer.inputValue((InputStream)ver);
            this.version = v.intValue() + 1;
            ver.terminate();
        } else {
            this.version = 1;
        }
        this.serialNo = ASN1Integer.inputValue((InputStream)tbs);
        AlgorithmIdentifier tbsSigAlgID = new AlgorithmIdentifier((InputStream)tbs);
        if (!tbsSigAlgID.getOID().equals((Object)this.sigAlgID.getOID())) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name((InputStream)tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        ASN1SequenceInputStream val = new ASN1SequenceInputStream((InputStream)tbs);
        this.notBeforeDate = ASN1Date.inputValue((InputStream)val);
        this.notAfterDate = ASN1Date.inputValue((InputStream)val);
        val.terminate();
        this.subject = new X500Name((InputStream)tbs);
        this.pubKey = PhaosJCEKeyTranslator.phaosPublicKeyToJCE(CryptoUtils.inputSPKI((InputStream)tbs));
        if (tbs.getCurrentTag() == 1) {
            tbs.setCurrentTag(3);
            bs = new ASN1BitString((InputStream)tbs);
            this.issuerID = new boolean[bs.bitLength()];
            size = bs.bitLength();
            for (i = 0; i < size; ++i) {
                this.issuerID[i] = bs.testBit(i);
            }
        }
        if (tbs.getCurrentTag() == 2) {
            tbs.setCurrentTag(3);
            bs = new ASN1BitString((InputStream)tbs);
            this.subjectID = new boolean[bs.bitLength()];
            size = bs.bitLength();
            for (i = 0; i < size; ++i) {
                this.subjectID[i] = bs.testBit(i);
            }
        }
        this.unsupportedCriticalExtension = false;
        if (tbs.getCurrentTag() == 3) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream((InputStream)tbs);
            ASN1SequenceInputStream extensionsStream = new ASN1SequenceInputStream((InputStream)ext);
            this.extensions = new Hashtable();
            this.criticalOIDs = new HashSet();
            this.nonCriticalOIDs = new HashSet();
            while (extensionsStream.hasMoreData()) {
                ASN1SequenceInputStream extension = new ASN1SequenceInputStream((InputStream)extensionsStream);
                String type = new ASN1ObjectID((InputStream)extension).toStringCompact();
                boolean critical = false;
                if (extension.getCurrentTag() == 1) {
                    critical = ASN1Boolean.inputValue((InputStream)extension);
                }
                if (critical) {
                    this.criticalOIDs.add(type);
                    if (!type.equals(keyUsageOID) && !type.equals(basicConstraintsOID)) {
                        this.unsupportedCriticalExtension = true;
                    }
                } else {
                    this.nonCriticalOIDs.add(type);
                }
                this.extensions.put(type, ASN1OctetString.inputValue((InputStream)extension));
                extension.terminate();
            }
            extensionsStream.terminate();
            ext.terminate();
        } else {
            this.extensions = null;
            this.criticalOIDs = null;
            this.nonCriticalOIDs = null;
        }
        this.keyUsage = null;
        this.basicConstraints = 0;
        tbs.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.contents.output(os);
    }

    public int length() {
        return this.contents.length();
    }

    public byte[] getEncoded() {
        return Utils.toBytes((Streamable)this.contents);
    }

    public byte[] getTBSCertificate() {
        return Utils.toBytes((Streamable)this.tbsCert);
    }

    public byte[] getSignature() {
        return this.sigBytes;
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sigObj = sigProvider != null ? Signature.getInstance(this.getSigAlgName(), sigProvider) : Signature.getInstance(this.getSigAlgName());
        sigObj.initVerify(key);
        sigObj.update(this.getTBSCertificate());
        sigObj.verify(this.getSignature());
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, (String)null);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBeforeDate)) {
            throw new CertificateNotYetValidException("Certificate not yet valid");
        }
        if (date.after(this.notAfterDate)) {
            throw new CertificateExpiredException("Certificate expired");
        }
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectID;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public Date getNotBefore() {
        return this.notBeforeDate;
    }

    public Date getNotAfter() {
        return this.notAfterDate;
    }

    public Principal getIssuerDN() {
        return this.issuer;
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerID;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public String getSigAlgOID() {
        return this.sigAlgID.getOID().toStringCompact();
    }

    public String getSigAlgName() {
        ASN1ObjectID oid = this.sigAlgID.getOID();
        if (oid.equals((Object)AlgID.md5WithRSAEncryption.getOID())) {
            return "MD5withRSA";
        }
        if (oid.equals((Object)AlgID.md2WithRSAEncryption.getOID())) {
            return "MD2withRSA";
        }
        if (oid.equals((Object)AlgID.sha_1WithRSAEncryption.getOID())) {
            return "SHA1withRSA";
        }
        if (oid.equals((Object)AlgID.dsaWithSHA1.getOID()) || oid.equals((Object)AlgID.dsaWithSHA.getOID()) || oid.equals((Object)AlgID.dsaWithSHA1Old.getOID())) {
            return "SHA1withDSA";
        }
        return "";
    }

    public byte[] getSigAlgParams() {
        return Utils.toBytes((Streamable)this.sigAlgID.getParameters());
    }

    public int getVersion() {
        return this.version;
    }

    public Set getCriticalExtensionOIDs() {
        return this.criticalOIDs;
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.nonCriticalOIDs;
    }

    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        byte[] value = (byte[])this.extensions.get(oid);
        if (value != null && value.length > 0) {
            UnsyncByteArrayOutputStream os = new UnsyncByteArrayOutputStream();
            try {
                ASN1OctetString.outputValue((OutputStream)os, (byte[])value);
            }
            catch (IOException ioe) {
                return null;
            }
            return os.toByteArray();
        }
        return null;
    }

    private byte[] getExtensionValueNoDer(String oid) {
        if (this.extensions == null) {
            return null;
        }
        return (byte[])this.extensions.get(oid);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCriticalExtension;
    }

    public int getBasicConstraints() {
        if (this.basicConstraints == -1) {
            byte[] value = this.getExtensionValueNoDer(basicConstraintsOID);
            if (value == null) {
                return -1;
            }
            try {
                ASN1SequenceInputStream sisValue = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(value));
                boolean ca = false;
                if (sisValue.hasMoreData() && sisValue.getCurrentTag() == 1) {
                    ca = ASN1Boolean.inputValue((InputStream)sisValue);
                }
                if (sisValue.hasMoreData()) {
                    if (ca) {
                        this.basicConstraints = ASN1Integer.inputValue((InputStream)sisValue).intValue();
                    } else {
                        throw new RuntimeException("Malformed extension contents");
                    }
                }
                sisValue.terminate();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        return this.basicConstraints;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage == null) {
            int i;
            byte[] value = this.getExtensionValueNoDer(keyUsageOID);
            if (value == null) {
                return null;
            }
            try {
                ASN1BitString b = new ASN1BitString((InputStream)new UnsyncByteArrayInputStream(value));
                this.keyUsage = new boolean[b.bitLength()];
                for (i = 0; i < this.keyUsage.length; ++i) {
                    this.keyUsage[i] = b.testBit(i);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new RuntimeException("Unknown key usage flag: " + i);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        return this.keyUsage;
    }

    public boolean equals(Object o) {
        try {
            if (o != null && o instanceof X509Certificate) {
                return Utils.areEqual((byte[])this.getEncoded(), (byte[])((X509Certificate)o).getEncoded());
            }
            return false;
        }
        catch (CertificateEncodingException ex) {
            return false;
        }
    }

    public int hashCode() {
        return new String(this.getEncoded()).hashCode();
    }

    public String toString() {
        String s = "";
        s = s + "{ notBefore = " + this.notBeforeDate;
        s = s + ", notAfter = " + this.notAfterDate;
        s = s + ", subject = " + this.subject;
        s = s + ", issuer = " + this.issuer;
        s = s + ", serialNo = " + this.serialNo;
        s = s + ", sigAlgOID = " + this.getSigAlgOID();
        s = s + " }";
        return s;
    }
}

