/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.crypto;

import javax.crypto.SecretKey;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;

public final class PbeSecretKeyImpl
implements SecretKey {
    private int keysize;
    private String algorithm;
    private String password;
    private PBEAlgorithmIdentifier pbeAlgID;

    public PbeSecretKeyImpl(String password, AlgorithmIdentifier algID, String algorithm, int keysize) throws AlgorithmIdentifierException {
        this.algorithm = algorithm;
        this.password = password;
        this.pbeAlgID = algID instanceof PBEAlgorithmIdentifier ? (PBEAlgorithmIdentifier)algID : new PBEAlgorithmIdentifier(algID.getOID());
        this.keysize = keysize;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return null;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int keysize() {
        return this.keysize;
    }

    public void setParameters(byte[] salt, int iterationCount) {
        try {
            this.pbeAlgID = new PBEAlgorithmIdentifier(this.pbeAlgID.getOID(), salt, iterationCount);
        }
        catch (AlgorithmIdentifierException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public PBEAlgorithmIdentifier getAlgID() {
        return this.pbeAlgID;
    }
}

