/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.DHPrivateKeyImpl;
import oracle.security.crypto.jce.crypto.DHPublicKeyImpl;
import oracle.security.crypto.jce.crypto.DSAPrivateKeyImpl;
import oracle.security.crypto.jce.crypto.DSAPublicKeyImpl;
import oracle.security.crypto.jce.crypto.RSAPrivateCrtKeyImpl;
import oracle.security.crypto.jce.crypto.RSAPublicKeyImpl;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;

public final class PhaosJCEKeyTranslator {
    public static DSAPrivateKey jceDSAPrivateKeyToPhaosJCE(DSAPrivateKey jceKey) {
        if (jceKey instanceof DSAPrivateKeyImpl) {
            return jceKey;
        }
        oracle.security.crypto.core.DSAPrivateKey phaosKey = null;
        try {
            phaosKey = new oracle.security.crypto.core.DSAPrivateKey(jceKey.getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return new DSAPrivateKeyImpl(phaosKey);
    }

    public static oracle.security.crypto.core.DSAPrivateKey jceDSAPrivateKeyToPhaos(DSAPrivateKey jceKey) {
        return ((DSAPrivateKeyImpl)PhaosJCEKeyTranslator.jceDSAPrivateKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static DSAPublicKey jceDSAPublicKeyToPhaosJCE(DSAPublicKey jceKey) {
        if (jceKey instanceof DSAPublicKeyImpl) {
            return jceKey;
        }
        oracle.security.crypto.core.DSAPublicKey phaosKey = null;
        try {
            phaosKey = new oracle.security.crypto.core.DSAPublicKey(jceKey.getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return new DSAPublicKeyImpl(phaosKey);
    }

    public static oracle.security.crypto.core.DSAPublicKey jceDSAPublicKeyToPhaos(DSAPublicKey jceKey) {
        return ((DSAPublicKeyImpl)PhaosJCEKeyTranslator.jceDSAPublicKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static RSAPrivateKey jceRSAPrivateKeyToPhaosJCE(RSAPrivateKey jceKey) {
        if (jceKey instanceof RSAPrivateCrtKeyImpl) {
            return jceKey;
        }
        oracle.security.crypto.core.RSAPrivateKey phaosKey = null;
        try {
            phaosKey = new oracle.security.crypto.core.RSAPrivateKey(jceKey.getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return new RSAPrivateCrtKeyImpl(phaosKey);
    }

    public static oracle.security.crypto.core.RSAPrivateKey jceRSAPrivateKeyToPhaos(RSAPrivateKey jceKey) {
        return ((RSAPrivateCrtKeyImpl)PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static java.security.interfaces.RSAPublicKey jceRSAPublicKeyToPhaosJCE(java.security.interfaces.RSAPublicKey jceKey) {
        if (jceKey instanceof RSAPublicKeyImpl) {
            return jceKey;
        }
        RSAPublicKey phaosKey = null;
        try {
            phaosKey = new RSAPublicKey(jceKey.getEncoded());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return new RSAPublicKeyImpl(phaosKey);
    }

    public static RSAPublicKey jceRSAPublicKeyToPhaos(java.security.interfaces.RSAPublicKey jceKey) {
        return ((RSAPublicKeyImpl)PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static javax.crypto.interfaces.DHPrivateKey jceDHPrivateKeyToPhaosJCE(javax.crypto.interfaces.DHPrivateKey jceKey) {
        if (jceKey instanceof DHPrivateKeyImpl) {
            return jceKey;
        }
        DHPrivateKey phaosKey = null;
        try {
            new DHPrivateKey((InputStream)new ByteArrayInputStream(jceKey.getEncoded()));
        }
        catch (IOException e) {
            DHParameterSpec p = jceKey.getParams();
            DHParams params = new DHParams(p.getP(), p.getG(), p.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            phaosKey = new DHPrivateKey(jceKey.getX(), params);
        }
        return new DHPrivateKeyImpl(phaosKey);
    }

    public static DHPrivateKey jceDHPrivateKeyToPhaos(javax.crypto.interfaces.DHPrivateKey jceKey) {
        return ((DHPrivateKeyImpl)PhaosJCEKeyTranslator.jceDHPrivateKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static DHPublicKey jceDHPublicKeyToPhaosJCE(DHPublicKey jceKey) {
        if (jceKey instanceof DHPublicKeyImpl) {
            return jceKey;
        }
        oracle.security.crypto.core.DHPublicKey phaosKey = null;
        try {
            phaosKey = new oracle.security.crypto.core.DHPublicKey((InputStream)new ByteArrayInputStream(jceKey.getEncoded()));
        }
        catch (IOException e) {
            DHParameterSpec p = jceKey.getParams();
            DHParams params = new DHParams(p.getP(), p.getG(), p.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            phaosKey = new oracle.security.crypto.core.DHPublicKey(jceKey.getY(), params);
        }
        return new DHPublicKeyImpl(phaosKey);
    }

    public static oracle.security.crypto.core.DHPublicKey jceDHPublicKeyToPhaos(DHPublicKey jceKey) {
        return ((DHPublicKeyImpl)PhaosJCEKeyTranslator.jceDHPublicKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static PrivateKey jcePrivateKeyToPhaos(java.security.PrivateKey jceKey) {
        if (jceKey instanceof RSAPrivateKey) {
            return PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaos((RSAPrivateKey)jceKey);
        }
        if (jceKey instanceof javax.crypto.interfaces.DHPrivateKey) {
            return PhaosJCEKeyTranslator.jceDHPrivateKeyToPhaos((javax.crypto.interfaces.DHPrivateKey)jceKey);
        }
        if (jceKey instanceof DSAPrivateKey) {
            return PhaosJCEKeyTranslator.jceDSAPrivateKeyToPhaos((DSAPrivateKey)jceKey);
        }
        throw new IllegalStateException("Key unknown");
    }

    public static PublicKey jcePublicKeyToPhaos(java.security.PublicKey jceKey) {
        if (jceKey instanceof java.security.interfaces.RSAPublicKey) {
            return PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaos((java.security.interfaces.RSAPublicKey)jceKey);
        }
        if (jceKey instanceof DHPublicKey) {
            return PhaosJCEKeyTranslator.jceDHPublicKeyToPhaos((DHPublicKey)jceKey);
        }
        if (jceKey instanceof DSAPublicKey) {
            return PhaosJCEKeyTranslator.jceDSAPublicKeyToPhaos((DSAPublicKey)jceKey);
        }
        throw new IllegalStateException("Key unknown");
    }

    public static SecretKey jceSecretKeyToPhaosJCE(SecretKey jceKey) {
        if (jceKey instanceof SecretKeyImpl) {
            return jceKey;
        }
        SymmetricKey phaosKey = new SymmetricKey(jceKey.getEncoded());
        return new SecretKeyImpl(phaosKey, jceKey.getAlgorithm());
    }

    public static SymmetricKey jceSecretKeyToPhaos(SecretKey jceKey) {
        return ((SecretKeyImpl)PhaosJCEKeyTranslator.jceSecretKeyToPhaosJCE(jceKey)).getPhaosKey();
    }

    public static DSAPrivateKeyImpl phaosDSAPrivateKeyToJCE(oracle.security.crypto.core.DSAPrivateKey phaosKey) {
        return new DSAPrivateKeyImpl(phaosKey);
    }

    public static DSAPublicKeyImpl phaosDSAPublicKeyToJCE(oracle.security.crypto.core.DSAPublicKey phaosKey) {
        return new DSAPublicKeyImpl(phaosKey);
    }

    public static RSAPrivateCrtKeyImpl phaosRSAPrivateKeyToJCE(oracle.security.crypto.core.RSAPrivateKey phaosKey) {
        return new RSAPrivateCrtKeyImpl(phaosKey);
    }

    public static RSAPublicKeyImpl phaosRSAPublicKeyToJCE(RSAPublicKey phaosKey) {
        return new RSAPublicKeyImpl(phaosKey);
    }

    public static DHPrivateKeyImpl phaosDHPrivateKeyToJCE(DHPrivateKey phaosKey) {
        return new DHPrivateKeyImpl(phaosKey);
    }

    public static DHPublicKeyImpl phaosDHPublicKeyToJCE(oracle.security.crypto.core.DHPublicKey phaosKey) {
        return new DHPublicKeyImpl(phaosKey);
    }

    public static java.security.PrivateKey phaosPrivateKeyToJCE(PrivateKey phaosKey) {
        if (phaosKey instanceof oracle.security.crypto.core.RSAPrivateKey) {
            return PhaosJCEKeyTranslator.phaosRSAPrivateKeyToJCE((oracle.security.crypto.core.RSAPrivateKey)phaosKey);
        }
        if (phaosKey instanceof DHPrivateKey) {
            return PhaosJCEKeyTranslator.phaosDHPrivateKeyToJCE((DHPrivateKey)phaosKey);
        }
        if (phaosKey instanceof oracle.security.crypto.core.DSAPrivateKey) {
            return PhaosJCEKeyTranslator.phaosDSAPrivateKeyToJCE((oracle.security.crypto.core.DSAPrivateKey)phaosKey);
        }
        throw new IllegalStateException("Key unknown");
    }

    public static java.security.PublicKey phaosPublicKeyToJCE(PublicKey phaosKey) {
        if (phaosKey instanceof RSAPublicKey) {
            return PhaosJCEKeyTranslator.phaosRSAPublicKeyToJCE((RSAPublicKey)phaosKey);
        }
        if (phaosKey instanceof oracle.security.crypto.core.DHPublicKey) {
            return PhaosJCEKeyTranslator.phaosDHPublicKeyToJCE((oracle.security.crypto.core.DHPublicKey)phaosKey);
        }
        if (phaosKey instanceof oracle.security.crypto.core.DSAPublicKey) {
            return PhaosJCEKeyTranslator.phaosDSAPublicKeyToJCE((oracle.security.crypto.core.DSAPublicKey)phaosKey);
        }
        throw new IllegalStateException("Key unknown");
    }
}

