/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.SecureRandom;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.SymmetricKeyGenerator;
import oracle.security.crypto.jce.provider.PhaosKeyGeneratorSpi;

public final class AESKeyGeneratorSpi
extends PhaosKeyGeneratorSpi {
    public AESKeyGeneratorSpi() throws AlgorithmIdentifierException {
        super(SymmetricKeyGenerator.getInstance((AlgorithmIdentifier)AlgID.aes128_CBC), "AES");
    }

    public void engineInit(int keysize, SecureRandom random) {
        try {
            if (keysize == 128) {
                this.skg.setAlgID(AlgID.aes128_CBC);
            } else if (keysize == 192) {
                this.skg.setAlgID(AlgID.aes192_CBC);
            } else if (keysize == 256) {
                this.skg.setAlgID(AlgID.aes256_CBC);
            }
        }
        catch (AlgorithmIdentifierException ex) {
            throw new IllegalStateException(ex.toString());
        }
        super.engineInit(keysize, random);
    }
}

