/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class DHAlgorithmParametersSpi
extends AlgorithmParametersSpi {
    private DHParams params;
    private int l;

    protected byte[] engineGetEncoded() throws IOException {
        if (this.params != null) {
            return Utils.toBytes((Streamable)this.params);
        }
        return null;
    }

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (format.equalsIgnoreCase("ASN.1")) {
            throw new InvalidParameterException("Format unsupported: " + format);
        }
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (this.params == null) {
            return null;
        }
        if (paramSpec.equals(DHParameterSpec.class)) {
            return new DHParameterSpec(this.params.getP(), this.params.getG(), this.l);
        }
        throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.params = null;
        this.l = 0;
        if (!(paramSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter: " + paramSpec);
        }
        DHParameterSpec dhParams = (DHParameterSpec)paramSpec;
        this.params = new DHParams(dhParams.getP(), dhParams.getG(), dhParams.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
        this.l = dhParams.getL();
    }

    protected void engineInit(byte[] params) throws IOException {
        this.params = null;
        this.l = 0;
        if (params == null) {
            return;
        }
        this.params = new DHParams((InputStream)new ByteArrayInputStream(params));
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format.equalsIgnoreCase("ASN.1")) {
            throw new InvalidParameterException("Format unsupported: " + format);
        }
        this.engineInit(params);
    }

    protected String engineToString() {
        return "DH Parameter={p=" + this.params.getP() + ", g=" + this.params.getG() + ", l=" + this.l + "}";
    }
}

