/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.KeyAgreement;
import oracle.security.crypto.core.KeyAgreementException;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.crypto.DHPublicKeyImpl;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;
import oracle.security.crypto.util.Utils;

public class DHKeyAgreementSpi
extends KeyAgreementSpi {
    private KeyAgreement dh;
    private RandomBitsSource rbs;
    private DHPrivateKey privKey;
    private boolean initialized = false;
    private static final int ENGINE_INIT_KEY_ALGSPEC_RND = 1;
    private static final int ENGINE_INIT_KEY_RND = 2;
    private int engineInitMethod;
    private Key engineInitKey;
    private SecureRandom engineInitRandom;
    private AlgorithmParameterSpec engineInitParamSpec;

    public DHKeyAgreementSpi() {
        try {
            this.dh = KeyAgreement.getInstance((AlgorithmIdentifier)AlgID.dh);
        }
        catch (AlgorithmIdentifierException e) {
            throw new RuntimeException(e.toString());
        }
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws java.security.InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new java.security.InvalidKeyException("Invalid key type: " + key);
        }
        try {
            this.dh.setPublicKey((PublicKey)PhaosJCEKeyTranslator.jceDHPublicKeyToPhaos((DHPublicKey)key));
        }
        catch (InvalidKeyException e) {
            throw new java.security.InvalidKeyException(e.toString());
        }
        if (!this.initialized) {
            throw new IllegalStateException("The Key Agreement is not initialized");
        }
        if (lastPhase) {
            return null;
        }
        oracle.security.crypto.core.DHPublicKey pubKey = new oracle.security.crypto.core.DHPublicKey(new BigInteger(1, this.engineGenerateSecret()), this.privKey.getParams());
        return new DHPublicKeyImpl(pubKey);
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Key agreement object not initialized");
        }
        byte[] secret = null;
        try {
            secret = this.dh.generateSecret();
        }
        catch (KeyAgreementException e) {
            throw new IllegalStateException(e.toString());
        }
        this.reinitialize();
        return secret;
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (sharedSecret.length - offset < Utils.length((BigInteger)this.privKey.getParams().getP())) {
            throw new ShortBufferException("Buffer too small");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, java.security.InvalidKeyException {
        byte[] secret = this.engineGenerateSecret();
        try {
            KeySpec spec = algorithm.equals("DES") ? new DESKeySpec(secret) : (algorithm.equals("DESede") || algorithm.equals("TripleDES") ? new DESedeKeySpec(secret) : new SecretKeySpec(secret, algorithm));
            SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
            return factory.generateSecret(spec);
        }
        catch (InvalidKeySpecException ex) {
            throw new java.security.InvalidKeyException(ex.toString());
        }
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws java.security.InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(params instanceof DHParameterSpec)) {
            throw new java.security.InvalidKeyException("Invalid AlgorithmParameterSpec type: " + params);
        }
        this.engineInit(key, random);
        this.engineInitMethod = 1;
        this.engineInitKey = key;
        this.engineInitRandom = random;
        this.engineInitParamSpec = params;
    }

    protected void engineInit(Key key, SecureRandom random) throws java.security.InvalidKeyException {
        if (!(key instanceof javax.crypto.interfaces.DHPrivateKey)) {
            throw new java.security.InvalidKeyException("Invalid key type: " + key);
        }
        this.privKey = PhaosJCEKeyTranslator.jceDHPrivateKeyToPhaos((javax.crypto.interfaces.DHPrivateKey)key);
        try {
            this.dh.setPrivateKey((PrivateKey)this.privKey);
        }
        catch (InvalidKeyException e) {
            throw new java.security.InvalidKeyException(e.toString());
        }
        this.rbs = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.initialized = true;
        this.engineInitMethod = 2;
        this.engineInitKey = key;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    private void reinitialize() {
        block5: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInit(this.engineInitKey, this.engineInitParamSpec, this.engineInitRandom);
                    break block5;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInit(this.engineInitKey, this.engineInitRandom);
                    break block5;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IllegalStateException(ex.toString());
            }
            catch (java.security.InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }
}

