/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.PhaosKeyGeneratorSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class HmacSecretKeyGeneratorSpi
extends PhaosKeyGeneratorSpi {
    private int defaultKeyLength;

    protected HmacSecretKeyGeneratorSpi(int keyLength, String algName) {
        super(null, algName);
        this.defaultKeyLength = keyLength / 8;
    }

    public void engineInit(SecureRandom random) {
        this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.length = -1;
        this.initialized = true;
    }

    public void engineInit(int keysize, SecureRandom random) {
        this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.length = keysize / 8;
        this.initialized = true;
    }

    public void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Method not supported");
    }

    public SecretKey engineGenerateKey() {
        if (!this.initialized || this.length < 0) {
            this.length = this.defaultKeyLength;
        }
        if (this.random == null) {
            return new SecretKeyImpl(new SymmetricKey(RandomBitsSource.getDefault().randomBytes(new byte[this.length])), this.algName);
        }
        return new SecretKeyImpl(new SymmetricKey(this.random.randomBytes(new byte[this.length])), this.algName);
    }
}

