/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import oracle.security.crypto.util.Utils;

public class JCEVerifier {
    private static boolean jceFrameworkVerified = false;
    private static boolean phaosProviderVerified = false;
    private static X509Certificate[] trustedCACerts;
    static /* synthetic */ Class class$javax$crypto$Cipher;
    static /* synthetic */ Class class$oracle$security$crypto$jce$provider$OracleJCE;

    public static void performAuthentication() {
        JCEVerifier.verifyJCEFramework();
        JCEVerifier.verifyPhaosProvider();
    }

    private static void verifyJCEFramework() {
        block15: {
            if (jceFrameworkVerified) {
                return;
            }
            URL jceJarURL = null;
            try {
                JarFile jarFile;
                Class<?> c = new JCEVerifier().getClass();
                final ClassLoader cl = c.getClassLoader();
                URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        CodeSource cs = (class$javax$crypto$Cipher == null ? (class$javax$crypto$Cipher = JCEVerifier.class$("javax.crypto.Cipher")) : class$javax$crypto$Cipher).getProtectionDomain().getCodeSource();
                        if (cs != null) {
                            return cs.getLocation();
                        }
                        return null;
                    }
                });
                if (url != null) {
                    JarInputStream jarIS;
                    try {
                        final URL finalurl = url;
                        jarIS = (JarInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return new JarInputStream(finalurl.openStream());
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        pae.printStackTrace();
                        throw new SecurityException("The Oracle JCE provider cannot authenticate the JCE framework " + pae);
                    }
                    try {
                        JCEVerifier.verifySingleJarFile(jarIS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new SecurityException("The Oracle JCE provider cannot authenticate the JCE framework: " + e);
                    }
                    jceFrameworkVerified = true;
                    break block15;
                }
                url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return cl.getResource("javax/crypto/Cipher.class");
                    }
                });
                if (url == null) {
                    throw new SecurityException("The Oracle JCE provider cannot get the JCE framework URL. Check that this provider can read the JCE framework");
                }
                String urlStr = url.toString();
                int per = urlStr.lastIndexOf(".jar!/");
                if (per == -1) {
                    throw new SecurityException("The JCE framework is invalid");
                }
                int slash = per + 5;
                jceJarURL = new URL(urlStr.substring(0, slash + 1));
                int beginIndex = 4;
                URL jceURL = new URL(urlStr.substring(beginIndex, slash - 1));
                if (!jceURL.getProtocol().equalsIgnoreCase("file")) {
                    throw new SecurityException("JCE must be deployed as an installed extension or on the class path");
                }
                try {
                    final URL finalurl = jceJarURL;
                    jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return ((JarURLConnection)finalurl.openConnection()).getJarFile();
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    pae.printStackTrace();
                    throw new SecurityException("The Oracle JCE provider cannot authenticate the JCE framework " + pae);
                }
                try {
                    JCEVerifier.verifySingleJarFile(jarFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SecurityException("The Oracle JCE provider cannot authenticate the JCE framework: " + e);
                }
                jceFrameworkVerified = true;
            }
            catch (IOException ex) {
                throw new SecurityException("The JCE Framework could not be verified: " + ex);
            }
        }
    }

    private static void verifyPhaosProvider() {
        if (phaosProviderVerified) {
            return;
        }
        final ClassLoader cl = new JCEVerifier().getClass().getClassLoader();
        URL providerURL = null;
        String jarURLStr = null;
        providerURL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource cs = (class$oracle$security$crypto$jce$provider$OracleJCE == null ? (class$oracle$security$crypto$jce$provider$OracleJCE = JCEVerifier.class$("oracle.security.crypto.jce.provider.OracleJCE")) : class$oracle$security$crypto$jce$provider$OracleJCE).getProtectionDomain().getCodeSource();
                if (cs != null) {
                    return cs.getLocation();
                }
                return null;
            }
        });
        if (providerURL != null) {
            jarURLStr = "jar:" + providerURL.toString() + "!/";
        } else {
            providerURL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getResource("oracle/security/crypto/jce/provider/OracleJCE.class");
                }
            });
            if (providerURL == null) {
                throw new SecurityException("The Oracle JCE provider cannot get the Oracle JCE framework URL. Check that this provider can read the Oracle JCE framework");
            }
            String urlStr = providerURL.toString();
            int per = urlStr.lastIndexOf(".jar!/");
            if (per == -1) {
                throw new SecurityException("The Oracle JCE framework is invalid");
            }
            int slash = per + 5;
            jarURLStr = urlStr.substring(0, slash + 1);
        }
        try {
            JarFile jarFile;
            providerURL = new URL(jarURLStr);
            int beginIndex = 4;
            URL jceURL = new URL(jarURLStr.substring(beginIndex));
            if (!jceURL.getProtocol().equalsIgnoreCase("file")) {
                throw new SecurityException("Oracle JCE must be deployed as an installed extension or on the class path");
            }
            try {
                final URL url = providerURL;
                jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ((JarURLConnection)url.openConnection()).getJarFile();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                pae.printStackTrace();
                throw new SecurityException("The Oracle JCE provider cannot authenticate the Oracle JCE framework " + pae);
            }
            try {
                JCEVerifier.verifySingleJarFile(jarFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SecurityException("The Oracle JCE provider cannot authenticate the Oracle JCE framework: " + e);
            }
            phaosProviderVerified = true;
        }
        catch (IOException ex) {
            throw new SecurityException("The Oracle JCE provider cannot authenticate the Oracle JCE framework: " + ex);
        }
    }

    private static void verifySingleJarFile(JarInputStream jarIS) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = jarIS.getManifest();
        if (man == null) {
            throw new SecurityException("The jar file is not signed");
        }
        byte[] buffer = new byte[8192];
        JarEntry je = null;
        while ((je = jarIS.getNextJarEntry()) != null) {
            int n;
            entriesVec.addElement(je);
            while ((n = jarIS.read(buffer, 0, buffer.length)) != -1) {
            }
        }
        jarIS.close();
        JCEVerifier.finishVerification(entriesVec);
    }

    private static void verifySingleJarFile(JarFile jarFile) throws IOException, CertificateException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = jarFile.getManifest();
        if (man == null) {
            throw new SecurityException("The jar file is not signed");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jarFile.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            is.close();
        }
        JCEVerifier.finishVerification(entriesVec);
    }

    private static void finishVerification(Vector entriesVec) throws IOException, CertificateException {
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("The jar file has unsigned class files.");
            }
            Certificate[] chainRoots = JCEVerifier.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (!JCEVerifier.isTrusted((X509Certificate)chainRoots[i], trustedCACerts)) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("The jar file is not signed by a trusted signer");
        }
    }

    private static boolean isTrusted(X509Certificate cert, X509Certificate[] trustedCaCerts) {
        int i;
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!((Object)cert.getSubjectDN()).equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            String caDN;
            String certDN = cert.getIssuerX500Principal().getName("CANONICAL");
            if (!certDN.equalsIgnoreCase(caDN = trustedCaCerts[i].getSubjectX500Principal().getName("CANONICAL"))) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private static Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((Object)((X509Certificate)certs[i + 1]).getSubjectDN()).equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }

    static {
        byte[] certData = Utils.fromHexString((String)"308203c03082037ea003020102020101300b06072a8648ce3804030500308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341301e170d3030303431323037303030305a170d3036303431323037303030305a308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341308201b73082012c06072a8648ce3804013082011f02818100ebaf37041eca511e695db0f28ff6b5491fc6a49905d729bf74b76af519d81ee41bf80a019a98ff70abe24a56866c53b3fce1c8818c31f0c4f3b08be67006ecf76968db834c7229892936175c3b4a07a020022a4697511d70c808180bce0c6e9b76f705e3e7fbd36179e1609a248d0695833c5120e130cf385782a61a720dced3021500842545e1bab9a962ab79e85b30b8896b1bff7b7502818100abc9747b74efee42b56a534d3bdd90067268910f0ba429762e553bd5ae4d655c7e2a3a04a667a6d071aaa5d7b7e2c1720da4d1aa1e92544c200009a2b00941193300b2c35cae42f8b18bca7c96d8107f37445baacc78c8d77276376b4099a85566faa8031e8b4a110269cb4cb825061ca077d2c9acd23de90a10fa7670b7fbdc038184000281802d09985cacb89cc7997eee20192a3490f9d7ababaedd6b72950d66f8ef278f44b2ed2844c7feafb0a6276f006745825b07a856563bd22951615e6939d72e747712cf194af52dc8cb7261c44e6ffa47433f14bbfabc186628c2d9668b7a2d2fc260924b14fe583e217f6862be6c4849f9a04b5e859d1910f91545511b71d4f70ba3663064301106096086480186f8420101040403020007300f0603551d130101ff040530030101ff301f0603551d2304183016801465e2f486c9d34ef0914e58a26af5d8785a9ac1a6301d0603551d0e0416041465e2f486c9d34ef0914e58a26af5d8785a9ac1a6300b06072a8648ce3804030500032f00302c0214249f02c3fb31d5913bf97e566f96df640a0498b402146e7984a7ee68a302723163db43ab08ec4def163a");
        trustedCACerts = new X509Certificate[1];
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            JCEVerifier.trustedCACerts[0] = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certData));
        }
        catch (CertificateException ce) {
            throw new SecurityException("The Oracle JCE provider is unable to load the trusted certificates: " + ce.getMessage());
        }
    }
}

