/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPublicKey;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.jce.crypto.DHPrivateKeyImpl;
import oracle.security.crypto.jce.crypto.DHPublicKeyImpl;
import oracle.security.crypto.jce.crypto.DSAPrivateKeyImpl;
import oracle.security.crypto.jce.crypto.DSAPublicKeyImpl;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.crypto.RSAPrivateCrtKeyImpl;
import oracle.security.crypto.jce.crypto.RSAPrivateKeyImpl;
import oracle.security.crypto.jce.crypto.RSAPublicKeyImpl;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;

public class PhaosKeyFactorySpi
extends KeyFactorySpi {
    protected PrivateKey engineGeneratePrivate(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof PKCS8EncodedKeySpec) {
            try {
                UnsyncByteArrayInputStream bs = new UnsyncByteArrayInputStream(((PKCS8EncodedKeySpec)spec).getEncoded());
                return PhaosJCEKeyTranslator.phaosPrivateKeyToJCE(CryptoUtils.inputPrivateKey((InputStream)bs));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException("Couldn't input private key from spec: " + ex.getMessage());
            }
        }
        if (spec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec jceKey = (RSAPrivateCrtKeySpec)spec;
            oracle.security.crypto.core.RSAPrivateKey privKey = new oracle.security.crypto.core.RSAPrivateKey(jceKey.getModulus(), jceKey.getPrivateExponent(), jceKey.getPublicExponent(), jceKey.getPrimeP(), jceKey.getPrimeQ(), jceKey.getPrimeExponentP(), jceKey.getPrimeExponentQ(), jceKey.getCrtCoefficient());
            return new RSAPrivateCrtKeyImpl(privKey);
        }
        if (spec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec jceKey = (RSAPrivateKeySpec)spec;
            oracle.security.crypto.core.RSAPrivateKey privKey = new oracle.security.crypto.core.RSAPrivateKey(jceKey.getModulus(), jceKey.getPrivateExponent());
            return new RSAPrivateKeyImpl(privKey);
        }
        if (spec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec jceKey = (DSAPrivateKeySpec)spec;
            DSAParams params = new DSAParams(jceKey.getP(), jceKey.getQ(), jceKey.getG());
            oracle.security.crypto.core.DSAPrivateKey privKey = new oracle.security.crypto.core.DSAPrivateKey(jceKey.getX(), params);
            return new DSAPrivateKeyImpl(privKey);
        }
        if (spec instanceof DHPrivateKeySpec) {
            DHPrivateKeySpec jceKey = (DHPrivateKeySpec)spec;
            DHParams params = new DHParams(jceKey.getP(), jceKey.getG(), jceKey.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            oracle.security.crypto.core.DHPrivateKey privKey = new oracle.security.crypto.core.DHPrivateKey(jceKey.getX(), params);
            return new DHPrivateKeyImpl(privKey);
        }
        throw new InvalidKeySpecException("Unsupported KeySpec received: " + spec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof X509EncodedKeySpec) {
            try {
                UnsyncByteArrayInputStream bs = new UnsyncByteArrayInputStream(((X509EncodedKeySpec)spec).getEncoded());
                return PhaosJCEKeyTranslator.phaosPublicKeyToJCE(CryptoUtils.inputSPKI((InputStream)bs));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException("Couldn't input public key from spec: " + ex.toString());
            }
        }
        if (spec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec jceKey = (RSAPublicKeySpec)spec;
            RSAPublicKey pubKey = new RSAPublicKey(jceKey.getModulus(), jceKey.getPublicExponent());
            return new RSAPublicKeyImpl(pubKey);
        }
        if (spec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec jceKey = (DSAPublicKeySpec)spec;
            DSAParams params = new DSAParams(jceKey.getP(), jceKey.getQ(), jceKey.getG());
            oracle.security.crypto.core.DSAPublicKey pubKey = new oracle.security.crypto.core.DSAPublicKey(jceKey.getY(), params);
            return new DSAPublicKeyImpl(pubKey);
        }
        if (spec instanceof DHPublicKeySpec) {
            DHPublicKeySpec jceKey = (DHPublicKeySpec)spec;
            DHParams params = new DHParams(jceKey.getP(), jceKey.getG(), jceKey.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            DHPublicKey pubKey = new DHPublicKey(jceKey.getY(), params);
            return new DHPublicKeyImpl(pubKey);
        }
        throw new InvalidKeySpecException("Unsupported KeySpec received: " + spec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        if (keySpec.isAssignableFrom(PKCS8EncodedKeySpec.class) && (key instanceof RSAPrivateCrtKey || key instanceof DSAPrivateKey || key instanceof RSAPrivateKey)) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (keySpec.isAssignableFrom(X509EncodedKeySpec.class) && (key instanceof java.security.interfaces.RSAPublicKey || key instanceof DSAPublicKey)) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (keySpec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey k = (java.security.interfaces.RSAPublicKey)key;
            return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
        }
        if (keySpec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        if (keySpec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
        }
        if (keySpec.isAssignableFrom(DSAPublicKeySpec.class) && key instanceof DSAPublicKey) {
            java.security.interfaces.DSAParams params = ((DSAPublicKey)key).getParams();
            return new DSAPublicKeySpec(((DSAPublicKey)key).getY(), params.getP(), params.getQ(), params.getG());
        }
        if (keySpec.isAssignableFrom(DSAPrivateKeySpec.class) && key instanceof DSAPrivateKey) {
            java.security.interfaces.DSAParams params = ((DSAPrivateKey)key).getParams();
            return new DSAPrivateKeySpec(((DSAPrivateKey)key).getX(), params.getP(), params.getQ(), params.getG());
        }
        if (keySpec.isAssignableFrom(DHPublicKeySpec.class) && key instanceof javax.crypto.interfaces.DHPublicKey) {
            DHParameterSpec params = ((javax.crypto.interfaces.DHPublicKey)key).getParams();
            return new DHPublicKeySpec(((javax.crypto.interfaces.DHPublicKey)key).getY(), params.getP(), params.getG());
        }
        if (keySpec.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
            DHParameterSpec params = ((DHPrivateKey)key).getParams();
            return new DHPrivateKeySpec(((DHPrivateKey)key).getX(), params.getP(), params.getG());
        }
        throw new InvalidKeySpecException("Inconsistent parameters: keySpec=" + keySpec.getName() + ", key=" + key);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateCrtKeyImpl || key instanceof RSAPublicKeyImpl || key instanceof DSAPrivateKeyImpl || key instanceof DSAPublicKeyImpl || key instanceof DHPrivateKeyImpl || key instanceof DHPublicKeyImpl) {
            return key;
        }
        if (key instanceof RSAPrivateKey) {
            return PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaosJCE((RSAPrivateKey)key);
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            return PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaosJCE((java.security.interfaces.RSAPublicKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return PhaosJCEKeyTranslator.jceDSAPrivateKeyToPhaosJCE((DSAPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return PhaosJCEKeyTranslator.jceDSAPublicKeyToPhaosJCE((DSAPublicKey)key);
        }
        if (key instanceof DHPrivateKey) {
            return PhaosJCEKeyTranslator.jceDHPrivateKeyToPhaosJCE((DHPrivateKey)key);
        }
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            return PhaosJCEKeyTranslator.jceDHPublicKeyToPhaosJCE((javax.crypto.interfaces.DHPublicKey)key);
        }
        throw new InvalidKeyException("Key was neither a java.security.interfaces.RSA nor a java.security.interfaces.DSA key nor a javax.crypto.interfaces.DH key");
    }
}

