/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKeyGenerator;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public abstract class PhaosKeyGeneratorSpi
extends KeyGeneratorSpi {
    protected SymmetricKeyGenerator skg;
    protected String algName;
    protected boolean initialized = false;
    protected int length;
    protected RandomBitsSource random = null;

    protected PhaosKeyGeneratorSpi(SymmetricKeyGenerator skg, String algName) {
        this.skg = skg;
        this.algName = algName;
    }

    public void engineInit(SecureRandom random) {
        this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.length = -1;
        this.initialized = true;
    }

    public void engineInit(int keysize, SecureRandom random) {
        this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        this.length = keysize / 8;
        this.initialized = true;
    }

    public void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Method not supported");
    }

    public SecretKey engineGenerateKey() {
        if (!this.initialized) {
            this.length = -1;
        }
        if (this.random == null) {
            if (this.length < 0) {
                return new SecretKeyImpl(this.skg.generateKey(), this.algName);
            }
            return new SecretKeyImpl(this.skg.generateKey(this.length), this.algName);
        }
        if (this.length < 0) {
            return new SecretKeyImpl(this.skg.generateKey(this.random), this.algName);
        }
        return new SecretKeyImpl(this.skg.generateKey(this.random, this.length), this.algName);
    }
}

