/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.OAEPAlgorithmIdentifier;
import oracle.security.crypto.core.RSA;
import oracle.security.crypto.core.RSAKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.jce.crypto.PhaosJCEKeyTranslator;
import oracle.security.crypto.jce.crypto.SecretKeyImpl;
import oracle.security.crypto.jce.provider.PhaosAlgorithmParametersSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;
import oracle.security.crypto.util.Utils;

public class RSACipherSpi
extends CipherSpi {
    private Cipher cipher;
    private RSA rsa;
    private AlgorithmIdentifier algID;
    private Key phaosKey;
    private SecureRandom random;
    private int opMode;
    private boolean initialized = false;
    private boolean doPadding;
    private byte[] buffer;
    private int pos;
    private static final int ENGINE_INIT_KEY_ALG_RND = 1;
    private static final int ENGINE_INIT_KEY_ALGSPEC_RND = 2;
    private static final int ENGINE_INIT_KEY_RND = 3;
    private int engineInitMethod;
    private int engineInitMode;
    private java.security.Key engineInitKey;
    private AlgorithmParameters engineInitParams;
    private SecureRandom engineInitRandom;
    private AlgorithmParameterSpec engineInitParamSpec;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB") && !mode.equalsIgnoreCase("NONE")) {
            throw new NoSuchAlgorithmException("Mode " + mode + " not supported");
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding.equalsIgnoreCase("PKCS1Padding") || padding.equalsIgnoreCase("PKCS1") || padding.equalsIgnoreCase("PKCS#1") || padding.equalsIgnoreCase("PKCS#1.5") || padding.equalsIgnoreCase("PKCSv1.5") || padding.equalsIgnoreCase("PKCS#1.5Padding") || padding.equalsIgnoreCase("PKCSv1.5Padding")) {
            this.algID = AlgID.rsaEncryption;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("OAEPWITHSHA1ANDMGF1PADDING") || padding.equalsIgnoreCase("OAEPWITHSHA-1ANDMGF1PADDING")) {
            this.algID = AlgID.rsaWithOAEPEncoding;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("OAEPWITHMD5ANDMGF1PADDING")) {
            this.algID = AlgID.rsaWithOAEP_MD5_MGF1;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("OAEPWITHSHA256ANDMGF1PADDING") || padding.equalsIgnoreCase("OAEPWITHSHA-256ANDMGF1PADDING")) {
            this.algID = AlgID.rsaWithOAEP_SHA256_MGF1;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("OAEPWITHSHA384ANDMGF1PADDING") || padding.equalsIgnoreCase("OAEPWITHSHA-384ANDMGF1PADDING")) {
            this.algID = AlgID.rsaWithOAEP_SHA384_MGF1;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("OAEPWITHSHA512ANDMGF1PADDING") || padding.equalsIgnoreCase("OAEPWITHSHA-512ANDMGF1PADDING")) {
            this.algID = AlgID.rsaWithOAEP_SHA512_MGF1;
            this.doPadding = true;
        } else if (padding.equalsIgnoreCase("NOPADDING") || padding.equalsIgnoreCase("NO_PADDING")) {
            this.algID = AlgID.rsaEncryption;
            this.doPadding = false;
        } else {
            throw new NoSuchPaddingException("Padding " + padding + " not supported");
        }
    }

    protected int engineGetBlockSize() {
        if (this.cipher == null) {
            try {
                return PhaosAlgorithmParametersSpi.getBlockSize(this.algID.getOID());
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        return this.cipher.getBlockSize();
    }

    protected int engineGetOutputSize(int inputLen) {
        if (this.phaosKey != null) {
            int bitLength = this.phaosKey.getBitLength();
            if (bitLength % 8 != 0) {
                return bitLength / 8 + 1;
            }
            return bitLength / 8;
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opMode, java.security.Key key, SecureRandom random) throws InvalidKeyException {
        this.initialize(opMode, key, random);
        this.engineInitMethod = 3;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    protected void engineInit(int opMode, java.security.Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInitMethod = 2;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = null;
        this.engineInitRandom = random;
        this.engineInitParamSpec = paramSpec;
        if (paramSpec instanceof OAEPParameterSpec) {
            OAEPParameterSpec oaepSpec = (OAEPParameterSpec)paramSpec;
            String digest = oaepSpec.getDigestAlgorithm();
            PSource.PSpecified ps = (PSource.PSpecified)oaepSpec.getPSource();
            byte[] params = ps.getValue();
            this.algID = new OAEPAlgorithmIdentifier(digest, params);
        }
        this.initialize(opMode, key, random);
    }

    protected void engineInit(int opMode, java.security.Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initialize(opMode, key, random);
        this.engineInitMethod = 1;
        this.engineInitMode = opMode;
        this.engineInitKey = key;
        this.engineInitParams = params;
        this.engineInitRandom = random;
        this.engineInitParamSpec = null;
    }

    private void initialize(int opMode, java.security.Key key, SecureRandom random) throws InvalidKeyException {
        if (opMode != 1 && opMode != 2 && opMode != 4 && opMode != 3) {
            throw new IllegalStateException("Invalid operation mode: " + opMode);
        }
        this.opMode = opMode;
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            this.phaosKey = PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaos((java.security.interfaces.RSAPublicKey)key);
        } else if (key instanceof RSAPrivateKey) {
            this.phaosKey = PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaos((RSAPrivateKey)key);
        }
        try {
            if (this.doPadding) {
                if (this.cipher == null) {
                    this.cipher = Cipher.getInstance((AlgorithmIdentifier)this.algID, (Key)this.phaosKey, (RandomBitsSource)(random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random)));
                } else {
                    this.cipher.initialize(this.algID, this.phaosKey, (RandomBitsSource)(random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random)));
                }
            } else {
                if (this.rsa == null) {
                    this.rsa = new RSA();
                }
                this.rsa.setKey((RSAKey)this.phaosKey);
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
        this.buffer = new byte[this.engineGetOutputSize(0)];
        this.pos = 0;
        this.initialized = true;
    }

    private void reinitialize() {
        block6: {
            try {
                if (this.engineInitMethod == 1) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParams, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 2) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitParamSpec, this.engineInitRandom);
                    break block6;
                }
                if (this.engineInitMethod == 3) {
                    this.engineInit(this.engineInitMode, this.engineInitKey, this.engineInitRandom);
                    break block6;
                }
                throw new IllegalStateException("Error occured when re-initializing the object: unknown initialization method");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new IllegalStateException(ex.toString());
            }
            catch (InvalidKeyException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
    }

    protected byte[] engineUpdate(byte[] input, int offset, int inputLen) {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        System.arraycopy(input, offset, this.buffer, this.pos, inputLen);
        this.pos += inputLen;
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        System.arraycopy(input, inputOffset, this.buffer, this.pos, inputLen);
        this.pos += inputLen;
        return 0;
    }

    protected byte[] engineDoFinal(byte[] input, int offset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result = this.processData(input, offset, inputLen);
        this.reinitialize();
        return result;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] result = this.processData(input, inputOffset, inputLen);
        System.arraycopy(result, 0, output, outputOffset, result.length);
        this.reinitialize();
        return output.length;
    }

    private byte[] processData(byte[] input, int inputOffset, int inputLen) {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, this.buffer, this.pos, inputLen);
            this.pos += inputLen;
        }
        byte[] target = new byte[this.pos];
        System.arraycopy(this.buffer, 0, target, 0, this.pos);
        byte[] result = null;
        if (this.doPadding) {
            if (this.opMode == 1) {
                try {
                    result = this.cipher.encrypt(target);
                }
                catch (CipherException e) {
                    throw new RuntimeException("Unexpected cipher exception:  " + e.getMessage());
                }
            } else {
                try {
                    result = this.cipher.decrypt(this.buffer);
                }
                catch (CipherException e) {
                    throw new RuntimeException("Unexpected cipher exception:  " + e.getMessage());
                }
            }
        } else {
            BigInteger bi = this.rsa.performOp(new BigInteger(1, target));
            if (this.opMode == 1) {
                result = Utils.toByteArray((BigInteger)bi);
            } else {
                int length = this.engineGetOutputSize(inputLen);
                result = new byte[length];
                Utils.toByteArray((BigInteger)bi, (byte[])result, (int)0, (int)length);
            }
        }
        this.initialized = false;
        return result;
    }

    protected byte[] engineWrap(java.security.Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 4) {
            throw new IllegalStateException("Illegal use: cipher initialized for wrapping only");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Engine can only accept SecretKey implementations for wrapping");
        }
        try {
            return this.cipher.wrapKey(PhaosJCEKeyTranslator.jceSecretKeyToPhaos((SecretKey)key));
        }
        catch (CipherException e) {
            throw new InvalidKeyException(e.toString());
        }
    }

    protected java.security.Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (!this.initialized) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode == 1 || this.opMode == 2) {
            throw new IllegalStateException("Illegal use: cipher initialized for encryption/decryption only");
        }
        if (this.opMode == 3) {
            throw new IllegalStateException("Illegal use: cipher initialized for unwrapping only");
        }
        if (wrappedKeyType != 3) {
            throw new InvalidKeyException("Invalid wrappedKeyType: only unwraps secret keys");
        }
        try {
            SymmetricKey symKey = this.cipher.unwrapSymmetricKey(wrappedKey, new AlgorithmIdentifier(PhaosAlgorithmParametersSpi.stringToOid(wrappedKeyAlgorithm)));
            return new SecretKeyImpl(symKey, wrappedKeyAlgorithm);
        }
        catch (CipherException ex) {
            throw new InvalidKeyException(ex.toString());
        }
    }

    protected int engineGetKeySize(java.security.Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key reference is null");
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            RSAPublicKey phaosKey = PhaosJCEKeyTranslator.jceRSAPublicKeyToPhaos((java.security.interfaces.RSAPublicKey)key);
            return phaosKey.getBitLength();
        }
        if (key instanceof RSAPrivateKey) {
            oracle.security.crypto.core.RSAPrivateKey phaosKey = PhaosJCEKeyTranslator.jceRSAPrivateKeyToPhaos((RSAPrivateKey)key);
            return phaosKey.getBitLength();
        }
        throw new InvalidKeyException("Key was nto an RSA public or private key");
    }
}

