/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.ccr.collector.CollectorMsgID;
import oracle.sysman.ccr.collector.cmd.CommandDispatcher;
import oracle.sysman.ccr.collector.cmd.CommandQualifier;
import oracle.sysman.ccr.collector.cmd.DiagnosticCmd;
import oracle.sysman.ccr.collector.cmd.Lifecycle;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.util.AgentConfig;
import oracle.sysman.ccr.collector.util.Hostname;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.common.network.JCEInitializationException;
import oracle.sysman.ccr.common.network.httplog.HTTPThreadLogger;
import oracle.sysman.ccr.netmgr.OCMEndPoint;

public class Collector {
    private static final String SILENT_QUALIFIER = "silent";
    private static final String CONNECT_QUALIFIER = "connect";
    private static Logger s_log = null;
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.Collector");
    private static Boolean m_bFailOnError = null;
    public static final int ERR_NO_ORACLE_HOME = 1;
    public static final int ERR_UNABLE_TO_TRACE = 2;
    public static final int ERR_COMMAND_PROCESSING = 3;
    public static final int UPDATES_AVAILABLE = 5;
    public static final int NON_MANDATORY_DOWNLOAD_FAILED = 6;
    public static final int LICENSE_DECLINED = 12;
    private static final String ENV_PERL5LIB = "PERL5LIB";
    private static boolean OCM_DISCONNECTED_MODE = false;
    public static final String XML_ATTR_AGENT_MODE = "AGENT_MODE";
    private static final String OCM = "OCM";
    private static final String GC = "GC";
    private static boolean OCM_GRID_AGENT_REMOTE_MODE = false;
    public static final String ON_TARGET_LOCAL = "local";
    private static String OCM_GRID_AGENT_ON_TARGET = "local";
    private static final String ON_TARGET_QUALIFIER = "on_target";
    static String m_strOracleHome = null;
    static String m_strConfigHome = null;
    static String m_strCCRConfigHome = null;
    static HashMap s_hashQualifiers = new HashMap();
    static String m_strFullPath = null;
    static final int STDIN_READ_TIMEOUT = 2000;
    static boolean m_readAgentSeed = false;
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$Collector;

    public static void main(String[] stringArray) {
        int n;
        Collector.getOracleHome();
        System.setProperty("CCR_HOME", m_strOracleHome + File.separator + "ccr");
        Collector.configLogging();
        Collector.enableHTTPLog();
        String[] stringArray2 = Collector.parseCommandQualifiers(stringArray);
        String string = "";
        for (n = 0; n < stringArray2.length; ++n) {
            string = string + stringArray2[n] + " ";
        }
        Collector.setDisconnected();
        if (Collector.isDisconnected()) {
            OCMEndPoint.logConnectFailure();
        }
        if (!Collector.silentMode()) {
            System.out.println(s_bundle.getMessage(CollectorMsgID.BANNER, false));
        }
        s_log.info(CollectorMsgID.BANNER);
        Collector.setGridAgentOnTarget();
        n = 0;
        String string2 = "";
        try {
            Collector.checkPERL5LIB(stringArray2);
        }
        catch (CCRException cCRException) {
            System.err.println(cCRException.getMessage());
            if (s_log != null) {
                s_log.error(CollectorMsgID.EXIT_ERROR_WRAPPER, (Object[])new String[]{cCRException.getMessage()});
            }
            n = 3;
            string2 = cCRException.getMessage();
        }
        CommandDispatcher commandDispatcher = null;
        try {
            if (n == 0) {
                UplinkSystemConfigWriter.getInstance();
                Collector.checkForSignedLicenseAgreement();
                commandDispatcher = CommandDispatcher.getInstance();
                commandDispatcher.addCommand(stringArray2);
                n = commandDispatcher.processRequests();
            }
        }
        catch (CCRException cCRException) {
            Collector.logExceptionChainToStderr(cCRException);
            n = Collector.qualifierSpecified("diagnostic") ? DiagnosticCmd.getDiagExitCode((Exception)((Object)cCRException)) : 3;
            string2 = cCRException.getMessage();
        }
        catch (JCEInitializationException jCEInitializationException) {
            System.err.println(jCEInitializationException.getMessage());
            n = 3;
            string2 = jCEInitializationException.getMessage();
        }
        catch (Throwable throwable) {
            System.err.println(throwable.getMessage());
            n = 3;
            string2 = throwable.getMessage();
        }
        if (!Collector.isDisconnected() && commandDispatcher != null && !commandDispatcher.hasInternalCommand()) {
            Lifecycle.endPing(string.trim(), string2, Hostname.getHostname(), m_strOracleHome, Collector.getConfigHome(), SecurityMgr.getInstance().getCustomerOrgId());
        }
        System.exit(n);
    }

    private static void checkForSignedLicenseAgreement() throws CCRException {
        Config config = UplinkHomeConfig.getInstance();
        String string = config.getProperty("ccr.agreement_signer");
        if (string == null || string.trim().length() == 0) {
            throw new CCRException("Unable to perform the requested operation.\nThe License Agreement has not been accepted.\nRe-run \"$ORACLE_HOME/ccr/bin/emCCR config\" and accept the license agreement.");
        }
    }

    private static void enableHTTPLog() {
        Config config = UplinkHomeConfig.getInstance();
        String string = config.getProperty("httpclient.log.enable");
        if ("true".equals(string)) {
            String string2 = Collector.getConfigHome() + File.separator + "ccr" + File.separator + "log";
            HTTPThreadLogger.init((String)string2);
            HTTPThreadLogger.addThread();
        }
    }

    public static void configLogging() {
        Config config = UplinkHomeConfig.getInstance();
        Properties properties = config.getProperties();
        Logger.init((Properties)properties);
        s_log = Logger.getRootLogger();
    }

    private static void checkPERL5LIB(String[] stringArray) throws CCRException {
        String string = System.getProperty(ENV_PERL5LIB);
        if (string == null || string.trim().equals("")) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringArray[i]);
            }
            if (stringBuffer.length() == 0 || stringBuffer.toString().equals("discover, collect, upload")) {
                stringBuffer = new StringBuffer("collect");
            }
            throw new CCRException(s_bundle.getMessage(CollectorMsgID.PERL5LIB_UNDEF, false, (Object[])new String[]{stringBuffer.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOracleHome() {
        if (m_strOracleHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector == null ? (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector")) : class$oracle$sysman$ccr$collector$Collector;
            synchronized (clazz) {
                if (m_strOracleHome == null) {
                    m_strOracleHome = System.getProperty("ORACLE_HOME");
                }
            }
        }
        if (m_strOracleHome == null) {
            throw new RuntimeException(s_bundle.getMessage(CollectorMsgID.ORACLE_HOME_UNDEF, false));
        }
        return m_strOracleHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigHome() {
        if (m_strConfigHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector == null ? (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector")) : class$oracle$sysman$ccr$collector$Collector;
            synchronized (clazz) {
                if (m_strConfigHome == null) {
                    m_strConfigHome = System.getProperty("ORACLE_CONFIG_HOME");
                }
            }
        }
        if (m_strConfigHome == null) {
            m_strConfigHome = "";
        }
        return m_strConfigHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCCRConfigHome() {
        if (m_strCCRConfigHome == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector == null ? (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector")) : class$oracle$sysman$ccr$collector$Collector;
            synchronized (clazz) {
                if (m_strCCRConfigHome == null) {
                    m_strCCRConfigHome = System.getProperty("CCR_CONFIG_HOME");
                }
            }
        }
        if (m_strCCRConfigHome == null) {
            throw new RuntimeException(s_bundle.getMessage(CollectorMsgID.ORACLE_HOME_UNDEF, false));
        }
        return m_strCCRConfigHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFullPath() {
        if (m_strFullPath == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector == null ? (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector")) : class$oracle$sysman$ccr$collector$Collector;
            synchronized (clazz) {
                if (m_strFullPath == null) {
                    m_strFullPath = System.getProperty("FULL_PATH");
                }
            }
        }
        if (m_strFullPath == null) {
            m_strFullPath = "";
        }
        return m_strFullPath;
    }

    public static void setDisconnected() {
        if (!UplinkHomeConfig.isDisconnected() || Collector.qualifierSpecified(CONNECT_QUALIFIER)) {
            UplinkHomeConfig.setConnected();
        }
    }

    public static boolean isDisconnected() {
        return UplinkHomeConfig.isDisconnected();
    }

    private static void setGridAgentOnTarget() {
        CommandQualifier commandQualifier = Collector.getQualifier(ON_TARGET_QUALIFIER);
        if (commandQualifier != null) {
            OCM_GRID_AGENT_ON_TARGET = commandQualifier.getQualifierValue();
            OCM_GRID_AGENT_REMOTE_MODE = true;
        }
    }

    public static String getGridAgentOnTarget() {
        return OCM_GRID_AGENT_ON_TARGET;
    }

    public static boolean isRemoteGridAgentMode() {
        return OCM_GRID_AGENT_REMOTE_MODE;
    }

    private static String[] parseCommandQualifiers(String[] stringArray) {
        Vector<String> vector = new Vector<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (CommandQualifier.isQualifier(stringArray[i])) {
                CommandQualifier commandQualifier = new CommandQualifier(stringArray[i]);
                s_hashQualifiers.put(commandQualifier.getQualifierName(), commandQualifier);
                continue;
            }
            vector.add(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static void logExceptionChainToStderr(CCRException cCRException) {
        Throwable throwable = cCRException;
        while (throwable != null) {
            System.err.println(throwable.getMessage());
            if (s_log != null) {
                s_log.error(CollectorMsgID.EXIT_ERROR_WRAPPER, (Object[])new String[]{throwable.getMessage()});
            }
            if (throwable instanceof CCRException) {
                CCRException cCRException2 = throwable;
                throwable = cCRException2.getCause();
                continue;
            }
            throwable = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean failOnError() {
        if (m_bFailOnError == null) {
            Class clazz = class$oracle$sysman$ccr$collector$Collector == null ? (class$oracle$sysman$ccr$collector$Collector = Collector.class$("oracle.sysman.ccr.collector.Collector")) : class$oracle$sysman$ccr$collector$Collector;
            synchronized (clazz) {
                if (m_bFailOnError == null) {
                    Config config = UplinkHomeConfig.getInstance();
                    boolean bl = config.getProperty("ccr.fail_on_error", false);
                    String string = "false";
                    if (bl) {
                        string = "true";
                    }
                    m_bFailOnError = Boolean.valueOf(string);
                }
            }
        }
        return m_bFailOnError;
    }

    public static boolean qualifierSpecified(String string) {
        return s_hashQualifiers.containsKey(string);
    }

    public static CommandQualifier getQualifier(String string) {
        return (CommandQualifier)s_hashQualifiers.get(string);
    }

    public static boolean silentMode() {
        return Collector.qualifierSpecified(SILENT_QUALIFIER);
    }

    public static HashMap getQualifierMap() {
        return (HashMap)s_hashQualifiers.clone();
    }

    public static boolean isApplicableForOcm(String string) {
        return Collector.isApplicableForAgentMode(string, OCM);
    }

    public static boolean isApplicableForGC(String string) {
        return Collector.isApplicableForAgentMode(string, GC);
    }

    public static String getCCRRoot() {
        String string = System.getProperty("CCR_HOME");
        if (string == null) {
            return Collector.getOracleHome();
        }
        return string.substring(0, string.length() - 4);
    }

    private static boolean isApplicableForAgentMode(String string, String string2) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ReadAgentSeed
    implements Runnable {
        public void run() {
            try {
                int n;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                s_log.debug((Object)"Reading agent see from stdin");
                String string = bufferedReader.readLine();
                if (string != null && (n = string.indexOf("=")) != -1 && string.length() > n + 1) {
                    m_readAgentSeed = true;
                    String string2 = string.substring(n + 1);
                    AgentConfig.setAgentSeed((String)string2);
                    s_log.debug((Object)("Read agent seed: " + string2));
                }
            }
            catch (IOException iOException) {
                s_log.debug((Object)("Error reading agent seed: " + iOException.getMessage()));
            }
        }
    }
}

