/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector;

import java.io.File;
import java.util.List;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.CollectorMsgID;
import oracle.sysman.ccr.collector.TargetHome;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.dsf.CentralProps;
import oracle.sysman.ccr.dsf.Dsf;
import oracle.sysman.ccr.dsf.DsfConfigHomeNotFoundException;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.DsfTargetHome;
import oracle.sysman.ccr.dsf.OCMCollector;

class TargetCollectorManager {
    private CentralProps mCentralProps;
    private Dsf mDsf;
    private static MessageBundle mMessageBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.Collector");
    private static final String FS = File.separator;

    TargetCollectorManager(Dsf dsf, TargetHomeManager targetHomeManager) {
        this.mDsf = dsf;
        if (this.mDsf.isOperational()) {
            this.mCentralProps = new CentralProps(dsf, CentralProps.getMyCentralPropsFile().getAbsolutePath());
        }
    }

    void designateAsCentralCollector(String string, String string2) throws CCRException, DsfInitializationException {
        if (!this.mDsf.isOperational()) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.CENTRAL_COLLECTOR_DESIGNATION_NOT_POSSIBLE, false));
        }
        try {
            String string3 = string.substring(0, string.lastIndexOf("/ccr"));
            this.mCentralProps.setCentralCol(this.mDsf, this.mDsf.getInputSourcesID(), string3, string2);
            this.mCentralProps.removeAnonymousColForInputSourcesID(this.mDsf);
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfInitializationException);
        }
    }

    void relinquishCollectorDesignation(String string, String string2) throws CCRException {
        try {
            String string3 = string.substring(0, string.lastIndexOf(FS + "ccr"));
            this.mCentralProps.removeCentralCol(this.mDsf, string3, string2);
            this.mCentralProps.removeAnonymousCol(this.mDsf, string3, string2);
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfInitializationException);
        }
    }

    void removeFromCentralProps(String string, String string2) throws CCRException {
        try {
            this.mCentralProps.removeFromCentralProps(this.mDsf, string.substring(0, string.lastIndexOf("/ccr")), string2);
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfInitializationException);
        }
    }

    private OCMCollector findWorkingAnonymousCollector(List list) throws DsfInitializationException {
        String string = this.mDsf.getInputSourcesID();
        OCMCollector oCMCollector = this.findWorkingDesignatedCollector(list, this.mCentralProps.getAnonymousColCCR_CONFIG_HOME(this.mDsf, string), this.mCentralProps.getAnonymousColCCR_ROOT(this.mDsf, string));
        return oCMCollector;
    }

    private boolean centralCollectorAlreadyDesignated() throws DsfInitializationException {
        String string = this.mDsf.getInputSourcesID();
        String string2 = this.mCentralProps.getCentralColCCR_ROOT(this.mDsf, string);
        if (string2 == null) {
            string = this.mDsf.getDefaultPlaceholderInputSourceID();
            string2 = this.mCentralProps.getCentralColCCR_ROOT(this.mDsf, string);
        }
        return string2 != null;
    }

    boolean isCentralCollector(String string, String string2) {
        try {
            String string3 = this.mDsf.getInputSourcesID();
            return string.equals(this.mCentralProps.getCentralColCCR_ROOT(this.mDsf, string3) + FS + "ccr") && string2.equals(this.mCentralProps.getCentralColCCR_CONFIG_HOME(this.mDsf, string3));
        }
        catch (DsfInitializationException dsfInitializationException) {
            return false;
        }
    }

    boolean isAnonymousCollector(String string, String string2) {
        try {
            String string3 = this.mDsf.getInputSourcesID();
            return string.equals(this.mCentralProps.getAnonymousColCCR_ROOT(this.mDsf, string3) + FS + "ccr") && string2.equals(this.mCentralProps.getAnonymousColCCR_CONFIG_HOME(this.mDsf, string3));
        }
        catch (DsfInitializationException dsfInitializationException) {
            return false;
        }
    }

    boolean yieldToOtherCollectors(TargetHome targetHome) throws CCRException {
        String string = CentralProps.getCentralPropsFilePath((String)targetHome.getLocation());
        String string2 = CentralProps.getCentralPropsOwner((String)targetHome.getLocation());
        if (string2.equals(System.getProperty("user.name"))) {
            return false;
        }
        try {
            if (this.mCentralProps.hasSameCentralCollectorAsMe(this.mDsf, this.mDsf.getInputSourcesID(), string)) {
                return true;
            }
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException("Could not initialize Dsf. ", (Throwable)dsfInitializationException);
        }
        return false;
    }

    boolean designateAsAnonymousCollector(List list, TargetHome targetHome, String string, String string2) throws CCRException, DsfInitializationException {
        if (this.mDsf.inputSourcesIDIsPlaceholder() || this.centralCollectorAlreadyDesignated() || this.findWorkingAnonymousCollector(list) != null) {
            return false;
        }
        if (!targetHome.canCollectorConfigurationBeDetermined()) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.COLLECTOR_NOT_SETUP_ERROR, false));
        }
        OCMCollector oCMCollector = targetHome.getCollectorWithConfigHome(string2);
        try {
            if (!oCMCollector.isDisconnected()) {
                this.mCentralProps.setAnonymousCol(this.mDsf, oCMCollector.getLocation(), oCMCollector.getConfigHome());
                return true;
            }
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfInitializationException);
        }
        catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfConfigHomeNotFoundException);
        }
        return false;
    }

    void forceAsAnonymousCollector(String string, String string2) throws CCRException {
        try {
            this.mCentralProps.setAnonymousCol(this.mDsf, string.substring(0, string.lastIndexOf("/ccr")), string2);
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.DESIGNATION_ERROR, false), (Throwable)dsfInitializationException);
        }
    }

    boolean removeAsAnonymousCollector(String string, String string2) {
        try {
            this.mCentralProps.removeAnonymousCol(this.mDsf, string.substring(0, string.lastIndexOf("/ccr")), string2);
        }
        catch (DsfInitializationException dsfInitializationException) {
            return false;
        }
        return true;
    }

    static void syncCentralProperty() throws CCRException {
        CentralProps centralProps = new CentralProps(null, CentralProps.getMyCentralPropsFile().getAbsolutePath());
        try {
            centralProps.setCCR_CONFIG_HOME(Collector.getCCRRoot(), System.getProperty("CCR_CONFIG_HOME"));
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.COLLECTOR_NOT_SETUP_ERROR, false));
        }
    }

    static boolean isThisTheRunningCollector(OCMCollector oCMCollector) {
        return oCMCollector != null && oCMCollector.getConfigHome().equals(System.getProperty("CCR_CONFIG_HOME"));
    }

    private OCMCollector findWorkingDesignatedCollector(List list, String string, String string2) {
        if (string == null) {
            return null;
        }
        OCMCollector oCMCollector = this.getCollectorByRootAndCch(list, string2, string);
        if (oCMCollector == null) {
            try {
                DsfTargetHome dsfTargetHome = this.mDsf.createTargetHome(string2, "Standalone");
                oCMCollector = dsfTargetHome.getCollectorWithConfigHome(string);
            }
            catch (DsfInitializationException dsfInitializationException) {
                // empty catch block
            }
        }
        try {
            if (oCMCollector != null && !oCMCollector.isDisconnected() && oCMCollector.testConnection()) {
                return oCMCollector;
            }
        }
        catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private OCMCollector getCollectorByRootAndCch(List list, String string, String string2) {
        return TargetHome.getCollectorByRootAndCch(list, string, string2);
    }
}

