/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.CollectorMsgID;
import oracle.sysman.ccr.collector.TargetHomeManager;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.dsf.Dsf;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.DsfTargetHome;
import oracle.sysman.ccr.dsf.OCMCollector;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.UplinkPath;

public class TargetHome {
    private static final String FS = File.separator;
    private TargetHomeManager mTargetHomeMan;
    private DsfTargetHome mDsfTargetHome;
    private static final String BEA_HOME_ENV_VAR = "BEA_HOME";
    private static final String WL_HOME_ENV_VAR = "WL_HOME";
    private static final String COMPS_FILE = "inventory" + FS + "ContentsXML" + FS + "comps.xml";
    private static Logger mLog = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$TargetHome == null ? (class$oracle$sysman$ccr$collector$TargetHome = TargetHome.class$("oracle.sysman.ccr.collector.TargetHome")) : class$oracle$sysman$ccr$collector$TargetHome));
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$TargetHome;

    TargetHome(DsfTargetHome dsfTargetHome, TargetHomeManager targetHomeManager) {
        this.mDsfTargetHome = dsfTargetHome;
        this.mTargetHomeMan = targetHomeManager;
    }

    public static List populateTargetHomes(Dsf dsf, TargetHomeManager targetHomeManager) throws DsfInitializationException, IOException, CCRException {
        Object object;
        File file;
        Object object2;
        if (UplinkPath.isGCMode()) {
            return new ArrayList();
        }
        ArrayList<Object> arrayList = null;
        arrayList = !targetHomeManager.isCentralCollector() && targetHomeManager.isForcedNotToBeAnonymousCentralCollector() ? new ArrayList<Object>() : dsf.getOwnedTargetHomesWithOCMComponent();
        String string = Collector.getCCRRoot();
        File file2 = new File(string).getParentFile();
        boolean bl = false;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<DsfTargetHome> arrayList3 = new ArrayList<DsfTargetHome>();
        if (file2 != null) {
            hashMap.put(file2.getAbsolutePath(), file2);
        }
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (DsfTargetHome)object3.next();
            file = object2.determineIfFMWDir();
            if (file != null) {
                if (!object2.isFmwComponentWithItsOwnCollector() && !string.equals(object2.getLocation())) {
                    arrayList2.add(object2);
                }
                if ((object = file.getParentFile()) != null && !hashMap.containsKey(((File)object).getAbsolutePath())) {
                    File file3 = new File(((File)object).getAbsolutePath() + FS + "utils");
                    if (file3.exists()) {
                        arrayList3.add(dsf.createTargetHome(file3.getAbsolutePath(), "Fusion Middleware Home"));
                        hashMap.put(((File)object).getAbsolutePath(), object);
                    } else {
                        mLog.error(CollectorMsgID.FMW_HOME_COLLECTOR_NOT_FOUND);
                    }
                }
            }
            if (!string.equals(object2.getLocation())) continue;
            bl = true;
        }
        if (!bl) {
            arrayList.add(dsf.createTargetHome(string, "Standalone Collector"));
        }
        arrayList.addAll(arrayList3);
        arrayList.removeAll(arrayList2);
        object3 = new ArrayList();
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            file = (DsfTargetHome)object2.next();
            object = new TargetHome((DsfTargetHome)file, targetHomeManager);
            object3.add(object);
        }
        return object3;
    }

    public HashMap setemCCRenvSystemProps(String string, String string2) throws CCRException {
        OCMCollector oCMCollector = null;
        if (string2 != null) {
            oCMCollector = this.getDsfTargetHome().getCollectorWithConfigHome(string2);
        }
        HashMap hashMap = this.setemCCRenvSystemProps(oCMCollector);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap setemCCRenvSystemProps(OCMCollector oCMCollector) throws CCRException {
        HashMap hashMap = new HashMap();
        TargetHomeManager.getemCCRenvSystemProps(hashMap);
        TargetHomeManager.clearemCCRenvSystemProps();
        this.readAndSetemCCRenvSystemProps(oCMCollector);
        System.setProperty("ORACLE_HOME", this.mDsfTargetHome.getLocation());
        System.setProperty("LL_ORACLE_HOME", this.mDsfTargetHome.getLocation());
        if (System.getProperty(BEA_HOME_ENV_VAR) != null) return hashMap;
        try {
            File file = this.mDsfTargetHome.determineIfFMWDir();
            if (file == null) return hashMap;
            String string = file.getParent();
            System.setProperty(BEA_HOME_ENV_VAR, string);
            File file2 = new File(string);
            if (!file2.isDirectory()) return hashMap;
            File[] fileArray = file2.listFiles();
            if (fileArray.length <= 0) return hashMap;
            int n = 0;
            while (n < fileArray.length) {
                File file3;
                if (fileArray[n].isDirectory() && (file3 = new File(fileArray[n].getPath() + FS + COMPS_FILE)).exists()) {
                    FilterInputStream filterInputStream = null;
                    try {
                        String string2;
                        filterInputStream = new DataInputStream(new FileInputStream(file3));
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(filterInputStream));
                        boolean bl = false;
                        while ((string2 = bufferedReader.readLine()) != null && !string2.endsWith("</TL_LIST>")) {
                            if (!bl) {
                                bl = string2.endsWith("<TL_LIST>");
                                continue;
                            }
                            if (string2.indexOf("<COMP NAME=\"WebLogic Server\"") <= 0) continue;
                            System.setProperty(WL_HOME_ENV_VAR, fileArray[n].getPath());
                            HashMap hashMap2 = hashMap;
                            return hashMap2;
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ++n;
            }
            return hashMap;
        }
        catch (DsfInitializationException dsfInitializationException) {
            throw new CCRException("Internal Error", (Throwable)dsfInitializationException);
        }
    }

    public List getCollectors() {
        return this.mDsfTargetHome.getCollectors();
    }

    public OCMCollector getCollectorWithConfigHome(String string) {
        return this.mDsfTargetHome.getCollectorWithConfigHome(string);
    }

    public boolean canCollectorConfigurationBeDetermined() {
        return this.mDsfTargetHome.canCollectorConfigurationBeDetermined();
    }

    public boolean isComponentOfThisName(String string) {
        return this.mDsfTargetHome.isComponentOfThisName(string);
    }

    public boolean isCollectorSetup() {
        return this.mDsfTargetHome.isCollectorSetup();
    }

    public String getName() {
        return this.mDsfTargetHome.getName();
    }

    public File determineIfFMWDir() throws DsfInitializationException {
        return this.mDsfTargetHome.determineIfFMWDir();
    }

    public boolean hasDisconnectedCollector() {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        arrayList.add(this.mDsfTargetHome);
        return !DsfTargetHome.getDisconnectedCollectors(arrayList).isEmpty();
    }

    public boolean hasUnauthenticatedCollector() {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        arrayList.add(this.mDsfTargetHome);
        return !DsfTargetHome.getUnauthenticatedCollectors(arrayList).isEmpty();
    }

    public boolean hasUnknownCollector() {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        arrayList.add(this.mDsfTargetHome);
        return !DsfTargetHome.getTargetHomesWithUnknownCollectors(arrayList).isEmpty();
    }

    public String toString() {
        return this.mDsfTargetHome.toString();
    }

    public DsfTargetHome getDsfTargetHome() {
        return this.mDsfTargetHome;
    }

    public static List getUnauthenticatedCollectors(List list) {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetHome targetHome = (TargetHome)iterator.next();
            arrayList.add(targetHome.getDsfTargetHome());
        }
        return DsfTargetHome.getUnauthenticatedCollectors(arrayList);
    }

    public static List getDisconnectedCollectors(List list) {
        ArrayList<DsfTargetHome> arrayList = new ArrayList<DsfTargetHome>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TargetHome targetHome = (TargetHome)iterator.next();
            arrayList.add(targetHome.getDsfTargetHome());
        }
        return DsfTargetHome.getDisconnectedCollectors(arrayList);
    }

    public String getLocation() {
        return this.mDsfTargetHome.getLocation();
    }

    public static OCMCollector getCollectorByRootAndCch(List list, String string, String string2) {
        DsfTargetHome dsfTargetHome;
        OCMCollector oCMCollector = null;
        for (int i = 0; !(i >= list.size() || (dsfTargetHome = ((TargetHome)list.get(i)).getDsfTargetHome()).canCollectorConfigurationBeDetermined() && dsfTargetHome.getLocation().equals(string) && (oCMCollector = dsfTargetHome.getCollectorWithConfigHome(string2)) != null); ++i) {
        }
        return oCMCollector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAndSetemCCRenvSystemProps(OCMCollector oCMCollector) {
        if (oCMCollector == null) return;
        if (oCMCollector.getConfigHome() == null) return;
        File file = new File(FileSpec.catfile((String[])new String[]{oCMCollector.getConfigHome(), "config", "emCCRenv"}));
        if (!file.exists()) return;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Set set = ((Hashtable)properties).keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = properties.getProperty(string).trim();
                    if (properties.getProperty(string).trim().equals("")) continue;
                    for (int i = 0; i < TargetHomeManager.mTargetHomeEnvVars.length; ++i) {
                        String string3 = TargetHomeManager.mTargetHomeEnvVars[i];
                        if (!string.equals(string3)) continue;
                        System.setProperty(string, string2);
                    }
                }
                Object var12_13 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException("Could not find emCCREnv: " + fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not find emCCREnv: " + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (fileInputStream == null) throw throwable;
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream == null) return;
        fileInputStream.close();
        return;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

