/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.CollectorMsgID;
import oracle.sysman.ccr.collector.TargetCollectorManager;
import oracle.sysman.ccr.collector.TargetHome;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;
import oracle.sysman.ccr.dsf.CentralProps;
import oracle.sysman.ccr.dsf.Dsf;
import oracle.sysman.ccr.dsf.DsfConfigHomeNotFoundException;
import oracle.sysman.ccr.dsf.DsfInitializationException;
import oracle.sysman.ccr.dsf.OCMCollector;
import oracle.sysman.ccr.util.FileSpec;
import oracle.sysman.ccr.util.Process;
import oracle.sysman.ccr.util.UplinkPath;

public class TargetHomeManager {
    public static final String[] mTargetHomeEnvVars = new String[]{"CLUSTER_NAME", "CRS_HOME", "LD_PRELOAD", "TZ", "ORACLE_HOME", "LL_ORACLE_HOME", "ORACLE_CONFIG_HOME", "ORAINST_LOC", "TNS_ADMIN", "IAS_CONFIG_HOME", "WL_HOME", "BEA_HOME", "ORACLE_INSTANCE"};
    public static final String cchAttribute = "CCR_CONFIG_HOME";
    public static final String locationAttribute = "LOCATION";
    public static final String targetHomesBeginTag = "<TargetHomes>";
    public static final String targetHomesEndTag = "</TargetHomes>";
    public static final String targetHomeTag = "TargetHome";
    public static final String targetHomeEndTag = "</TargetHome>";
    public static final String ccrDesignatedCollectorIsCollectingOtherHomes = "CCR_DESIGNATED_COLLECTOR_IS_COLLECTING_OTHER_HOMES";
    public static final String ccrCentralPropertiesCCHForCollectorInOH = "CCR_CENTRAL_PROPERTIES_CCH_FOR_COLLECTOR_IN_OH";
    public static final String CCR_I_AM_CENTRAL_COLLECTOR = "CCR_I_AM_CENTRAL_COLLECTOR";
    private Dsf mDsf;
    private List mTargetHomes;
    private TargetCollectorManager mTargetCollectorMan;
    private HashMap mTargetLocationToTargetHome;
    private boolean mIsAnonymousCollector;
    private boolean mIsCentralCollector;
    private static MessageBundle mMessageBundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.Collector");
    private static final String FS = File.separator;
    private static Logger mLog = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$TargetHomeManager == null ? (class$oracle$sysman$ccr$collector$TargetHomeManager = TargetHomeManager.class$("oracle.sysman.ccr.collector.TargetHomeManager")) : class$oracle$sysman$ccr$collector$TargetHomeManager));
    public static String ccrtest_do_not_silence_anonymous_central_collector = "ccrtest_do_not_silence_anonymous_central_collector";
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$TargetHomeManager;

    private TargetHomeManager() {
    }

    public static TargetHomeManager createTargetHomeManager() {
        TargetHomeManager targetHomeManager = new TargetHomeManager();
        targetHomeManager.mDsf = Dsf.beginSession();
        targetHomeManager.mTargetCollectorMan = new TargetCollectorManager(targetHomeManager.mDsf, targetHomeManager);
        return targetHomeManager;
    }

    public static void DestroyTargetHomeManager(TargetHomeManager targetHomeManager) throws DsfInitializationException {
        targetHomeManager.mDsf.endSession();
    }

    public static boolean isThisTheRunningCollector(OCMCollector oCMCollector) {
        return TargetCollectorManager.isThisTheRunningCollector(oCMCollector);
    }

    public void populateTargetHomes(boolean bl) throws DsfInitializationException, IOException, CCRException {
        this.determineCentralDesignations();
        this.mTargetHomes = TargetHome.populateTargetHomes(this.mDsf, this);
        this.setAnonymousDesignation(bl);
    }

    public boolean isDesignatedCollector() {
        return this.mIsAnonymousCollector || this.mIsCentralCollector;
    }

    public boolean designateAsAnonymousCollector(String string, String string2) throws CCRException, DsfInitializationException {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mTargetCollectorMan.designateAsAnonymousCollector(this.mTargetHomes, this.getTargetHome(string), string, string2);
    }

    public void forceAsAnonymousCollector(String string, String string2) throws CCRException, DsfInitializationException {
        if (!this.mDsf.isOperational()) {
            return;
        }
        this.mTargetCollectorMan.forceAsAnonymousCollector(string, string2);
    }

    public boolean removeAsAnonymousCollector(String string, String string2) throws CCRException, DsfInitializationException {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mTargetCollectorMan.removeAsAnonymousCollector(string, string2);
    }

    public void designateAsCentralCollector(String string, String string2) throws CCRException, DsfInitializationException {
        if (!this.mDsf.isOperational()) {
            throw new CCRException(mMessageBundle.getMessage(CollectorMsgID.CENTRAL_COLLECTOR_DESIGNATION_NOT_POSSIBLE, false));
        }
        this.mTargetCollectorMan.designateAsCentralCollector(string, string2);
    }

    public void relinquishCollectorDesignation(String string, String string2) throws CCRException {
        if (!this.mDsf.isOperational()) {
            return;
        }
        this.mTargetCollectorMan.relinquishCollectorDesignation(string, string2);
    }

    public void removeFromCentralProps(String string, String string2) throws CCRException {
        if (!this.mDsf.isOperational()) {
            return;
        }
        this.mTargetCollectorMan.removeFromCentralProps(string, string2);
    }

    public List getTargetHomes() {
        return this.mTargetHomes;
    }

    public List getTargetHomesNotSetup() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public List getUnauthenticatedCollectors() {
        return TargetHome.getUnauthenticatedCollectors(this.mTargetHomes);
    }

    public List getDisconnectedCollectors() {
        return TargetHome.getDisconnectedCollectors(this.mTargetHomes);
    }

    public TargetHome getTargetHome(String string) {
        Iterator iterator = this.mTargetHomes.iterator();
        while (iterator.hasNext()) {
            TargetHome targetHome = (TargetHome)iterator.next();
            if (!string.equals(targetHome.getLocation() + FS + "ccr")) continue;
            return targetHome;
        }
        return null;
    }

    public static void getemCCRenvSystemProps(HashMap hashMap) {
        for (int i = 0; i < mTargetHomeEnvVars.length; ++i) {
            String string = mTargetHomeEnvVars[i];
            String string2 = string.equals("LL_ORACLE_HOME") ? System.getProperty("ORACLE_HOME") : System.getProperty(string);
            if (string2 == null) continue;
            hashMap.put(string, string2);
        }
    }

    public static void getTargetHomeSystemProps(HashMap hashMap) {
        TargetHomeManager.getemCCRenvSystemProps(hashMap);
        if (System.getProperty(ccrDesignatedCollectorIsCollectingOtherHomes) != null) {
            hashMap.put(ccrDesignatedCollectorIsCollectingOtherHomes, "true");
            hashMap.put(ccrCentralPropertiesCCHForCollectorInOH, System.getProperty(ccrCentralPropertiesCCHForCollectorInOH));
        }
    }

    public static void resetemCCRenvSystemProps(HashMap hashMap) {
        TargetHomeManager.clearemCCRenvSystemProps();
        TargetHomeManager.setEnvVars(hashMap);
    }

    public static void clearemCCRenvSystemProps() {
        for (int i = 0; i < mTargetHomeEnvVars.length; ++i) {
            ((Hashtable)System.getProperties()).remove(mTargetHomeEnvVars[i]);
        }
    }

    public static void syncCentralProperty() throws CCRException {
        if (!CentralProps.platformSupportsCentralProperties()) {
            return;
        }
        TargetCollectorManager.syncCentralProperty();
    }

    public boolean isCentralCollector(String string, String string2) {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mTargetCollectorMan.isCentralCollector(string, string2);
    }

    public boolean isCentralCollector() {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mIsCentralCollector;
    }

    public boolean isAnonymousCollector(String string, String string2) {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mTargetCollectorMan.isAnonymousCollector(string, string2);
    }

    public boolean isAnonymousCollector() {
        if (!this.mDsf.isOperational()) {
            return false;
        }
        return this.mIsAnonymousCollector;
    }

    public boolean isForcedNotToBeAnonymousCentralCollector() {
        if (!CentralProps.platformSupportsCentralProperties()) {
            return true;
        }
        CentralProps centralProps = new CentralProps(null, CentralProps.getMyCentralPropsFile().getAbsolutePath());
        return System.getProperty("ccrtest_do_not_designate_as_central_anonymous_collector") != null || centralProps.isAnonymousCentralCollectorDisabled();
    }

    public void prepareForCollection() {
        this.mTargetLocationToTargetHome = new HashMap();
        Iterator iterator = this.mTargetHomes.iterator();
        while (iterator.hasNext()) {
            TargetHome targetHome = (TargetHome)iterator.next();
            this.mTargetLocationToTargetHome.put(targetHome.getLocation(), targetHome);
        }
    }

    public TargetHome locationToTargetHome(String string) {
        return (TargetHome)this.mTargetLocationToTargetHome.get(string);
    }

    public boolean isCollectingThisHomeAsAnonymousCollector(String string) {
        String string2 = System.getProperty("CCR_HOME");
        return !string2.equals(string) && this.mIsAnonymousCollector;
    }

    public void processOtherTargetHomesToBeDiscovered(ITargetHomeCollectionVisitor iTargetHomeCollectionVisitor, boolean bl) throws CCRException {
        if (!this.isDesignatedCollector()) {
            return;
        }
        System.setProperty(ccrDesignatedCollectorIsCollectingOtherHomes, "true");
        Iterator iterator = this.mTargetHomes.iterator();
        while (iterator.hasNext()) {
            TargetHome targetHome = (TargetHome)iterator.next();
            if (!this.shouldBeCollectedInThisRelease(targetHome) || targetHome.getLocation().equals(Collector.getCCRRoot()) || this.yieldToOtherCollectors(targetHome)) continue;
            this.createStateDir(targetHome.getLocation());
            if (targetHome == this.getTargetHome(System.getProperty("CCR_HOME"))) continue;
            if (!targetHome.isCollectorSetup()) {
                System.setProperty(ccrCentralPropertiesCCHForCollectorInOH, targetHome.getLocation() + FS + "ccr");
                this.callCollectionVisitor(iTargetHomeCollectionVisitor, targetHome, null, bl);
                continue;
            }
            List list = targetHome.getCollectors();
            if (bl && targetHome.hasUnknownCollector()) {
                this.callCollectionVisitor(iTargetHomeCollectionVisitor, targetHome, null, bl);
                continue;
            }
            if (list == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                OCMCollector oCMCollector = (OCMCollector)iterator2.next();
                try {
                    if (this.mIsCentralCollector && oCMCollector.isUnauthenticated()) {
                        if (!bl) {
                            oCMCollector.shutdown();
                        }
                        System.setProperty(ccrCentralPropertiesCCHForCollectorInOH, oCMCollector.getConfigHome());
                        this.callCollectionVisitor(iTargetHomeCollectionVisitor, targetHome, oCMCollector, bl);
                        continue;
                    }
                    if (!oCMCollector.isDisconnected()) continue;
                    System.setProperty(ccrCentralPropertiesCCHForCollectorInOH, oCMCollector.getConfigHome());
                    this.callCollectionVisitor(iTargetHomeCollectionVisitor, targetHome, oCMCollector, bl);
                }
                catch (DsfConfigHomeNotFoundException dsfConfigHomeNotFoundException) {
                    throw new CCRException("Internal Error", (Throwable)dsfConfigHomeNotFoundException);
                }
            }
        }
        ((Hashtable)System.getProperties()).remove(ccrDesignatedCollectorIsCollectingOtherHomes);
        ((Hashtable)System.getProperties()).remove(ccrCentralPropertiesCCHForCollectorInOH);
    }

    public boolean shouldBeCollectedInThisRelease(TargetHome targetHome) {
        if (System.getProperty("ccrtest_maxupload_support_all_targets") != null) {
            return true;
        }
        try {
            File file = targetHome.determineIfFMWDir();
            if (file != null) {
                return file.exists();
            }
        }
        catch (DsfInitializationException dsfInitializationException) {
            // empty catch block
        }
        return targetHome.isComponentOfThisName("oracle.server");
    }

    public String getInputSourcesID() {
        return this.mDsf.getInputSourcesID();
    }

    private void setAnonymousDesignation(boolean bl) {
    }

    private void determineCentralDesignations() {
        if (UplinkPath.isGCMode()) {
            return;
        }
        String string = System.getProperty("CCR_HOME");
        String string2 = System.getProperty(cchAttribute);
        this.mIsAnonymousCollector = this.isAnonymousCollector(string, string2);
        this.mIsCentralCollector = this.isCentralCollector(string, string2);
        if (this.mIsCentralCollector) {
            System.setProperty(CCR_I_AM_CENTRAL_COLLECTOR, "TRUE");
        }
    }

    private boolean yieldToOtherCollectors(TargetHome targetHome) throws CCRException {
        if (!"root".equals(System.getProperty("user.name"))) {
            return false;
        }
        return this.mTargetCollectorMan.yieldToOtherCollectors(targetHome);
    }

    private void callCollectionVisitor(ITargetHomeCollectionVisitor iTargetHomeCollectionVisitor, TargetHome targetHome, OCMCollector oCMCollector, boolean bl) throws CCRException {
        HashMap hashMap = null;
        if (!bl) {
            hashMap = targetHome.setemCCRenvSystemProps(oCMCollector);
        }
        iTargetHomeCollectionVisitor.processTargetHomeDiscovery(targetHome, oCMCollector);
        if (!bl) {
            TargetHomeManager.resetemCCRenvSystemProps(hashMap);
        }
    }

    private static void setEnvVars(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            System.setProperty(string, string2);
        }
    }

    private void createStateDir(String string) {
        File file = new File(string + FS + "ccr" + FS + "state");
        if (file.exists()) {
            return;
        }
        String[] stringArray = new String[]{FileSpec.catfile((String[])new String[]{System.getProperty("CCR_HOME"), "bin", System.getProperty("os.name").startsWith("Windows") ? "makeDirSameOwner.vbs" : "makeDirSameOwner.sh"}), file.getParentFile().getAbsolutePath(), "state"};
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Process process = Process.exec((String[])stringArray, null, null, (String)"10");
            if (process.waitFor(stringBuffer) == 0) {
                return;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            mLog.error(CollectorMsgID.DB_INSTRUMENTATION_DIR_CREATION_ERROR, (Throwable)iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ITargetHomeCollectionVisitor {
        public void processTargetHomeDiscovery(TargetHome var1, OCMCollector var2) throws CCRException;
    }
}

