/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import java.util.Properties;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cli.CanUploadCmd;
import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.CollectorCliCmd;
import oracle.sysman.ccr.collector.cli.ConfigDiagcheckCmd;
import oracle.sysman.ccr.collector.cli.DisableDiagchecksCmd;
import oracle.sysman.ccr.collector.cli.DisableTargetCmd;
import oracle.sysman.ccr.collector.cli.EnableDiagchecksCmd;
import oracle.sysman.ccr.collector.cli.EnableTargetCmd;
import oracle.sysman.ccr.collector.cli.InterruptException;
import oracle.sysman.ccr.collector.cli.MandatoryUpdatesException;
import oracle.sysman.ccr.collector.cli.StatusDiagchecksCmd;
import oracle.sysman.ccr.collector.cli.UpdatePropertyCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkSystemConfigWriter;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.common.logging.Logger;

public class Cli {
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cli.Cli");
    public static final int ERR_COMMAND_PROCESSING = 1;
    public static final int ERR_MANDATORY_UPDATES = 55;
    public static final String DISABLE_TARGET = "disable_target";
    public static final String ENABLE_TARGET = "enable_target";
    public static final String DELETE_TARGET = "delete_target";
    public static final String ENABLE_DIAGCHECKS = "enable_diagchecks";
    public static final String DISABLE_DIAGCHECKS = "disable_diagchecks";
    public static final String STATUS_DIAGCHECKS = "status_diagchecks";

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                throw new CommandException(s_bundle.getMessage(CliMsgID.NO_ARGS_ERR, false));
            }
            Logger.init((Properties)UplinkHomeConfig.getInstance().getProperties());
            UplinkSystemConfigWriter.getInstance();
            Collector.setDisconnected();
            CollectorCliCmd collectorCliCmd = Cli.getCollectorCmdInstance(stringArray[0]);
            collectorCliCmd.executeCommand(stringArray);
            if (collectorCliCmd.feedbackNeeded()) {
                System.out.println(s_bundle.getMessage(CliMsgID.COMMAND_SUCCESSFUL, false, (Object[])new String[]{stringArray[0].toUpperCase()}));
            }
        }
        catch (InterruptException interruptException) {
            System.out.println(((Throwable)((Object)interruptException)).getMessage());
        }
        catch (MandatoryUpdatesException mandatoryUpdatesException) {
            Collector.logExceptionChainToStderr(mandatoryUpdatesException);
            System.exit(55);
        }
        catch (CCRException cCRException) {
            Collector.logExceptionChainToStderr(cCRException);
            System.exit(1);
        }
    }

    public static CollectorCliCmd getCollectorCmdInstance(String string) throws CommandException {
        CollectorCliCmd collectorCliCmd = null;
        if (UpdatePropertyCmd.isMyCommand(string)) {
            collectorCliCmd = new UpdatePropertyCmd();
        } else if (string.equalsIgnoreCase(DISABLE_TARGET)) {
            collectorCliCmd = new DisableTargetCmd();
        } else if (string.equalsIgnoreCase(ENABLE_TARGET)) {
            collectorCliCmd = new EnableTargetCmd();
        } else if (string.equalsIgnoreCase(DISABLE_DIAGCHECKS)) {
            collectorCliCmd = new DisableDiagchecksCmd();
            collectorCliCmd.setFeedbackNeeded(false);
        } else if (string.equalsIgnoreCase(ENABLE_DIAGCHECKS)) {
            collectorCliCmd = new EnableDiagchecksCmd();
            collectorCliCmd.setFeedbackNeeded(false);
        } else if (CanUploadCmd.isMyCommand(string)) {
            collectorCliCmd = new CanUploadCmd();
        } else if (ConfigDiagcheckCmd.isMyCommand(string)) {
            collectorCliCmd = new ConfigDiagcheckCmd();
            collectorCliCmd.setFeedbackNeeded(false);
        } else if (string.equalsIgnoreCase(STATUS_DIAGCHECKS)) {
            collectorCliCmd = new StatusDiagchecksCmd();
            collectorCliCmd.setFeedbackNeeded(false);
        } else {
            throw new CommandException(s_bundle.getMessage(CliMsgID.INVAL_COMMAND_ERR, false, (Object[])new String[]{string}));
        }
        return collectorCliCmd;
    }
}

