/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.CollectorCliCmd;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.exception.CCRException;

public class DisableDiagchecksCmd
extends CollectorCliCmd {
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cli.Cli");

    public void executeCommand(String[] stringArray) throws CCRException {
        try {
            ConfigWriter configWriter = UplinkHomeConfigWriter.getInstance();
            String string = configWriter.propertyValue("diagcheck.disable");
            if (string != null && Boolean.valueOf(string).booleanValue()) {
                System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_ALREADY_DISABLED, false));
            } else {
                configWriter.setProperty("diagcheck.disable", "true");
                configWriter.persistProperties();
                System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_DISABLED, false));
            }
        }
        catch (FileReadException fileReadException) {
            throw new CCRException("Failed to open collector.properties file", (Throwable)fileReadException);
        }
        catch (FileWriteException fileWriteException) {
            throw new CCRException("Failed to write property to collector.properties file", (Throwable)fileWriteException);
        }
    }
}

