/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.InterruptException;
import oracle.sysman.ccr.collector.cli.TargetCmd;
import oracle.sysman.ccr.collector.cli.TargetCmdException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;

public class DisableTargetCmd
extends TargetCmd {
    public void executeCommand(String[] stringArray) throws TargetCmdException, InterruptException {
        TargetManager targetManager = TargetManager.getInstance();
        Vector vector = targetManager.getTargets(true);
        if (vector.isEmpty()) {
            this.setFeedbackNeeded(false);
            System.out.println(TargetCmd.s_bundle.getMessage(CliMsgID.NO_TARGETS_TO_ACT_ON, false, (Object[])new String[]{this.getCommandName()}));
            return;
        }
        this.quickSort(vector, 0, vector.size() - 1);
        Target[] targetArray = null;
        if (stringArray.length == 1) {
            targetArray = this.getSelectedTargets(vector);
        } else {
            if (stringArray.length > 2) {
                throw new TargetCmdException(TargetCmd.s_bundle.getMessage(CliMsgID.TOO_MANY_TARGETS, false));
            }
            Target target = null;
            int n = stringArray[1].indexOf(":");
            if (n < 0) {
                throw new TargetCmdException(TargetCmd.s_bundle.getMessage(CliMsgID.INVALID_TARGET, false));
            }
            if (stringArray[1].indexOf(":") == stringArray[1].lastIndexOf(":")) {
                String string = stringArray[1].substring(0, n);
                String string2 = stringArray[1].substring(n + 1);
                target = targetManager.getTargetByNameType(string, string2);
            } else {
                int n2 = stringArray[1].lastIndexOf(":");
                String string = stringArray[1].substring(0, n);
                String string3 = stringArray[1].substring(n + 1, n2);
                String string4 = stringArray[1].substring(n2 + 1);
                target = targetManager.getTargetByOracleHomeNameType(string, string3, string4);
            }
            if (target == null) {
                throw new TargetCmdException(TargetCmd.s_bundle.getMessage(CliMsgID.NO_SUCH_TARGET, false));
            }
            targetArray = new Target[]{target};
        }
        this.disableTargets(targetArray);
    }

    private void disableTargets(Target[] targetArray) throws TargetCmdException {
        TargetManager targetManager = TargetManager.getInstance();
        HashMap hashMap = targetManager.getAllCustomTargets();
        for (int i = 0; i < targetArray.length; ++i) {
            targetArray[i].disable(true);
            this.addReplaceTarget(hashMap, targetArray[i]);
        }
        this.writeCustomTargets(hashMap);
    }

    public String getInputPropmt() {
        String string = TargetCmd.s_bundle.getMessage(CliMsgID.DISABLE, false);
        return TargetCmd.s_bundle.getMessage(CliMsgID.TARGET_LIST_INPUT, false, (Object[])new String[]{string});
    }

    protected String getCommandName() {
        return "disable_target";
    }
}

