/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.InterruptException;
import oracle.sysman.ccr.collector.cli.TargetCmd;
import oracle.sysman.ccr.collector.cli.TargetCmdException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;

public class EnableTargetCmd
extends TargetCmd {
    public void executeCommand(String[] stringArray) throws TargetCmdException, InterruptException {
        TargetManager targetManager = TargetManager.getInstance();
        Vector vector = targetManager.getTargets(false);
        if (vector.isEmpty()) {
            this.setFeedbackNeeded(false);
            System.out.println(TargetCmd.s_bundle.getMessage(CliMsgID.NO_TARGETS_TO_ACT_ON, false, (Object[])new String[]{this.getCommandName()}));
            return;
        }
        this.quickSort(vector, 0, vector.size() - 1);
        Target[] targetArray = this.getSelectedTargets(vector);
        this.enableTargets(targetArray);
    }

    private void enableTargets(Target[] targetArray) throws TargetCmdException {
        TargetManager targetManager = TargetManager.getInstance();
        HashMap hashMap = targetManager.getAllCustomTargets();
        for (int i = 0; i < targetArray.length; ++i) {
            targetArray[i].disable(false);
            this.addReplaceTarget(hashMap, targetArray[i]);
        }
        this.writeCustomTargets(hashMap);
    }

    public String getInputPropmt() {
        String string = TargetCmd.s_bundle.getMessage(CliMsgID.ENABLE, false);
        return TargetCmd.s_bundle.getMessage(CliMsgID.TARGET_LIST_INPUT, false, (Object[])new String[]{string});
    }

    protected String getCommandName() {
        return "enable_target";
    }
}

