/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.CollectorCliCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.diagcheck.ConfigDiagcheckProps;
import oracle.sysman.ccr.collector.diagcheck.DiagcheckException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;

public class StatusDiagchecksCmd
extends CollectorCliCmd {
    private static Logger s_log = Logger.getInstance((Class)(class$oracle$sysman$ccr$collector$cli$ConfigDiagcheckCmd == null ? (class$oracle$sysman$ccr$collector$cli$ConfigDiagcheckCmd = StatusDiagchecksCmd.class$("oracle.sysman.ccr.collector.cli.ConfigDiagcheckCmd")) : class$oracle$sysman$ccr$collector$cli$ConfigDiagcheckCmd));
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cli.Cli");
    static /* synthetic */ Class class$oracle$sysman$ccr$collector$cli$ConfigDiagcheckCmd;

    public void executeCommand(String[] stringArray) throws CommandException {
        Object object;
        try {
            ConfigWriter configWriter = UplinkHomeConfigWriter.getInstance();
            object = configWriter.propertyValue("diagcheck.disable");
            if (Boolean.valueOf((String)object).booleanValue()) {
                System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_STATUS, false) + "        " + s_bundle.getMessage(CliMsgID.DIAGCHECKS_STATUS_DISABLED, false));
                return;
            }
        }
        catch (FileReadException fileReadException) {
            s_log.debug((Object)"Failed to open collector.properties file");
        }
        object = null;
        try {
            object = ConfigDiagcheckProps.findAuthAndMissingPropsErrors();
        }
        catch (DiagcheckException diagcheckException) {
            s_log.warn(CliMsgID.DIAGCHECKS_ERR_READING_DIAGCHECKSERR, (Throwable)((Object)diagcheckException));
        }
        if (!((HashMap)object).isEmpty()) {
            String string;
            System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_STATUS, false) + "        " + s_bundle.getMessage(CliMsgID.DIAGCHECKS_NEEDS_CONFIG, false) + "\n");
            System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_ERROR_DETAILS, false));
            Iterator iterator = ((HashMap)object).keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                String[] stringArray2 = new String[2];
                StringTokenizer stringTokenizer = new StringTokenizer(string, "##");
                for (int i = 0; stringTokenizer.hasMoreTokens() && i < 2; ++i) {
                    stringArray2[i] = stringTokenizer.nextToken();
                }
                int n = (Integer)((HashMap)object).get(string);
                System.out.print("[" + stringArray2[0] + ", " + stringArray2[1] + "]: ");
                switch (n) {
                    case 2: {
                        System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_AUTH_FAILURE, false));
                        break;
                    }
                    case 1: {
                        System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_MISSING_PROPS, false));
                        break;
                    }
                    case 3: {
                        System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_MISSING_PROPS, false) + ", " + s_bundle.getMessage(CliMsgID.DIAGCHECKS_AUTH_FAILURE, false));
                    }
                }
            }
            string = "configCCR -D [-T targetType [ -N targetName [-P propertyName]]]";
            System.out.println(s_bundle.getMessage(CliMsgID.DIAGCHECKS_RUN_CONFIGCCR_CMD, false, (Object[])new String[]{string}));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

