/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.ccr.collector.Collector;
import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.CollectorCliCmd;
import oracle.sysman.ccr.collector.cli.InterruptException;
import oracle.sysman.ccr.collector.cli.RangeException;
import oracle.sysman.ccr.collector.cli.TargetCmdException;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.security.AuthenticationFailure;
import oracle.sysman.ccr.collector.security.SecurityMgr;
import oracle.sysman.ccr.collector.targets.Target;
import oracle.sysman.ccr.collector.targets.TargetManager;
import oracle.sysman.ccr.common.MessageBundle;
import oracle.sysman.ccr.common.logging.Logger;

public abstract class TargetCmd
extends CollectorCliCmd {
    protected static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cli.Cli");
    private static Logger s_log = null;

    public TargetCmd() throws CommandException {
        Collector.configLogging();
        try {
            SecurityMgr.getInstance().getAuthenticationKey();
        }
        catch (AuthenticationFailure authenticationFailure) {
            throw new TargetCmdException(((Throwable)((Object)authenticationFailure)).getMessage());
        }
        TargetManager targetManager = TargetManager.getInstance();
        targetManager.discover();
        targetManager.processTargets();
        targetManager.processTargetMetadata();
    }

    public String getInputPropmt() {
        return "";
    }

    protected abstract String getCommandName();

    protected void writeCustomTargets(HashMap hashMap) throws TargetCmdException {
        try {
            TargetManager.getInstance().writeCustomTargets(hashMap);
        }
        catch (IOException iOException) {
            throw new TargetCmdException(s_bundle.getMessage(CliMsgID.CUSTOM_TARGETS_WRITE_ERR, false), (Throwable)iOException);
        }
    }

    protected String[] getDisplayTargetList(Vector vector, int[] nArray) throws TargetCmdException {
        int n;
        int n2;
        TargetManager targetManager = TargetManager.getInstance();
        int n3 = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        int n5 = 4;
        Target target = null;
        for (n2 = 0; n2 < n3; ++n2) {
            target = (Target)vector.get(n2);
            if (target.isCollectedByAnonymousCentralCollector() || (n = targetManager.getTargetTypeDisplayName(target.getTargetType()).length()) <= n4) continue;
            n4 = n;
        }
        arrayList.add(this.getTargetListTitle(n5, n4));
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            target = (Target)vector.get(n);
            if (target.isCollectedByAnonymousCentralCollector()) continue;
            String string = targetManager.getTargetTypeDisplayName(target.getTargetType());
            arrayList.add(this.formatString(String.valueOf(n2), string, target.getTargetName() + (string.equals("Oracle Home") ? "" : " " + s_bundle.getMessage(CliMsgID.AT, false) + " " + target.getTargetHome()), n5, n4));
            nArray[n2] = n;
            ++n2;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String getTargetListTitle(int n, int n2) {
        String string = s_bundle.getMessage(CliMsgID.CATEGORY, false);
        String string2 = s_bundle.getMessage(CliMsgID.SNO, false);
        String string3 = s_bundle.getMessage(CliMsgID.TARGET_NAME, false);
        n2 = n2 < string.length() ? string.length() : n2;
        n = n < string2.length() ? string2.length() : n;
        return this.formatString(string2, string, string3, n, n2);
    }

    private String formatString(String string, String string2, String string3, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = n - stringBuffer.length();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(' ');
        }
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        int n4 = n2 - stringBuffer2.length();
        for (int i = 0; i < n4; ++i) {
            stringBuffer2.append(' ');
        }
        return stringBuffer + " " + stringBuffer2 + "\t" + string3;
    }

    protected int[] getUniqueElements(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n = 1;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        if (nArray.length == 0 || nArray.length == 1) {
            return nArray2;
        }
        Arrays.sort(nArray2);
        for (int i = 1; i < nArray2.length; ++i) {
            if (nArray2[i] == nArray2[n - 1]) continue;
            nArray2[n++] = nArray2[i];
        }
        int[] nArray3 = new int[n];
        System.arraycopy(nArray2, 0, nArray3, 0, n);
        return nArray3;
    }

    protected void addReplaceTarget(HashMap hashMap, Target target) {
        HashMap<Vector, Target> hashMap2 = (HashMap<Vector, Target>)hashMap.get(target.getTargetType());
        if (hashMap2 == null) {
            hashMap2 = new HashMap<Vector, Target>();
            hashMap.put(target.getTargetType(), hashMap2);
        }
        hashMap2.put(target.getTargetKey(), target);
    }

    protected void delTargetFrmHash(HashMap hashMap, Target target) {
        HashMap hashMap2 = (HashMap)hashMap.get(target.getTargetType());
        hashMap2.remove(target.getTargetName());
        if (hashMap2.isEmpty()) {
            hashMap.remove(target.getTargetType());
        }
    }

    protected Target[] getSelectedTargets(Vector vector) throws TargetCmdException, InterruptException {
        int[] nArray = null;
        int[] nArray2 = new int[vector.size()];
        String[] stringArray = this.getDisplayTargetList(vector, nArray2);
        this.displayTargetList(stringArray);
        nArray = this.getSelections(0, stringArray.length - 1);
        nArray = this.getUniqueElements(nArray);
        Target[] targetArray = new Target[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            targetArray[i] = (Target)vector.get(nArray2[nArray[i]]);
        }
        return targetArray;
    }

    public void displayTargetList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        System.out.println("");
        System.out.println(s_bundle.getMessage(CliMsgID.TARGET_LIST_FOOTER, false));
    }

    public int[] getSelections(int n, int n2) throws InterruptException {
        String string = null;
        int[] nArray = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print(this.getInputPropmt());
            string = CollectorCliCmd.readString(bufferedReader);
            try {
                nArray = this.toNums(string);
                if (nArray.length == 0) {
                    throw new NumberFormatException();
                }
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= n && nArray[i] <= n2) continue;
                    throw new RangeException(String.valueOf(nArray[i]));
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(s_bundle.getMessage(CliMsgID.TARGET_LIST_INVALID_INPUT, false));
                continue;
            }
            catch (RangeException rangeException) {
                System.out.println(s_bundle.getMessage(CliMsgID.TARGET_NUM_OUT_OF_RANGE, false, (Object[])new String[]{((Throwable)((Object)rangeException)).getMessage()}));
                continue;
            }
            break;
        }
        return nArray;
    }

    private int[] toNums(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() == 0) continue;
            vector.add(Integer.valueOf(string2));
        }
        int n = vector.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        return nArray;
    }

    protected void quickSort(Vector vector, int n, int n2) {
        if (n2 > n) {
            String string = ((Target)vector.get(n)).getTargetType();
            int n3 = n;
            int n4 = n2;
            while (n3 < n4) {
                while (string.compareTo(((Target)vector.get(n3)).getTargetType()) >= 0 && n3 < n2) {
                    ++n3;
                }
                while (string.compareTo(((Target)vector.get(n4)).getTargetType()) <= 0 && n4 > n) {
                    --n4;
                }
                if (n3 >= n4) continue;
                this.swap(vector, n3, n4);
            }
            this.swap(vector, n4, n);
            this.quickSort(vector, n, n4 - 1);
            this.quickSort(vector, n4 + 1, n2);
        }
    }

    private void swap(Vector vector, int n, int n2) {
        Object e = vector.get(n);
        vector.set(n, vector.get(n2));
        vector.set(n2, e);
    }
}

