/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ccr.collector.cli;

import oracle.sysman.ccr.collector.cli.CliMsgID;
import oracle.sysman.ccr.collector.cli.CollectorCliCmd;
import oracle.sysman.ccr.collector.cmd.CommandException;
import oracle.sysman.ccr.collector.util.UplinkHomeConfig;
import oracle.sysman.ccr.collector.util.UplinkHomeConfigWriter;
import oracle.sysman.ccr.common.Config;
import oracle.sysman.ccr.common.ConfigWriter;
import oracle.sysman.ccr.common.FileReadException;
import oracle.sysman.ccr.common.FileWriteException;
import oracle.sysman.ccr.common.MessageBundle;

public class UpdatePropertyCmd
extends CollectorCliCmd {
    private static final String AUTOMATIC_UPDATE = "AUTOMATIC_UPDATE";
    private static final String ON = "on";
    private static final String OFF = "off";
    private static MessageBundle s_bundle = MessageBundle.getInstance((String)"oracle.sysman.ccr.collector.cli.Cli");
    private ConfigWriter m_homeConfigWriter = null;
    private ConfigWriter m_writer = null;
    private Config m_config = null;

    public void executeCommand(String[] stringArray) throws FileWriteException, CommandException {
        if (stringArray.length < 2) {
            throw new CommandException(s_bundle.getMessage(CliMsgID.NAME_VAL_MISSING, false));
        }
        this.initialize();
        String[] stringArray2 = this.cmdToPropertyNameVal(stringArray[0], stringArray[1]);
        if (stringArray2[1].equalsIgnoreCase(this.m_config.getProperty(stringArray2[0]))) {
            throw new CommandException(s_bundle.getMessage(CliMsgID.PROPERTY_VALUE_ALREADY_SET_ERR, false, (Object[])new String[]{stringArray[0].toUpperCase(), stringArray[1].toUpperCase()}));
        }
        this.m_writer.setProperty(stringArray2[0], stringArray2[1]);
        this.m_writer.persistProperties();
    }

    public static boolean isMyCommand(String string) {
        return AUTOMATIC_UPDATE.equalsIgnoreCase(string);
    }

    private void initialize() {
        try {
            this.m_homeConfigWriter = UplinkHomeConfigWriter.getInstance();
        }
        catch (FileReadException fileReadException) {
            System.err.println(fileReadException.getMessage());
        }
    }

    private String[] cmdToPropertyNameVal(String string, String string2) throws CommandException {
        String string3 = null;
        String string4 = null;
        if (string.equalsIgnoreCase(AUTOMATIC_UPDATE)) {
            string3 = "ccr.autoupdate";
            if (string2.equalsIgnoreCase(ON)) {
                string4 = String.valueOf(true);
            } else if (string2.equalsIgnoreCase(OFF)) {
                string4 = String.valueOf(false);
            }
        } else {
            throw new CommandException(s_bundle.getMessage(CliMsgID.NO_SUCH_PROP_ERR, false, (Object[])new String[]{string}));
        }
        this.m_config = UplinkHomeConfig.getInstance();
        this.m_writer = this.m_homeConfigWriter;
        if (string4 == null) {
            throw new CommandException(s_bundle.getMessage(CliMsgID.INVAL_COMMAND_VAL_ERR, false, (Object[])new String[]{string2, string}));
        }
        return new String[]{string3, string4};
    }
}

